/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.layout;

import com.metamatrix.common.util.ApplicationInfo;
import com.metamatrix.common.util.VMNaming;
import com.metamatrix.console.ConsolePlugin;
import com.metamatrix.toolbox.ToolboxPlugin;
import com.metamatrix.toolbox.ui.widget.AboutPanel;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.DialogPanel;
import com.metamatrix.toolbox.ui.widget.DialogWindow;
import com.metamatrix.toolbox.ui.widget.SpacerWidget;
import com.metamatrix.toolbox.ui.widget.SplashPanel;
import com.metamatrix.toolbox.ui.widget.util.BrowserControl;
import com.metamatrix.toolbox.ui.widget.util.IconFactory;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;

public class ConsoleAboutPanel
extends AboutPanel {
    @Override
    protected ButtonWidget createCancelButton() {
        return null;
    }

    @Override
    protected void initializeAboutPanel() {
        ApplicationInfo info = ApplicationInfo.getInstance();
        String alternateSplash = ConsolePlugin.Util.getString("Console.alternateSplash");
        ImageIcon splashIcon = null;
        if (alternateSplash != null && alternateSplash.trim().length() > 0) {
            splashIcon = IconFactory.getIconForImageFile(alternateSplash);
        }
        JPanel urlPnl = this.getUrlPanel();
        JPanel panel = null;
        if (splashIcon != null) {
            panel = new JPanel();
            GridBagLayout layout = new GridBagLayout();
            panel.setLayout(layout);
            JLabel label = new JLabel(splashIcon);
            panel.add(label);
            panel.add(urlPnl);
            layout.setConstraints(label, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
            layout.setConstraints(urlPnl, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 15, 1, new Insets(0, 0, 0, 0), 0, 0));
        } else {
            panel = new SplashPanel();
            panel.add(urlPnl);
        }
        this.setContent(panel);
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JTextArea box = new JTextArea(VMNaming.getHostInfo());
                box.setLineWrap(false);
                box.setEditable(false);
                DialogPanel panel = new DialogPanel(new JScrollPane(box)){

                    @Override
                    protected ButtonWidget createCancelButton() {
                        return null;
                    }
                };
                panel.addNavigationSpacer(SpacerWidget.createHorizontalExpandableSpacer());
                String details = ToolboxPlugin.Util.getString("AboutPanel.Application_Build_Details_5");
                DialogWindow.show(ConsoleAboutPanel.this, details, panel);
            }
        }, KeyStroke.getKeyStroke(68, 8), 2);
    }

    private JPanel getUrlPanel() {
        final String url = ConsolePlugin.Util.getString("ConsoleAboutPanel.url");
        JLabel label = new JLabel("<html><a href='" + url + "'>" + url + "</a></html>");
        label.addMouseListener(new MouseAdapter(){
            Cursor prevCursor = null;

            @Override
            public void mouseClicked(MouseEvent event) {
                BrowserControl.displayURL(url);
            }

            @Override
            public void mouseEntered(MouseEvent theEvent) {
                this.prevCursor = ConsoleAboutPanel.this.getCursor();
                ConsoleAboutPanel.this.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent theEvent) {
                ConsoleAboutPanel.this.setCursor(this.prevCursor);
            }
        });
        JPanel pnl = new JPanel();
        pnl.setOpaque(false);
        pnl.add(label);
        return pnl;
    }
}

