/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.layout;

import com.metamatrix.common.log.LogManager;
import com.metamatrix.console.ConsolePlugin;
import com.metamatrix.console.connections.ConnectionAndPanel;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.connections.ConnectionProcessor;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.ui.dialog.RefreshRatesDialog;
import com.metamatrix.console.ui.dialog.ServerURLsDialog;
import com.metamatrix.console.ui.layout.CDKCallbackHandler;
import com.metamatrix.console.ui.layout.ConsoleAboutPanel;
import com.metamatrix.console.ui.layout.ConsoleMenuBar;
import com.metamatrix.console.ui.layout.ConsoleMenuBarListener;
import com.metamatrix.console.ui.layout.PanelsTree;
import com.metamatrix.console.ui.layout.PanelsTreeModel;
import com.metamatrix.console.ui.layout.PanelsTreeScrollPane;
import com.metamatrix.console.ui.layout.TreeAndControllerCoordinator;
import com.metamatrix.console.ui.layout.UserPreferenceCallback;
import com.metamatrix.console.ui.layout.Workspace;
import com.metamatrix.console.ui.layout.WorkspaceController;
import com.metamatrix.console.ui.layout.WorkspacePanel;
import com.metamatrix.console.ui.util.RepaintController;
import com.metamatrix.console.ui.views.summary.SummaryPanel;
import com.metamatrix.console.util.Refreshable;
import com.metamatrix.console.util.StaticProperties;
import com.metamatrix.console.util.StaticTreeUtilities;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.toolbox.ui.widget.AboutDialog;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.Splitter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;

public class ConsoleMainFrame
extends JFrame
implements ConsoleMenuBarListener,
RepaintController {
    public static final String MAIN_FRAME_TITLE = ConsolePlugin.Util.getString("ConsoleMainFrame.title");
    public static final double SCREEN_HEIGHT_PROPORTION = 0.9;
    public static final double SCREEN_WIDTH_PROPORTION = 0.9;
    public static final double SPLITTER_RELATIVE_SETTING = 0.22;
    public static final Class INITIAL_PANEL_CLASS = PanelsTreeModel.SUMMARY_PANEL_CLASS;
    public static final boolean PANELS_TREE_ALWAYS_DISPLAYED = true;
    private static ConsoleMainFrame theFrame;
    private ConsoleMenuBar menuBar;
    private JSplitPane splitPane;
    private PanelsTree tree;
    private JPanel treePanel;
    private Workspace workspace;
    private WorkspaceController controller;
    private boolean hasBeenPainted = false;
    private CDKCallbackHandler handler;
    private boolean showingTree;
    private JComboBox connectionsComboBox;
    private JPanel connectionsPanel;
    private Map treeMap = new HashMap();

    private ConsoleMainFrame(boolean showingTree, ConnectionInfo initialConnection) {
        super(MAIN_FRAME_TITLE);
        this.showingTree = showingTree;
        this.init(initialConnection);
    }

    public static void createInstance(boolean showingTree, ConnectionInfo initialConnection) {
        if (theFrame != null) {
            String msg = "Attempt to create duplicate ConsoleMainFrame.";
            LogManager.logError((String)"INITIALIZATION", (String)msg);
            throw new RuntimeException(msg);
        }
        theFrame = new ConsoleMainFrame(showingTree, initialConnection);
    }

    public static ConsoleMainFrame getInstance() {
        return theFrame;
    }

    private void init(ConnectionInfo initialConnection) {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ConsoleMainFrame.this.exitItemSelected();
            }
        });
        this.handler = new CDKCallbackHandler();
        this.setDefaultCloseOperation(0);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = new Dimension((int)((double)screenSize.width * 0.9), (int)((double)screenSize.height * 0.9));
        this.setSize(size);
        this.setLocation(StaticUtilities.centerFrame(this.getSize()));
        this.tree = PanelsTree.createInstance(initialConnection);
        PanelsTreeScrollPane treeSP = new PanelsTreeScrollPane(this.tree);
        this.treeMap.put(initialConnection, treeSP);
        this.treePanel = new JPanel();
        this.treePanel.setBackground(Color.gray);
        this.setTreeScrollPane(treeSP);
        JPanel leftPanel = new JPanel();
        GridBagLayout ll = new GridBagLayout();
        leftPanel.setLayout(ll);
        Object[] connections = new Object[]{initialConnection};
        this.connectionsComboBox = new JComboBox<Object>(connections);
        Font font = this.connectionsComboBox.getFont();
        Font newFont = new Font(font.getName(), font.getStyle(), font.getSize() - 1);
        this.connectionsComboBox.setFont(newFont);
        this.connectionsComboBox.setSelectedItem(initialConnection);
        this.connectionsComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ev) {
                if (ev.getStateChange() == 1) {
                    ConsoleMainFrame.this.connectionSelectionChanged();
                }
            }
        });
        this.connectionsPanel = new JPanel();
        GridBagLayout cl = new GridBagLayout();
        this.connectionsPanel.setLayout(cl);
        LabelWidget connectionLabel = new LabelWidget("Connection:");
        this.connectionsPanel.add(connectionLabel);
        cl.setConstraints(connectionLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.connectionsPanel.add(this.connectionsComboBox);
        cl.setConstraints(this.connectionsComboBox, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        leftPanel.add(this.connectionsPanel);
        ll.setConstraints(this.connectionsPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        leftPanel.add(this.treePanel);
        ll.setConstraints(this.treePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.menuBar = ConsoleMenuBar.getInstance();
        ConsoleMenuBar.setTheListener(this);
        this.setJMenuBar(this.menuBar);
        Workspace.createInstance(this);
        this.workspace = Workspace.getInstance();
        WorkspaceController.createInstance(this.workspace);
        this.controller = WorkspaceController.getInstance();
        this.splitPane = new Splitter(1, true, leftPanel, this.workspace);
        this.splitPane.setOneTouchExpandable(true);
        if (this.showingTree) {
            this.getContentPane().add(this.splitPane);
        } else {
            this.getContentPane().add(this.workspace);
        }
        TreeAndControllerCoordinator.createInstance(this.tree, this.controller, initialConnection);
        TreeAndControllerCoordinator.getInstance(initialConnection);
        StaticTreeUtilities.expandAll(this.tree);
        this.setConnectionsPanelVisible(false);
    }

    private void setTreeScrollPane(PanelsTreeScrollPane treeSP) {
        this.treePanel.removeAll();
        GridBagLayout tl = new GridBagLayout();
        this.treePanel.setLayout(tl);
        this.treePanel.add(treeSP);
        tl.setConstraints(treeSP, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 2), 0, 0));
        this.tree = treeSP.getTree();
    }

    public void setConnectionsPanelVisible(boolean flag) {
        this.connectionsPanel.setVisible(flag);
    }

    public ConnectionInfo[] getConnections() {
        int numConnections = this.treeMap.size();
        ConnectionInfo[] connections = new ConnectionInfo[numConnections];
        Iterator it = this.treeMap.keySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            connections[i] = (ConnectionInfo)it.next();
            ++i;
        }
        return connections;
    }

    public void addConnection(ConnectionInfo connection, PanelsTree tree) {
        this.connectionsComboBox.addItem(connection);
        PanelsTreeScrollPane treeSP = new PanelsTreeScrollPane(tree);
        this.treeMap.put(connection, treeSP);
    }

    public void removeConnection(ConnectionInfo connection) {
        this.connectionsComboBox.removeItem(connection);
        this.treeMap.remove(connection);
    }

    private void connectionSelectionChanged() {
        if (this.connectionsPanel.isVisible()) {
            ConnectionInfo connection = (ConnectionInfo)this.connectionsComboBox.getSelectedItem();
            this.controller.connectionSelectionChanged(connection);
        }
    }

    public void selectConnection(ConnectionInfo connection) {
        this.connectionsComboBox.setSelectedItem(connection);
        this.repaintNeeded();
    }

    public void displayTreeForConnection(ConnectionInfo connection) {
        Iterator it = this.treeMap.entrySet().iterator();
        boolean done = false;
        while (!done) {
            Map.Entry me = it.next();
            ConnectionInfo thisConn = (ConnectionInfo)me.getKey();
            if (!connection.equals(thisConn)) continue;
            done = true;
            PanelsTreeScrollPane treeSP = (PanelsTreeScrollPane)me.getValue();
            this.setTreeScrollPane(treeSP);
        }
    }

    @Override
    public void repaintNeeded() {
        final int splitterLoc = this.splitPane.getDividerLocation();
        int incr = -1;
        if (splitterLoc == 0) {
            incr = 1;
        }
        final int increment = incr;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ConsoleMainFrame.this.splitPane.setDividerLocation(splitterLoc + increment);
                ConsoleMainFrame.this.splitPane.setDividerLocation(splitterLoc);
                WorkspacePanel panel = ConsoleMainFrame.this.workspace.getCurrentPanel();
                if (panel instanceof SummaryPanel) {
                    final SummaryPanel summary = (SummaryPanel)panel;
                    summary.addComponentListener(new ComponentAdapter(){

                        @Override
                        public void componentResized(ComponentEvent event) {
                            summary.updateTableColumnWidths();
                            summary.removeComponentListener(this);
                        }
                    });
                }
            }
        });
    }

    public void setShowingTree(boolean flag) {
        if (flag != this.showingTree) {
            this.showingTree = flag;
            if (this.showingTree) {
                this.getContentPane().remove(this.workspace);
                this.getContentPane().add(this.splitPane);
            } else {
                this.getContentPane().remove(this.splitPane);
                this.getContentPane().add(this.workspace);
            }
            this.repaintNeeded();
        }
    }

    public Component getMainTree() {
        return this.tree;
    }

    public void setInitialView(ConnectionInfo connection) {
        ConnectionAndPanel cp = new ConnectionAndPanel(connection, INITIAL_PANEL_CLASS, null);
        this.selectPanel(cp);
    }

    @Override
    public void urlsItemSelected() {
        ServerURLsDialog dialog = new ServerURLsDialog(this);
        dialog.createComponent();
        dialog.show();
    }

    @Override
    public void loggingItemSelected() {
        UserPreferenceCallback callback = new UserPreferenceCallback();
        try {
            this.handler.handle(callback, this);
        }
        catch (Exception e) {
            Assertion.failed((String)"There was an unknown error while trying to handle the UserPreferences callback.");
        }
    }

    @Override
    public void refreshItemSelected() {
        Thread thread = new Thread(){

            @Override
            public void run() {
                WorkspacePanel currentPanel;
                Workspace ws = Workspace.getInstance();
                if (ws != null && (currentPanel = ws.getCurrentPanel()) instanceof Refreshable) {
                    ((Refreshable)((Object)currentPanel)).refresh();
                }
            }
        };
        thread.start();
    }

    @Override
    public void refreshRatesItemSelected() {
        RefreshRatesDialog dialog = new RefreshRatesDialog(this);
        dialog.createComponent();
        dialog.show();
    }

    @Override
    public void aboutItemSelected() {
        String title = ConsolePlugin.Util.getString("ConsoleAboutDialog.title");
        AboutDialog.show((Component)this, title, new ConsoleAboutPanel());
    }

    @Override
    public void addConnectionItemSelected() {
        ConnectionProcessor cp = ConnectionProcessor.getInstance();
        cp.handleAddConnectionRequest();
    }

    @Override
    public void removeConnectionItemSelected() {
        ConnectionProcessor cp = ConnectionProcessor.getInstance();
        cp.handleRemoveConnectionRequest();
    }

    public void selectPanel(ConnectionAndPanel panel) {
        this.tree.selectNodeForPanel(panel);
    }

    @Override
    public void exitItemSelected() {
        Thread thread = new Thread(){

            @Override
            public void run() {
                boolean exiting = true;
                if (ConsoleMainFrame.this.controller != null && ConsoleMainFrame.this.controller.havePendingChanges()) {
                    exiting = ConsoleMainFrame.this.controller.finishUp();
                }
                if (exiting) {
                    ConsoleMainFrame.this.hide();
                    ConsoleMainFrame.this.logoff();
                    System.exit(0);
                }
            }
        };
        thread.start();
    }

    public void exitConsole() {
        this.exitItemSelected();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (!this.hasBeenPainted) {
            this.hasBeenPainted = true;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ConsoleMainFrame.this.postRealize();
                }
            });
        }
    }

    public void logoff() {
        try {
            StaticProperties.saveProperties();
        }
        catch (Exception ex) {
            // empty catch block
        }
        ConnectionInfo[] connections = ModelManager.getConnections();
        for (int i = 0; i < connections.length; ++i) {
            try {
                connections[i].close();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void postRealize() {
        this.splitPane.setDividerLocation(0.22);
    }
}

