/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.layout;

import com.metamatrix.console.ConsolePlugin;
import com.metamatrix.console.ui.layout.AboutAction;
import com.metamatrix.console.ui.layout.AddConnectionAction;
import com.metamatrix.console.ui.layout.ConsoleMenuBarListener;
import com.metamatrix.console.ui.layout.ExitAction;
import com.metamatrix.console.ui.layout.LoggingPreferencesAction;
import com.metamatrix.console.ui.layout.MenuEntry;
import com.metamatrix.console.ui.layout.RefreshAction;
import com.metamatrix.console.ui.layout.RefreshRatesAction;
import com.metamatrix.console.ui.layout.RemoveConnectionAction;
import com.metamatrix.console.ui.layout.URLsAction;
import com.metamatrix.console.ui.util.AbstractPanelAction;
import com.metamatrix.console.util.ExceptionUtility;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

public class ConsoleMenuBar
extends JMenuBar {
    public static final String FILE_MENU_HEADER = ConsolePlugin.Util.getString("ConsoleMenuBar.fileHeader");
    public static final String PREFERENCES_MENU_HEADER = ConsolePlugin.Util.getString("ConsoleMenuBar.preferencesHeader");
    public static final String CONNECTIONS_MENU_HEADER = ConsolePlugin.Util.getString("ConsoleMenuBar.connectionsHeader");
    public static final String VIEW_MENU_HEADER = ConsolePlugin.Util.getString("ConsoleMenuBar.viewHeader");
    public static final String PANELS_MENU_HEADER = ConsolePlugin.Util.getString("ConsoleMenuBar.panelsHeader");
    public static final String ACTIONS_MENU_HEADER = ConsolePlugin.Util.getString("ConsoleMenuBar.actionsHeader");
    public static final String HELP_MENU_HEADER = ConsolePlugin.Util.getString("ConsoleMenuBar.helpHeader");
    public static final String EXIT_HEADER = ConsolePlugin.Util.getString("ConsoleMenuBar.exitHeader");
    public static final String URLS_HEADER = ConsolePlugin.Util.getString("ConsoleMenuBar.urlsHeader");
    public static final String LOGGING_HEADER = ConsolePlugin.Util.getString("ConsoleMenuBar.logPrefsHeader");
    public static final String REFRESH_RATES_HEADER = ConsolePlugin.Util.getString("ConsoleMenuBar.refreshRatesHeader");
    public static final String REFRESH_HEADER = ConsolePlugin.Util.getString("ConsoleMenuBar.refreshHeader");
    public static final String ABOUT_HEADER = ConsolePlugin.Util.getString("ConsoleMenuBar.aboutHeader");
    public static final String PRINT_HEADER = ConsolePlugin.Util.getString("ConsoleMenuBar.printHeader");
    public static final String ADD_CONNECTION_HEADER = ConsolePlugin.Util.getString("ConsoleMenuBar.addConnectionHeader");
    public static final String REMOVE_CONNECTION_HEADER = ConsolePlugin.Util.getString("ConsoleMenuBar.remConnectionHeader");
    private JMenu fileMenu = null;
    private JMenu preferencesMenu = null;
    private JMenu connectionsMenu = null;
    private JMenu viewMenu = null;
    private JMenu actionsMenu = null;
    private JMenu helpMenu = null;
    private static ConsoleMenuBar theMenuBar = null;
    private static ConsoleMenuBarListener theListener = null;
    private Action actRefreshDefault = null;

    private ConsoleMenuBar() {
        this.init();
    }

    public static ConsoleMenuBar getInstance() {
        if (theMenuBar == null) {
            theMenuBar = new ConsoleMenuBar();
        }
        return theMenuBar;
    }

    public static void setTheListener(ConsoleMenuBarListener listener) {
        theListener = listener;
    }

    private void init() {
        this.addFileMenu();
        this.addPreferencesMenu();
        this.addConnectionsMenu();
        this.addViewMenu();
        this.addActionsMenu();
        this.addHelpMenu();
    }

    public ConsoleMenuBarListener getTheListener() {
        return theListener;
    }

    public void setDefaultRefreshEnabled(boolean flag) {
        this.actRefreshDefault.setEnabled(flag);
    }

    private void addFileMenu() {
        this.fileMenu = new JMenu(FILE_MENU_HEADER);
        ExitAction exitAction = new ExitAction(this);
        this.replaceMenuItem("file.exit", exitAction, this.fileMenu);
        this.add(this.fileMenu);
    }

    private void addPreferencesMenu() {
        this.preferencesMenu = new JMenu(PREFERENCES_MENU_HEADER);
        URLsAction urlsAction = new URLsAction(this);
        this.replaceMenuItem("prefs.urls", urlsAction, this.preferencesMenu);
        RefreshRatesAction refreshRatesAction = new RefreshRatesAction(this);
        this.replaceMenuItem("prefs.refreshrates", refreshRatesAction, this.preferencesMenu);
        LoggingPreferencesAction loggingPreferencesAction = new LoggingPreferencesAction(this);
        this.replaceMenuItem("prefs.logging", loggingPreferencesAction, this.preferencesMenu);
        this.add(this.preferencesMenu);
    }

    private void addConnectionsMenu() {
        this.connectionsMenu = new JMenu(CONNECTIONS_MENU_HEADER);
        AddConnectionAction addConnectionAction = new AddConnectionAction(this);
        this.replaceMenuItem("connections.addconnection", addConnectionAction, this.connectionsMenu);
        RemoveConnectionAction removeConnectionAction = new RemoveConnectionAction(this);
        this.replaceMenuItem("connections.removeconnection", removeConnectionAction, this.connectionsMenu);
        this.setRemoveConnectionEnabled(false);
        this.add(this.connectionsMenu);
    }

    private void addViewMenu() {
        this.viewMenu = new JMenu(VIEW_MENU_HEADER);
        this.actRefreshDefault = new RefreshAction(this);
        this.replaceMenuItem("view.refresh", this.actRefreshDefault, this.viewMenu);
        this.actRefreshDefault.setEnabled(false);
        this.add(this.viewMenu);
    }

    private void addActionsMenu() {
        this.actionsMenu = new JMenu(ACTIONS_MENU_HEADER);
        this.actionsMenu.setEnabled(false);
        this.add(this.actionsMenu);
    }

    private void addHelpMenu() {
        this.helpMenu = new JMenu(HELP_MENU_HEADER);
        AboutAction aboutAction = new AboutAction(this);
        this.replaceMenuItem("help.abouttheconsole", aboutAction, this.helpMenu);
        this.add(this.helpMenu);
    }

    public void setRemoveConnectionEnabled(boolean flag) {
        int i = 0;
        JMenuItem matchItem = null;
        while (matchItem == null) {
            JMenuItem item = this.connectionsMenu.getItem(i);
            if (item.getText().equals(REMOVE_CONNECTION_HEADER)) {
                matchItem = item;
                continue;
            }
            ++i;
        }
        matchItem.setEnabled(flag);
    }

    public void emptyTheActionsMenu() {
        this.actionsMenu.setPopupMenuVisible(false);
        this.actionsMenu.removeAll();
        this.actionsMenu.setEnabled(false);
    }

    public JMenuItem[] addActions(Action[] actions) {
        JMenuItem[] items = null;
        if (actions.length > 0) {
            this.actionsMenu.setEnabled(true);
            items = new JMenuItem[actions.length];
            for (int i = 0; i < actions.length; ++i) {
                items[i] = this.actionsMenu.add(actions[i]);
            }
        } else {
            items = new JMenuItem[]{};
        }
        return items;
    }

    public JMenuItem[] addActions(List actions) {
        JMenuItem[] items = null;
        int numActions = actions.size();
        if (numActions > 0) {
            this.actionsMenu.setEnabled(true);
            items = new JMenuItem[numActions];
            Iterator it = actions.iterator();
            int i = 0;
            while (it.hasNext()) {
                items[i] = this.actionsMenu.add((Action)it.next());
                ++i;
            }
        } else {
            items = new JMenuItem[]{};
        }
        return items;
    }

    public JMenuItem[] addActionsFromMenuEntryObjects(List lstMenuEntries) {
        this.restoreDefaultOverrideableMenuItems();
        ArrayList<MenuEntry> arylEntriesForActionsMenu = new ArrayList<MenuEntry>();
        MenuEntry meEntry2 = null;
        for (MenuEntry meEntry2 : lstMenuEntries) {
            if (meEntry2.getID().equals("action")) {
                arylEntriesForActionsMenu.add(meEntry2);
                continue;
            }
            if (meEntry2.getID().equals("separator")) {
                arylEntriesForActionsMenu.add(meEntry2);
                continue;
            }
            this.addToOtherMenus(meEntry2);
        }
        if (arylEntriesForActionsMenu.size() > 0) {
            return this.addMenuEntriesToActionsMenu(arylEntriesForActionsMenu);
        }
        return null;
    }

    private void restoreDefaultOverrideableMenuItems() {
        this.replaceMenuItem("view.refresh", this.actRefreshDefault, this.viewMenu);
    }

    private void addToOtherMenus(MenuEntry meEntry) {
        JMenu theMenu = null;
        String sID = meEntry.getID();
        if (sID.equals("file.print")) {
            theMenu = this.fileMenu;
        } else if (sID.equals("view.refresh")) {
            theMenu = this.viewMenu;
        } else {
            if (sID.equals("separator")) {
                return;
            }
            ExceptionUtility.showMessage("Bad MenuEntry ID: " + sID, new Exception(""));
        }
        this.replaceMenuItem(meEntry.getID(), meEntry.getAction(), theMenu);
    }

    private void replaceMenuItem(String sID, Action actNewAction, JMenu mnu) {
        JMenuItem mniTemp = null;
        int iMenuItems = mnu.getItemCount();
        AbstractPanelAction apaAction = null;
        boolean replaced = false;
        for (int ix = 0; ix < iMenuItems; ++ix) {
            mniTemp = mnu.getItem(ix);
            if (mniTemp == mnu || !mniTemp.getName().equals(sID)) continue;
            mnu.remove(ix);
            mniTemp = mnu.insert(actNewAction, ix);
            mniTemp.setName(sID);
            if (actNewAction instanceof AbstractPanelAction) {
                apaAction = (AbstractPanelAction)actNewAction;
                apaAction.addComponent(mniTemp);
            }
            replaced = true;
            break;
        }
        if (!replaced) {
            mniTemp = mnu.add(actNewAction);
            mniTemp.setName(sID);
            if (actNewAction instanceof AbstractPanelAction) {
                apaAction = (AbstractPanelAction)actNewAction;
                apaAction.addComponent(mniTemp);
            }
        }
    }

    public JMenuItem[] addMenuEntriesToActionsMenu(List lstMenuEntries) {
        JMenuItem[] aryMenuItems = null;
        ArrayList<JMenuItem> arylMenuItems = new ArrayList<JMenuItem>();
        AbstractPanelAction apaAction = null;
        int numActions = lstMenuEntries.size();
        this.emptyTheActionsMenu();
        if (numActions > 0) {
            this.actionsMenu.setEnabled(true);
            JMenuItem mniTemp = null;
            MenuEntry meEntry2 = null;
            for (MenuEntry meEntry2 : lstMenuEntries) {
                if (meEntry2.getID().equals("action")) {
                    mniTemp = this.actionsMenu.add(meEntry2.getAction());
                    arylMenuItems.add(mniTemp);
                    if (!(meEntry2.getAction() instanceof AbstractPanelAction)) continue;
                    apaAction = (AbstractPanelAction)meEntry2.getAction();
                    apaAction.addComponent(mniTemp);
                    continue;
                }
                if (meEntry2.getType() != 3) continue;
                this.actionsMenu.addSeparator();
            }
            aryMenuItems = new JMenuItem[arylMenuItems.size()];
            arylMenuItems.toArray(aryMenuItems);
        } else {
            aryMenuItems = new JMenuItem[]{};
        }
        return aryMenuItems;
    }

    public JMenuItem[] setActions(Action[] actions) {
        this.emptyTheActionsMenu();
        return this.addActions(actions);
    }

    public JMenuItem[] setActions(List actions) {
        this.emptyTheActionsMenu();
        return this.addActions(actions);
    }

    public void removeActionItem(JMenuItem item) {
        this.actionsMenu.remove(item);
        if (this.actionsMenu.getItemCount() == 0) {
            this.actionsMenu.setEnabled(false);
        }
    }

    public void removeActionItem(String itemLabel) {
        int i = 0;
        boolean removed = false;
        int itemCount = this.actionsMenu.getItemCount();
        while (!removed && i < itemCount) {
            JMenuItem mi = this.actionsMenu.getItem(i);
            if (mi.getText().equals(itemLabel)) {
                this.actionsMenu.remove(i);
                removed = true;
                continue;
            }
            ++i;
        }
    }
}

