/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.layout;

import com.metamatrix.console.connections.ConnectionAndPanel;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.ui.layout.ConsoleMainFrame;
import com.metamatrix.console.ui.layout.ConsoleMenuBar;
import com.metamatrix.console.ui.layout.PanelsTreeModel;
import com.metamatrix.console.ui.layout.PanelsTreeNode;
import com.metamatrix.console.ui.util.IconComponent;
import com.metamatrix.console.ui.util.ItemsBlockedCallback;
import com.metamatrix.console.ui.util.ItemsBlockedTreeSelectionListener;
import com.metamatrix.console.util.StaticTreeUtilities;
import com.metamatrix.toolbox.ui.widget.PopupMenuFactory;
import com.metamatrix.toolbox.ui.widget.TreeWidget;
import com.metamatrix.toolbox.ui.widget.tree.DefaultTreeCellRenderer;
import com.metamatrix.toolbox.ui.widget.util.IconFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class PanelsTree
extends TreeWidget
implements ItemsBlockedCallback,
PopupMenuFactory {
    public static final Color UNSELECTED_BACKGROUND_COLOR = new Color(240, 240, 255);
    public static final Color SELECTED_BACKGROUND_COLOR = new Color(204, 204, 255);
    private static final ImageIcon AUTH_HDR_ICON = IconFactory.getIconForImageFile("authorization_medium.gif");
    private static final ImageIcon AUTH_ICON = IconFactory.getIconForImageFile("authorization_small.gif");
    private static final ImageIcon CONFIG_HDR_ICON = IconFactory.getIconForImageFile("configuration_medium.gif");
    private static final ImageIcon CONFIG_ICON = IconFactory.getIconForImageFile("configuration_small.gif");
    private static final ImageIcon MM_SERVER_ICON = IconFactory.getIconForImageFile("mm_server_small.jpg");
    private static final ImageIcon MB_SERVER_ICON = IconFactory.getIconForImageFile("md_server_small.jpg");
    private static final ImageIcon RUNTIME_HDR_ICON = IconFactory.getIconForImageFile("runtime_medium.gif");
    private static final ImageIcon RUNTIME_ICON = IconFactory.getIconForImageFile("runtime_small.gif");
    private static Map treeMap = new HashMap();
    private TreePath selectedTreePath = null;
    private boolean selectionCancellation = false;
    private JCheckBoxMenuItem showPanelsTreeMenuItem;
    private Map treePathMap;
    private ConnectionInfo connection;

    private PanelsTree(PanelsTreeModel model, ConnectionInfo connection) {
        super(model);
        this.connection = connection;
        this.init();
    }

    public static PanelsTree getInstance(ConnectionInfo connection) {
        PanelsTree tree = (PanelsTree)treeMap.get(connection);
        return tree;
    }

    public static void removeInstance(ConnectionInfo connection) {
        treeMap.remove(connection);
    }

    public static PanelsTree createInstance(ConnectionInfo connection) {
        PanelsTreeModel model = PanelsTreeModel.createInstance(connection);
        PanelsTree tree = new PanelsTree(model, connection);
        StaticTreeUtilities.expandAll(tree);
        treeMap.put(connection, tree);
        return tree;
    }

    public ConnectionInfo getConnection() {
        return this.connection;
    }

    @Override
    public String getToolTipText(MouseEvent theEvent) {
        TreePath path = this.getPathForLocation(theEvent.getX(), theEvent.getY());
        if (path == null) {
            return null;
        }
        PanelsTreeNode node = (PanelsTreeNode)path.getLastPathComponent();
        return node.getToolTipText();
    }

    private void init() {
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setBackground(UNSELECTED_BACKGROUND_COLOR);
        this.setCellRenderer(new PanelsTreeCellRenderer());
        this.addTreeSelectionListener(new ItemsBlockedTreeSelectionListener(this, this));
        this.setPopupMenuFactory(this);
        this.setTreePathMap();
    }

    private void setTreePathMap() {
        this.treePathMap = new HashMap();
        TreePath[] leafNodePaths = StaticTreeUtilities.allTreePathsToLeafNodes(this.getModel());
        for (int i = 0; i < leafNodePaths.length; ++i) {
            String text = leafNodePaths[i].getLastPathComponent().toString();
            this.treePathMap.put(text, leafNodePaths[i]);
        }
    }

    public boolean isSelectionCancellation() {
        return this.selectionCancellation;
    }

    @Override
    public void itemSelectionBlocked() {
        if (this.selectedTreePath != null) {
            this.selectionCancellation = true;
            this.getSelectionModel().setSelectionPath(this.selectedTreePath);
            this.selectionCancellation = false;
        }
    }

    @Override
    public void itemSelectionChanged(TreePath newPath) {
        this.selectedTreePath = newPath;
    }

    @Override
    public Object[] getBlockedItems() {
        Object[] alwaysBlockedItems = PanelsTreeModel.BLOCKED_ITEMS;
        ArrayList<Object> blockedItems = new ArrayList<Object>();
        for (int i = 0; i < alwaysBlockedItems.length; ++i) {
            blockedItems.add(alwaysBlockedItems[i]);
        }
        List nodesList = StaticTreeUtilities.descendantsOfNode((DefaultMutableTreeNode)this.getModel().getRoot(), false);
        for (PanelsTreeNode node : nodesList) {
            if (!node.isConnectionNode()) continue;
            blockedItems.add(node);
        }
        Object[] blockedItemsArray = new Object[blockedItems.size()];
        Iterator it = blockedItems.iterator();
        int i = 0;
        while (it.hasNext()) {
            blockedItemsArray[i] = it.next();
            ++i;
        }
        return blockedItemsArray;
    }

    public void selectNodeForPanel(ConnectionAndPanel thePanel) {
        PanelsTreeModel model = (PanelsTreeModel)this.getModel();
        TreePath path = model.getPathForPanel(thePanel);
        this.setSelectionPath(path);
        this.scrollRowToVisible(this.getRowForPath(path));
    }

    @Override
    public JPopupMenu getPopupMenu(Component c) {
        JPopupMenu menu = null;
        if (c == this) {
            menu = new JPopupMenu();
        }
        return menu;
    }

    public JMenu createPanelsMenu() {
        JMenu menu = new JMenu(ConsoleMenuBar.PANELS_MENU_HEADER);
        PanelsTreeModel model = (PanelsTreeModel)this.getModel();
        TreePath[] leafNodePaths = StaticTreeUtilities.allTreePathsToLeafNodes(model);
        Icon prevFirstIcon = null;
        for (int i = 0; i < leafNodePaths.length; ++i) {
            String secondNodeName;
            ArrayList<ImageIcon> icons = new ArrayList<ImageIcon>(2);
            PanelsTreeNode firstNode = (PanelsTreeNode)leafNodePaths[i].getPathComponent(0);
            PanelsTreeNode secondNode = null;
            if (firstNode.isRoot()) {
                firstNode = (PanelsTreeNode)leafNodePaths[i].getPathComponent(1);
                secondNode = (PanelsTreeNode)leafNodePaths[i].getPathComponent(2);
            } else {
                secondNode = (PanelsTreeNode)leafNodePaths[i].getPathComponent(1);
            }
            String hdrText = model.getHeaderNodeText(firstNode);
            if (hdrText.equals("Runtime Management")) {
                icons.add(RUNTIME_ICON);
            } else if (hdrText.equals("Configuration")) {
                icons.add(CONFIG_ICON);
            } else if (hdrText.equals("Security")) {
                icons.add(AUTH_ICON);
            }
            if (secondNode.getChildCount() > 0 && (secondNodeName = secondNode.getName()).equals("Integration Server")) {
                icons.add(MM_SERVER_ICON);
            }
            Icon[] iconsArray = new Icon[icons.size()];
            Iterator it = icons.iterator();
            int j = 0;
            while (it.hasNext()) {
                iconsArray[j] = (Icon)it.next();
                ++j;
            }
            if (prevFirstIcon != null && iconsArray[0] != prevFirstIcon) {
                menu.addSeparator();
            }
            prevFirstIcon = iconsArray[0];
            IconComponent menuEntryIcon = new IconComponent(iconsArray);
            final String text = leafNodePaths[i].getLastPathComponent().toString();
            JMenuItem menuItem = new JMenuItem(text, menuEntryIcon);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    PanelsTree.this.menuItemSelected(text);
                }
            });
            menu.add(menuItem);
        }
        menu.addSeparator();
        this.showPanelsTreeMenuItem = new JCheckBoxMenuItem("Show panels tree", true);
        this.showPanelsTreeMenuItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ev) {
                PanelsTree.this.showPanelsTreeStateChanged();
            }
        });
        menu.add(this.showPanelsTreeMenuItem);
        return menu;
    }

    private void menuItemSelected(String menuItemText) {
        TreePath tp = (TreePath)this.treePathMap.get(menuItemText);
        if (tp != null) {
            this.setSelectionPath(tp);
        }
    }

    private void showPanelsTreeStateChanged() {
        boolean curState = this.showPanelsTreeMenuItem.isSelected();
        ConsoleMainFrame.getInstance().setShowingTree(curState);
    }

    private class PanelsTreeCellRenderer
    extends DefaultTreeCellRenderer {
        @Override
        public Color getBackgroundNonSelectionColor() {
            return UNSELECTED_BACKGROUND_COLOR;
        }

        @Override
        public Color getBackgroundSelectionColor() {
            return SELECTED_BACKGROUND_COLOR;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean isExpanded, boolean isLeaf, int row, boolean hasFocus) {
            if (value == null) {
                return this;
            }
            super.getTreeCellRendererComponent(tree, value, isSelected, isExpanded, isLeaf, row, hasFocus);
            PanelsTreeModel model = (PanelsTreeModel)tree.getModel();
            PanelsTreeNode node = (PanelsTreeNode)value;
            String hdrTxt = model.getHeaderNodeText(node);
            if (hdrTxt != null) {
                if (node.getName().equals("Integration Server")) {
                    this.setIcon(MM_SERVER_ICON);
                } else if (hdrTxt.equals("Runtime Management")) {
                    this.setIcon(node.getName().equals("Runtime Management") ? RUNTIME_HDR_ICON : RUNTIME_ICON);
                } else if (hdrTxt.equals("Configuration")) {
                    this.setIcon(node.getName().equals("Configuration") ? CONFIG_HDR_ICON : CONFIG_ICON);
                } else if (hdrTxt.equals("Security")) {
                    this.setIcon(node.getName().equals("Security") ? AUTH_HDR_ICON : AUTH_ICON);
                }
            }
            return this;
        }
    }
}

