/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.layout;

import com.metamatrix.console.ConsolePlugin;
import com.metamatrix.console.connections.ConnectionAndPanel;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.ui.layout.PanelsTreeNode;
import com.metamatrix.console.ui.views.authorization.ProvidersMain;
import com.metamatrix.console.ui.views.authorization.SummaryMain;
import com.metamatrix.console.ui.views.connector.ConnectorPanel;
import com.metamatrix.console.ui.views.connectorbinding.ConnectorBindingPanel;
import com.metamatrix.console.ui.views.deploy.DeployMainPanel;
import com.metamatrix.console.ui.views.entitlements.EntitlementsPanel;
import com.metamatrix.console.ui.views.extensionsource.ExtensionSourcesPanel;
import com.metamatrix.console.ui.views.logsetup.SystemLogSetUpPanel;
import com.metamatrix.console.ui.views.properties.PropertiesMasterPanel;
import com.metamatrix.console.ui.views.queries.QueryPanel;
import com.metamatrix.console.ui.views.resources.ResourcesMainPanel;
import com.metamatrix.console.ui.views.runtime.RuntimeMgmtPanel;
import com.metamatrix.console.ui.views.sessions.SessionPanel;
import com.metamatrix.console.ui.views.summary.SummaryPanel;
import com.metamatrix.console.ui.views.syslog.SysLogPanel;
import com.metamatrix.console.ui.views.users.AdminRolesMain;
import com.metamatrix.console.ui.views.vdb.VdbMainPanel;
import com.metamatrix.console.util.StaticTreeUtilities;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class PanelsTreeModel
extends DefaultTreeModel {
    public static final String RUNTIME = "Runtime Management";
    public static final String SUMMARY = "Summary";
    public static final Class SUMMARY_PANEL_CLASS = SummaryPanel.class;
    public static final String SESSIONS = "Sessions";
    public static final Class SESSIONS_PANEL_CLASS = SessionPanel.class;
    public static final String SYS_STATE = "System State";
    public static final Class RUNTIME_MGMT_PANEL_CLASS = RuntimeMgmtPanel.class;
    public static final String SYS_LOG = "Log Viewer";
    public static final Class SYSTEM_LOG_PANEL_CLASS = SysLogPanel.class;
    public static final String MM_SERVER = "Integration Server";
    public static final String QUERIES = "Queries";
    public static final Class QUERIES_PANEL_CLASS = QueryPanel.class;
    public static final String CONFIGURATION = "Configuration";
    public static final String SYS_PROPS = "System Properties";
    public static final Class SYSTEM_PROPERTIES_PANEL_CLASS = PropertiesMasterPanel.class;
    public static final String POOLS_CONFIG = "Connection Pools";
    public static final String RESOURCES = "Resources";
    public static final Class RESOURCES_PANEL_CLASS = ResourcesMainPanel.class;
    public static final String PSC_DEPLOY = "Deployment";
    public static final Class DEPLOY_PSC_DEFN_PANEL_CLASS = DeployMainPanel.class;
    public static final String VDB = "Virtual Databases";
    public static final Class VDB_PANEL_CLASS = VdbMainPanel.class;
    public static final String CONNECTORS = "Connector Types";
    public static final Class CONNECTOR_DEFINITIONS_PANEL_CLASS = ConnectorPanel.class;
    public static final String CONNECTOR_BINDINGS = "Connector Bindings";
    public static final Class CONNECTOR_BINDINGS_PANEL_CLASS = ConnectorBindingPanel.class;
    public static final String AUTHORIZATION = "Security";
    public static final String AUTHORIZATION_SUMMARY = "Summary";
    public static final Class AUTHORIZATION_SUMMARY_PANEL_CLASS = SummaryMain.class;
    public static final String DOMAIN_PROVIDERS = "Membership Domain Providers";
    public static final Class AUTHORIZATION_PROVIDERS_PANEL_CLASS = ProvidersMain.class;
    public static final String ADMIN_ROLES = "Admin Roles";
    public static final Class ADMIN_ROLES_PANEL_CLASS = AdminRolesMain.class;
    public static final String DATA_ROLES = "Data Roles";
    public static final Class ENTITLEMENTS_VIEW_PANEL_CLASS = EntitlementsPanel.class;
    public static final String METADATA_ROLES = "Repository Roles";
    public static final String EXTENSION_SOURCES = "Extension Modules";
    public static final Class EXTENSION_SOURCES_CLASS = ExtensionSourcesPanel.class;
    public static final String SYSTEMLOGSETUP = "Log Settings";
    public static final Class SYSTEMLOGSETUP_PANEL_CLASS = SystemLogSetUpPanel.class;
    public static final Object[] BLOCKED_ITEMS = new Object[]{"Runtime Management", "Integration Server", "Configuration", "Security"};
    private static final String MM_SERV_TIP = "The Integration Server product provides integrated information access to disparate data sources";
    private static PanelsTreeModel theModel = null;

    private PanelsTreeModel(PanelsTreeNode root, ConnectionInfo connection) {
        super(root);
        this.addConnection(connection, null);
    }

    public static PanelsTreeModel createInstance(ConnectionInfo connection) {
        PanelsTreeNode root = new PanelsTreeNode("root", null, null, false);
        theModel = new PanelsTreeModel(root, connection);
        return theModel;
    }

    public TreePath getPathForPanel(ConnectionAndPanel panel) {
        TreePath tp = null;
        TreePath[] paths = StaticTreeUtilities.allTreePathsToLeafNodes(this);
        int i = 0;
        while (i < paths.length && tp == null) {
            PanelsTreeNode lastNode = (PanelsTreeNode)paths[i].getLastPathComponent();
            ConnectionInfo lastNodeConnection = lastNode.getConnection();
            Class lastNodePanelClass = lastNode.getPanelClass();
            if (panel.getConnection().equals(lastNodeConnection) && panel.getPanelClass().equals(lastNodePanelClass)) {
                tp = paths[i];
                continue;
            }
            ++i;
        }
        return tp;
    }

    public void addConnection(ConnectionInfo connection, PanelsTreeNode connectionNode) {
        PanelsTreeNode nodeToAddTo;
        PanelsTreeNode root = (PanelsTreeNode)this.getRoot();
        if (connectionNode != null) {
            root.add(connectionNode);
            nodeToAddTo = connectionNode;
        } else {
            nodeToAddTo = root;
        }
        PanelsTreeNode runtime = new PanelsTreeNode(RUNTIME, null, connection, false);
        String tipText = ConsolePlugin.Util.getString("PanelsTreeModel.runtimePanel.tooltip");
        runtime.setToolTipText(tipText);
        nodeToAddTo.add(runtime);
        PanelsTreeNode summary = new PanelsTreeNode("Summary", SUMMARY_PANEL_CLASS, connection, false);
        tipText = ConsolePlugin.Util.getString("PanelsTreeModel.summaryPanel.tooltip");
        summary.setToolTipText(tipText);
        runtime.add(summary);
        PanelsTreeNode sessions = new PanelsTreeNode(SESSIONS, SESSIONS_PANEL_CLASS, connection, false);
        tipText = ConsolePlugin.Util.getString("PanelsTreeModel.sessionsPanel.tooltip");
        sessions.setToolTipText(tipText);
        runtime.add(sessions);
        PanelsTreeNode sysState = new PanelsTreeNode(SYS_STATE, RUNTIME_MGMT_PANEL_CLASS, connection, false);
        tipText = ConsolePlugin.Util.getString("PanelsTreeModel.sysStatePanel.tooltip");
        sysState.setToolTipText(tipText);
        runtime.add(sysState);
        PanelsTreeNode log = new PanelsTreeNode(SYS_LOG, SYSTEM_LOG_PANEL_CLASS, connection, false);
        tipText = ConsolePlugin.Util.getString("PanelsTreeModel.sysLogPanel.tooltip");
        log.setToolTipText(tipText);
        runtime.add(log);
        PanelsTreeNode runtimeMMServer = new PanelsTreeNode(MM_SERVER, null, connection, false);
        runtimeMMServer.setToolTipText(MM_SERV_TIP);
        runtime.add(runtimeMMServer);
        PanelsTreeNode queries = new PanelsTreeNode(QUERIES, QUERIES_PANEL_CLASS, connection, false);
        tipText = ConsolePlugin.Util.getString("PanelsTreeModel.queryPanel.tooltip");
        queries.setToolTipText(tipText);
        runtimeMMServer.add(queries);
        PanelsTreeNode configuration = new PanelsTreeNode(CONFIGURATION, null, connection, false);
        tipText = ConsolePlugin.Util.getString("PanelsTreeModel.configPanel.tooltip");
        configuration.setToolTipText(tipText);
        nodeToAddTo.add(configuration);
        PanelsTreeNode pscDeploy = new PanelsTreeNode(PSC_DEPLOY, DEPLOY_PSC_DEFN_PANEL_CLASS, connection, false);
        tipText = ConsolePlugin.Util.getString("PanelsTreeModel.pscDeployPanel.tooltip");
        pscDeploy.setToolTipText(tipText);
        configuration.add(pscDeploy);
        PanelsTreeNode props = new PanelsTreeNode(SYS_PROPS, SYSTEM_PROPERTIES_PANEL_CLASS, connection, false);
        tipText = ConsolePlugin.Util.getString("PanelsTreeModel.systemPropsPanel.tooltip");
        props.setToolTipText(tipText);
        configuration.add(props);
        PanelsTreeNode resources = new PanelsTreeNode(RESOURCES, RESOURCES_PANEL_CLASS, connection, false);
        tipText = ConsolePlugin.Util.getString("PanelsTreeModel.resourcesPanel.tooltip");
        resources.setToolTipText(tipText);
        configuration.add(resources);
        PanelsTreeNode extSrc = new PanelsTreeNode(EXTENSION_SOURCES, EXTENSION_SOURCES_CLASS, connection, false);
        tipText = ConsolePlugin.Util.getString("PanelsTreeModel.extSourcesPanel.tooltip");
        extSrc.setToolTipText(tipText);
        configuration.add(extSrc);
        PanelsTreeNode systeLogSetup = new PanelsTreeNode(SYSTEMLOGSETUP, SYSTEMLOGSETUP_PANEL_CLASS, connection, false);
        tipText = ConsolePlugin.Util.getString("PanelsTreeModel.sysLoggingPanel.tooltip");
        systeLogSetup.setToolTipText(tipText);
        configuration.add(systeLogSetup);
        PanelsTreeNode configMMServer = new PanelsTreeNode(MM_SERVER, null, connection, false);
        configMMServer.setToolTipText(MM_SERV_TIP);
        configuration.add(configMMServer);
        PanelsTreeNode vdb = new PanelsTreeNode(VDB, VDB_PANEL_CLASS, connection, false);
        tipText = ConsolePlugin.Util.getString("PanelsTreeModel.vdbPanel.tooltip");
        vdb.setToolTipText(tipText);
        configMMServer.add(vdb);
        PanelsTreeNode bindings = new PanelsTreeNode(CONNECTOR_BINDINGS, CONNECTOR_BINDINGS_PANEL_CLASS, connection, false);
        tipText = ConsolePlugin.Util.getString("PanelsTreeModel.bindingsPanel.tooltip");
        bindings.setToolTipText(tipText);
        configMMServer.add(bindings);
        PanelsTreeNode connectors = new PanelsTreeNode(CONNECTORS, CONNECTOR_DEFINITIONS_PANEL_CLASS, connection, false);
        tipText = ConsolePlugin.Util.getString("PanelsTreeModel.connectorsPanel.tooltip");
        connectors.setToolTipText(tipText);
        configMMServer.add(connectors);
        PanelsTreeNode securityNode = new PanelsTreeNode(AUTHORIZATION, null, connection, false);
        tipText = ConsolePlugin.Util.getString("PanelsTreeModel.securityPanel.tooltip");
        securityNode.setToolTipText(tipText);
        nodeToAddTo.add(securityNode);
        PanelsTreeNode authSummary = new PanelsTreeNode("Summary", AUTHORIZATION_SUMMARY_PANEL_CLASS, connection, false);
        tipText = ConsolePlugin.Util.getString("PanelsTreeModel.authSummaryPanel.tooltip");
        authSummary.setToolTipText(tipText);
        securityNode.add(authSummary);
        PanelsTreeNode providers = new PanelsTreeNode(DOMAIN_PROVIDERS, AUTHORIZATION_PROVIDERS_PANEL_CLASS, connection, false);
        tipText = ConsolePlugin.Util.getString("PanelsTreeModel.domainProvidersPanel.tooltip");
        providers.setToolTipText(tipText);
        securityNode.add(providers);
        PanelsTreeNode roles = new PanelsTreeNode(ADMIN_ROLES, ADMIN_ROLES_PANEL_CLASS, connection, false);
        tipText = ConsolePlugin.Util.getString("PanelsTreeModel.adminRolesPanel.tooltip");
        roles.setToolTipText(tipText);
        securityNode.add(roles);
        PanelsTreeNode entitlements = new PanelsTreeNode(DATA_ROLES, ENTITLEMENTS_VIEW_PANEL_CLASS, connection, false);
        tipText = ConsolePlugin.Util.getString("PanelsTreeModel.dataRolesPanel.tooltip");
        entitlements.setToolTipText(tipText);
        securityNode.add(entitlements);
    }

    public String getHeaderNodeText(PanelsTreeNode theNode) {
        PanelsTreeNode parent = (PanelsTreeNode)theNode.getParent();
        if (parent == null) {
            return null;
        }
        if (!parent.equals(this.getRoot())) {
            return this.getHeaderNodeText(parent);
        }
        return theNode.getName();
    }
}

