/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.layout;

import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.ui.layout.PanelsTree;
import com.metamatrix.console.ui.layout.PanelsTreeNode;
import com.metamatrix.console.ui.layout.WorkspaceController;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class TreeAndControllerCoordinator {
    private static Map controllerMap = new HashMap();
    private static WorkspaceController controller;
    private PanelsTree tree;

    private TreeAndControllerCoordinator(PanelsTree tr, WorkspaceController ctrlr) {
        this.tree = tr;
        controller = ctrlr;
        this.init();
    }

    public static void createInstance(PanelsTree tree, WorkspaceController cntrlr, ConnectionInfo connection) {
        TreeAndControllerCoordinator coordinator = new TreeAndControllerCoordinator(tree, controller);
        controllerMap.put(connection, coordinator);
        if (controller == null) {
            controller = cntrlr;
        }
    }

    public static TreeAndControllerCoordinator getInstance(ConnectionInfo connection) {
        TreeAndControllerCoordinator coordinator = null;
        Iterator it = controllerMap.entrySet().iterator();
        while (it.hasNext() && coordinator == null) {
            Map.Entry me = it.next();
            ConnectionInfo conn = (ConnectionInfo)me.getKey();
            if (!conn.equals(connection)) continue;
            coordinator = (TreeAndControllerCoordinator)me.getValue();
        }
        return coordinator;
    }

    private void init() {
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent ev) {
                TreeAndControllerCoordinator.this.treeSelectionChanged(ev);
            }
        });
    }

    private void treeSelectionChanged(TreeSelectionEvent ev) {
        TreePath tp;
        if (!this.tree.isSelectionCancellation() && (tp = ev.getNewLeadSelectionPath()) != null) {
            ConnectionInfo connection = this.tree.getConnection();
            PanelsTreeNode node = (PanelsTreeNode)tp.getLastPathComponent();
            Class cls = node.getPanelClass();
            if (cls != null && !controller.isChangingConnections()) {
                controller.treeSelectionChangedToClass(cls, true, connection);
            }
        }
    }
}

