/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.layout;

import com.metamatrix.common.log.LogManager;
import com.metamatrix.console.ConsolePlugin;
import com.metamatrix.console.ui.layout.ConsoleMainFrame;
import com.metamatrix.console.ui.layout.PanelsTree;
import com.metamatrix.console.ui.layout.WorkspacePanel;
import com.metamatrix.console.ui.util.RepaintController;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class Workspace
extends JPanel {
    private static Workspace theWorkspace = null;
    private WorkspacePanel currentPanel = null;
    private RepaintController repaintController;
    private LabelWidget lbl;
    private ConsoleMainFrame mainFrame;
    private GridBagConstraints gbc;

    private Workspace(RepaintController rc) {
        this.repaintController = rc;
        this.setLayout(new GridBagLayout());
        JPanel pnl = new JPanel();
        pnl.setBackground(PanelsTree.UNSELECTED_BACKGROUND_COLOR);
        pnl.setBorder(BorderFactory.createEtchedBorder());
        GridBagLayout pnlLayout = new GridBagLayout();
        pnl.setLayout(pnlLayout);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.anchor = 17;
        this.gbc.fill = 2;
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 0.0;
        this.gbc.insets = new Insets(5, 5, 5, 5);
        this.add((Component)pnl, this.gbc);
        this.lbl = new LabelWidget();
        Font font = this.lbl.getFont();
        font = font.deriveFont(1);
        this.lbl.setFont(font.deriveFont(font.getSize2D() * 1.5f));
        pnl.add(this.lbl);
        pnlLayout.setConstraints(this.lbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        ++this.gbc.gridy;
        this.gbc.fill = 1;
        this.gbc.weighty = 1.0;
        this.gbc.insets = new Insets(5, 5, 5, 5);
    }

    public static void createInstance(RepaintController rc) {
        if (theWorkspace != null) {
            String msg = "Attempt to create duplicate Workspace.";
            LogManager.logError((String)"INITIALIZATION", (String)msg);
            throw new RuntimeException(msg);
        }
        theWorkspace = new Workspace(rc);
    }

    public static Workspace getInstance() {
        if (theWorkspace == null) {
            throw new IllegalStateException("Must first call createInstance.");
        }
        return theWorkspace;
    }

    public void showPanel(WorkspacePanel panel) {
        if (this.currentPanel != null) {
            this.remove((JComponent)((Object)this.currentPanel));
        }
        this.currentPanel = panel;
        this.add((Component)((JComponent)((Object)this.currentPanel)), this.gbc);
        this.lbl.setText(this.currentPanel.getTitle());
        this.repaintController.repaintNeeded();
        if (this.mainFrame == null) {
            this.mainFrame = ConsoleMainFrame.getInstance();
        }
        String title = ConsolePlugin.Util.getString("ConsoleMainFrame.title");
        StringBuffer sb = new StringBuffer(title);
        sb.append(" - ");
        sb.append(panel.getConnection().getURL());
        sb.append(" [");
        sb.append(panel.getConnection().getUser());
        sb.append("] - ");
        sb.append(this.currentPanel.getTitle());
        this.mainFrame.setTitle(sb.toString());
    }

    public WorkspacePanel getCurrentPanel() {
        return this.currentPanel;
    }
}

