/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.layout;

import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.queue.WorkerPool;
import com.metamatrix.common.queue.WorkerPoolFactory;
import com.metamatrix.console.connections.ConnectionAndPanel;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.ExtensionSourceManager;
import com.metamatrix.console.models.GroupsManager;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.models.ResourceManager;
import com.metamatrix.console.models.ServerLogManager;
import com.metamatrix.console.notification.RuntimeUpdateNotification;
import com.metamatrix.console.security.UserCapabilities;
import com.metamatrix.console.ui.NotifyOnExitConsole;
import com.metamatrix.console.ui.layout.ConsoleMainFrame;
import com.metamatrix.console.ui.layout.ConsoleMenuBar;
import com.metamatrix.console.ui.layout.MenuEntry;
import com.metamatrix.console.ui.layout.PanelsTree;
import com.metamatrix.console.ui.layout.PanelsTreeModel;
import com.metamatrix.console.ui.layout.PendingPanel;
import com.metamatrix.console.ui.layout.Workspace;
import com.metamatrix.console.ui.layout.WorkspaceControllerWorkItem;
import com.metamatrix.console.ui.layout.WorkspacePanel;
import com.metamatrix.console.ui.views.authorization.ProvidersMain;
import com.metamatrix.console.ui.views.authorization.SummaryMain;
import com.metamatrix.console.ui.views.connector.ConnectorPanel;
import com.metamatrix.console.ui.views.connectorbinding.ConnectorBindingPanel;
import com.metamatrix.console.ui.views.deploy.DeployMainPanel;
import com.metamatrix.console.ui.views.entitlements.EntitlementsPanel;
import com.metamatrix.console.ui.views.extensionsource.ExtensionSourcesPanel;
import com.metamatrix.console.ui.views.logsetup.SystemLogSetUpPanel;
import com.metamatrix.console.ui.views.properties.PropertiesMasterPanel;
import com.metamatrix.console.ui.views.queries.QueryPanel;
import com.metamatrix.console.ui.views.resources.ResourcesMainPanel;
import com.metamatrix.console.ui.views.runtime.RuntimeMgmtPanel;
import com.metamatrix.console.ui.views.sessions.SessionPanel;
import com.metamatrix.console.ui.views.summary.SummaryPanel;
import com.metamatrix.console.ui.views.syslog.SysLogPanel;
import com.metamatrix.console.ui.views.users.AdminRolesMain;
import com.metamatrix.console.ui.views.vdb.VdbMainPanel;
import com.metamatrix.console.util.AutoRefreshable;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.Refreshable;
import com.metamatrix.console.util.StaticProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;

public class WorkspaceController
implements NotifyOnExitConsole {
    private static WorkspaceController theController = null;
    private List panels = new ArrayList(50);
    private HashMap hmAutoRefreshables = null;
    private Workspace workspace;
    private ConnectionAndPanel currentlyDisplayedPanel = null;
    private boolean programmaticConnectionSelectionChange = false;
    private boolean changingConnections = false;
    private WorkerPool workerPool;

    private WorkspaceController(Workspace ws) {
        this.workspace = ws;
        this.workerPool = WorkerPoolFactory.newWorkerPool((String)"WorkspaceControllerQueue", (int)1, (long)1000L);
    }

    public static void createInstance(Workspace workspace) {
        if (theController != null) {
            String message = "Attempt to create duplicate WorkspaceController";
            LogManager.logError((String)"INITIALIZATION", (String)message);
            throw new RuntimeException(message);
        }
        theController = new WorkspaceController(workspace);
    }

    public static WorkspaceController getInstance() {
        return theController;
    }

    public void connectionSelectionChanged(final ConnectionInfo connection) {
        if (!this.programmaticConnectionSelectionChange) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    try {
                        WorkspaceController.this.changingConnections = true;
                        int loc = WorkspaceController.this.panels.size() - 1;
                        ConnectionAndPanel cp = null;
                        while (cp == null && loc >= 0) {
                            ConnectionAndPanel thisCP = (ConnectionAndPanel)WorkspaceController.this.panels.get(loc);
                            if (connection.equals(thisCP.getConnection())) {
                                cp = new ConnectionAndPanel(connection, thisCP.getPanelClass(), thisCP.getPanel());
                                continue;
                            }
                            --loc;
                        }
                        if (cp == null) {
                            Class panelClass = ConsoleMainFrame.INITIAL_PANEL_CLASS;
                            WorkspacePanel panel = WorkspaceController.this.createPanelOfClass(panelClass, connection);
                            cp = new ConnectionAndPanel(connection, panelClass, panel);
                        }
                        PanelsTree tree = PanelsTree.getInstance(connection);
                        ConsoleMainFrame.getInstance().displayTreeForConnection(connection);
                        tree.selectNodeForPanel(cp);
                        WorkspaceController.this.treeSelectionChangedToClass(cp.getPanelClass(), true, connection);
                        WorkspaceController.this.changingConnections = false;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            thread.start();
        }
    }

    public boolean isChangingConnections() {
        return this.changingConnections;
    }

    public void treeSelectionChangedToClass(Class clazz, boolean showThePanel, ConnectionInfo connection) {
        WorkspaceControllerWorkItem item = new WorkspaceControllerWorkItem(clazz, showThePanel, connection);
        this.workerPool.execute((Runnable)item);
    }

    protected void doChangePanel(WorkspaceControllerWorkItem item) {
        Class clazz = item.clazz;
        boolean showThePanel = item.showThePanel;
        ConnectionInfo connection = item.connection;
        if (clazz != null) {
            try {
                ConnectionAndPanel cp;
                ConsoleMenuBar.getInstance().emptyTheActionsMenu();
                WorkspacePanel panel = this.getPanelOfClass(clazz, connection);
                boolean panelAdded = false;
                if (panel == null) {
                    panel = this.createPanelOfClass(clazz, connection);
                    cp = new ConnectionAndPanel(connection, panel.getClass(), panel);
                    this.panels.add(cp);
                    panelAdded = true;
                }
                if (panel != null) {
                    int index;
                    cp = new ConnectionAndPanel(connection, panel.getClass(), panel);
                    if (!panelAdded && (index = this.panelsIndex(cp)) >= 0) {
                        this.panels.remove(index);
                    }
                    if (panel instanceof AdminRolesMain) {
                        ((AdminRolesMain)panel).refreshData();
                    }
                    if (!panelAdded) {
                        this.panels.add(cp);
                        panelAdded = true;
                    }
                    this.updateActions(panel);
                    if (showThePanel) {
                        this.workspace.showPanel(panel);
                    }
                } else if (this.currentlyDisplayedPanel != null) {
                    PanelsTree.getInstance(connection).selectNodeForPanel(this.currentlyDisplayedPanel);
                }
                if (panel != null) {
                    this.currentlyDisplayedPanel = new ConnectionAndPanel(connection, clazz, panel);
                }
            }
            catch (Exception theException) {
                ExceptionUtility.showMessage("Problem occurred changing to panel " + clazz, theException);
                LogManager.logError((String)"GENERAL", (Throwable)theException, (String)("Changing tree selection to " + clazz));
            }
        }
    }

    public void handleUpdateNotification(ConnectionInfo connection, RuntimeUpdateNotification notification) {
        int numPanels = this.panels.size();
        for (int i = numPanels - 1; i >= 0; --i) {
            ConnectionAndPanel cp = (ConnectionAndPanel)this.panels.get(i);
            ConnectionInfo thisConnection = cp.getConnection();
            if (thisConnection != connection) continue;
            WorkspacePanel panel = cp.getPanel();
            panel.receiveUpdateNotification(notification);
        }
    }

    private int panelsIndex(ConnectionAndPanel cp) {
        int matchIndex = -1;
        int index = 0;
        int panelsSize = this.panels.size();
        while (matchIndex < 0 && index < panelsSize) {
            ConnectionAndPanel curCP = (ConnectionAndPanel)this.panels.get(index);
            if (cp.getConnection().equals(curCP.getConnection()) && cp.getPanelClass().getName().equals(curCP.getPanelClass().getName())) {
                matchIndex = index;
                continue;
            }
            ++index;
        }
        return matchIndex;
    }

    public void updateActions(WorkspacePanel panel) {
        ArrayList actions = panel.resume();
        if (actions == null) {
            actions = new ArrayList(1);
        }
        if (actions.size() > 0) {
            Object oTemp = actions.get(0);
            if (oTemp instanceof Action) {
                ConsoleMenuBar.getInstance().setActions(actions);
            } else if (oTemp instanceof MenuEntry) {
                ConsoleMenuBar.getInstance().addActionsFromMenuEntryObjects(actions);
            }
        } else {
            ConsoleMenuBar.getInstance().addActionsFromMenuEntryObjects(actions);
        }
        boolean refreshable = panel instanceof Refreshable;
        ConsoleMenuBar.getInstance().setDefaultRefreshEnabled(refreshable);
    }

    public WorkspacePanel getPanelOfClass(Class cls, ConnectionInfo connection) {
        String className = cls.getName();
        WorkspacePanel panel = null;
        int i = this.panels.size() - 1;
        while (panel == null && i >= 0) {
            ConnectionAndPanel cp = (ConnectionAndPanel)this.panels.get(i);
            if (connection.equals(cp.getConnection())) {
                WorkspacePanel current = cp.getPanel();
                String currentClassName = current.getClass().getName();
                if (className.equals(currentClassName)) {
                    panel = current;
                    continue;
                }
                --i;
                continue;
            }
            --i;
        }
        return panel;
    }

    public WorkspacePanel createPanelOfClass(Class cls, ConnectionInfo connection) {
        WorkspacePanel panel = null;
        if (cls == PanelsTreeModel.class) {
            panel = new PendingPanel();
        } else if (cls == SessionPanel.class) {
            panel = this.createSessionsPanel(connection);
        } else if (cls == SummaryPanel.class) {
            panel = this.createSummaryPanel(connection);
        } else if (cls == QueryPanel.class) {
            panel = this.createQueriesPanel(connection);
        } else if (cls == SummaryMain.class) {
            panel = this.createAuthSummaryPanel(connection);
        } else if (cls == ProvidersMain.class) {
            panel = this.createProvidersPanel(connection);
        } else if (cls == AdminRolesMain.class) {
            panel = this.createAdminRolesPanel(connection);
        } else if (cls == VdbMainPanel.class) {
            panel = this.createVDBPanel(connection);
        } else if (cls == PropertiesMasterPanel.class) {
            panel = this.createSystemPropertiesPanel(connection);
        } else if (cls == ConnectorPanel.class) {
            panel = this.createConnectorDefsPanel(connection);
        } else if (cls == ConnectorBindingPanel.class) {
            panel = this.createConnectorBindingsPanel(connection);
        } else if (cls == EntitlementsPanel.class) {
            panel = this.createEntitlementsViewPanel(connection);
        } else if (cls == ExtensionSourcesPanel.class) {
            panel = this.createExtensionSourcesPanel(connection);
        } else if (cls == DeployMainPanel.class) {
            panel = this.createDeployMainPanel(connection);
        } else if (cls == SysLogPanel.class) {
            panel = this.createLogPanel(connection);
        } else if (cls == RuntimeMgmtPanel.class) {
            panel = this.createRuntimeMgmtPanel(connection);
        } else if (cls == SystemLogSetUpPanel.class) {
            panel = this.createSystemLogSetupPanel(connection);
        } else if (cls == ResourcesMainPanel.class) {
            panel = this.createResourcesPanel(connection);
        }
        if (panel instanceof AutoRefreshable) {
            this.addToAutoRefreshableXref(panel);
        }
        return panel;
    }

    public void deletePanelsForConnection(ConnectionInfo connection) {
        ConnectionInfo currentConnection = this.currentlyDisplayedPanel.getConnection();
        boolean replaceCurrentPanel = currentConnection.equals(connection) && this.panels.size() > 0;
        int listSize = this.panels.size();
        for (int i = listSize - 1; i >= 0; --i) {
            ConnectionAndPanel panel = (ConnectionAndPanel)this.panels.get(i);
            if (!panel.getConnection().equals(connection)) continue;
            this.panels.remove(i);
        }
        if (replaceCurrentPanel) {
            ConnectionAndPanel lastPanel = (ConnectionAndPanel)this.panels.get(this.panels.size() - 1);
            PanelsTree.getInstance(lastPanel.getConnection()).selectNodeForPanel(lastPanel);
            this.programmaticConnectionSelectionChange = true;
            ConsoleMainFrame.getInstance().selectConnection(connection);
            this.programmaticConnectionSelectionChange = false;
        }
    }

    private WorkspacePanel createSummaryPanel(ConnectionInfo connection) {
        SummaryPanel panel = new SummaryPanel(connection);
        return panel;
    }

    private WorkspacePanel createSessionsPanel(ConnectionInfo connection) {
        SessionPanel panel = null;
        try {
            panel = new SessionPanel(connection);
            panel.createComponent();
        }
        catch (Exception ex) {
            ExceptionUtility.showMessage("Create Sessions Panel", ex);
        }
        return panel;
    }

    private DeployMainPanel createDeployMainPanel(ConnectionInfo connection) {
        DeployMainPanel pnl = null;
        try {
            pnl = new DeployMainPanel(connection);
        }
        catch (Exception theException) {
            ExceptionUtility.showMessage("Create DeployMainPanel", theException);
        }
        return pnl;
    }

    private RuntimeMgmtPanel createRuntimeMgmtPanel(ConnectionInfo connection) {
        RuntimeMgmtPanel pnl = null;
        try {
            pnl = new RuntimeMgmtPanel(connection);
        }
        catch (Exception theException) {
            ExceptionUtility.showMessage("Create RuntimeMgmtPanel", theException);
        }
        return pnl;
    }

    private WorkspacePanel createQueriesPanel(ConnectionInfo connection) {
        QueryPanel panel = null;
        try {
            panel = new QueryPanel(connection);
        }
        catch (Exception ex) {
            ExceptionUtility.showMessage("Create Queries Panel", ex);
        }
        return panel;
    }

    private WorkspacePanel createSystemPropertiesPanel(ConnectionInfo connection) {
        PropertiesMasterPanel pPanel = new PropertiesMasterPanel(connection);
        pPanel.createComponent();
        return pPanel;
    }

    private WorkspacePanel createConnectorDefsPanel(ConnectionInfo connection) {
        ConnectorPanel panel = new ConnectorPanel(connection);
        return panel;
    }

    private WorkspacePanel createConnectorBindingsPanel(ConnectionInfo connection) {
        ConnectorBindingPanel panel = new ConnectorBindingPanel(connection);
        return panel;
    }

    private WorkspacePanel createAuthSummaryPanel(ConnectionInfo connection) {
        SummaryMain panel = new SummaryMain(connection);
        return panel;
    }

    private WorkspacePanel createProvidersPanel(ConnectionInfo connection) {
        ProvidersMain panel = new ProvidersMain(connection);
        return panel;
    }

    private WorkspacePanel createAdminRolesPanel(ConnectionInfo connection) {
        AdminRolesMain panel = null;
        try {
            UserCapabilities cap = UserCapabilities.getInstance();
            GroupsManager userManager = ModelManager.getGroupsManager(connection);
            panel = new AdminRolesMain(userManager, true, cap.canViewPrincipalInfo(connection), false, cap.canViewRoleInfo(connection), cap.canModifyRoleInfo(connection), false);
            panel.createComponent();
        }
        catch (Exception e) {
            ExceptionUtility.showMessage("Create Roles panel", e);
        }
        return panel;
    }

    private WorkspacePanel createEntitlementsViewPanel(ConnectionInfo connection) {
        EntitlementsPanel entPanel = null;
        try {
            entPanel = new EntitlementsPanel(ModelManager.getEntitlementManager(connection), true, true, connection);
        }
        catch (Exception ex) {
            ExceptionUtility.showMessage("Create Data Roles panel", ex);
        }
        return entPanel;
    }

    private WorkspacePanel createResourcesPanel(ConnectionInfo connection) {
        ResourcesMainPanel rp = null;
        try {
            UserCapabilities cap = UserCapabilities.getInstance();
            boolean canModify = cap.canModifyResources(connection);
            ResourceManager mgr = ModelManager.getResourceManager(connection);
            rp = new ResourcesMainPanel(mgr, canModify, connection);
        }
        catch (Exception ex) {
            ExceptionUtility.showMessage("Create Resources panel", ex);
        }
        return rp;
    }

    private WorkspacePanel createExtensionSourcesPanel(ConnectionInfo connection) {
        ExtensionSourceManager manager = ModelManager.getExtensionSourceManager(connection);
        UserCapabilities cap = UserCapabilities.getInstance();
        ExtensionSourcesPanel extPanel = new ExtensionSourcesPanel(manager, cap.canModifyExtensionSources(connection), connection);
        return extPanel;
    }

    private WorkspacePanel createVDBPanel(ConnectionInfo connection) {
        VdbMainPanel panel = new VdbMainPanel(connection);
        return panel;
    }

    private WorkspacePanel createLogPanel(ConnectionInfo connection) {
        SysLogPanel panel = null;
        try {
            panel = new SysLogPanel(connection);
        }
        catch (Exception ex) {
            panel = null;
            String msg = ExceptionUtility.containsExceptionOfType(ex, ClassNotFoundException.class) ? "Unable to create Log Viewer.  Please ensure that JDBC driver is correctly installed." : "Unable to create Log Viewer panel.";
            ExceptionUtility.showMessage("Error creating Log Viewer Panel", msg, ex);
            LogManager.logError((String)"SYSTEMLOGGING", (Throwable)ex, (String)"Error creating SysLogPanel");
        }
        return panel;
    }

    private WorkspacePanel createSystemLogSetupPanel(ConnectionInfo connection) {
        ServerLogManager manager = ModelManager.getServerLogManager(connection);
        boolean canModify = false;
        try {
            canModify = UserCapabilities.getInstance().canModifyLoggingConfig(connection);
        }
        catch (Exception ex) {
            // empty catch block
        }
        SystemLogSetUpPanel panel = new SystemLogSetUpPanel(manager, canModify, connection);
        return panel;
    }

    public boolean havePendingChanges(ConnectionInfo connection) {
        boolean pending = false;
        for (int i = this.panels.size() - 1; i >= 0 && !pending; --i) {
            WorkspacePanel panel;
            ConnectionAndPanel cp = (ConnectionAndPanel)this.panels.get(i);
            if (connection != null && !connection.equals(cp.getConnection()) || !((panel = cp.getPanel()) instanceof NotifyOnExitConsole)) continue;
            pending = ((NotifyOnExitConsole)((Object)panel)).havePendingChanges();
        }
        return pending;
    }

    @Override
    public boolean havePendingChanges() {
        return this.havePendingChanges(null);
    }

    public boolean finishUp(ConnectionInfo connection) {
        boolean exiting = true;
        ArrayList panelsBeforeReordering = new ArrayList(this.panels.size());
        Iterator it = this.panels.iterator();
        while (it.hasNext()) {
            panelsBeforeReordering.add(it.next());
        }
        for (int i = panelsBeforeReordering.size() - 1; i >= 0 && exiting; --i) {
            NotifyOnExitConsole notifyee;
            WorkspacePanel panel;
            ConnectionAndPanel cp = (ConnectionAndPanel)panelsBeforeReordering.get(i);
            if (connection != null && !connection.equals(cp.getConnection()) || !((panel = cp.getPanel()) instanceof NotifyOnExitConsole) || !(notifyee = (NotifyOnExitConsole)((Object)panel)).havePendingChanges()) continue;
            ConnectionInfo conn = panel.getConnection();
            cp = new ConnectionAndPanel(conn, notifyee.getClass(), panel);
            this.programmaticConnectionSelectionChange = true;
            ConsoleMainFrame.getInstance().selectConnection(conn);
            ConsoleMainFrame.getInstance().displayTreeForConnection(conn);
            ConsoleMainFrame.getInstance().selectPanel(cp);
            this.workspace.showPanel(cp.getPanel());
            this.programmaticConnectionSelectionChange = false;
            exiting = notifyee.finishUp();
        }
        return exiting;
    }

    @Override
    public boolean finishUp() {
        return this.finishUp(null);
    }

    private HashMap getAutoRefreshableXref() {
        if (this.hmAutoRefreshables == null) {
            this.hmAutoRefreshables = new HashMap();
        }
        return this.hmAutoRefreshables;
    }

    private void addToAutoRefreshableXref(WorkspacePanel wsp) {
        if (wsp instanceof AutoRefreshable) {
            this.getAutoRefreshableXref().put(((AutoRefreshable)((Object)wsp)).getName(), wsp);
            this.applyAutoRefreshParmsToWorkspacePanel(wsp);
        }
    }

    public void applyAutoRefreshParmsToAll() {
        Collection colAutoRefreshableWorkspacePanels = this.getAutoRefreshableXref().values();
        for (WorkspacePanel wsp : colAutoRefreshableWorkspacePanels) {
            this.applyAutoRefreshParmsToWorkspacePanel(wsp);
        }
    }

    public void applyAutoRefreshParmsToWorkspacePanel(WorkspacePanel wsp) {
        if (!(wsp instanceof AutoRefreshable)) {
            return;
        }
        if (wsp instanceof SummaryPanel) {
            this.applyAutoRefreshParms((AutoRefreshable)((Object)wsp), StaticProperties.getSummaryRefreshEnabled(), StaticProperties.getSummaryRefreshRate());
        }
        if (wsp instanceof QueryPanel) {
            this.applyAutoRefreshParms((AutoRefreshable)((Object)wsp), StaticProperties.getQueryRefreshEnabled(), StaticProperties.getQueryRefreshRate());
        }
        if (wsp instanceof SessionPanel) {
            this.applyAutoRefreshParms((AutoRefreshable)((Object)wsp), StaticProperties.getSessionRefreshEnabled(), StaticProperties.getSessionRefreshRate());
        }
        if (wsp instanceof SysLogPanel) {
            this.applyAutoRefreshParms((AutoRefreshable)((Object)wsp), StaticProperties.getSysLogRefreshEnabled(), StaticProperties.getSysLogRefreshRate());
        }
    }

    public void applyAutoRefreshParms(AutoRefreshable refAutoRefreshablePanel, boolean bEnabled, int iRate) {
        refAutoRefreshablePanel.setAutoRefreshEnabled(bEnabled);
        refAutoRefreshablePanel.setRefreshRate(iRate);
    }
}

