/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.tree;

import com.metamatrix.console.ui.tree.SortsChildren;
import com.metamatrix.console.util.StaticTreeSortUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;

public class ChildSortingTreeNode
extends DefaultMutableTreeNode
implements SortsChildren {
    private int sortType = 2;
    private DefaultTreeModel model;
    private boolean usingUserObjectToString = false;

    public ChildSortingTreeNode(DefaultTreeModel mdl) {
        this.model = mdl;
    }

    public ChildSortingTreeNode(DefaultTreeModel mdl, Object userObj) {
        super(userObj);
        this.model = mdl;
    }

    public ChildSortingTreeNode(DefaultTreeModel mdl, Object userObj, boolean childrenFlag) {
        super(userObj, childrenFlag);
        this.model = mdl;
    }

    public DefaultTreeModel getModel() {
        return this.model;
    }

    public void setModel(DefaultTreeModel mdl) {
        this.model = mdl;
    }

    public boolean isUsingUserObjectToString() {
        return this.usingUserObjectToString;
    }

    public void setUsingUserObjectToString(boolean flag) {
        this.usingUserObjectToString = flag;
    }

    @Override
    public void setSortType(int val) {
        this.sortType = val;
    }

    @Override
    public int getSortType() {
        return this.sortType;
    }

    @Override
    public boolean sortChildren() {
        boolean changed = false;
        if (this.getSortType() != 3 && this.getChildCount() > 1) {
            if (this.getSortType() == 1) {
                changed = this.sortNumeric();
            } else if (this.getSortType() == 2) {
                changed = this.sortAlphabetic();
            }
        }
        return changed;
    }

    private boolean sortAlphabetic() {
        return StaticTreeSortUtilities.sortChildrenAlphabetically(this, this.usingUserObjectToString);
    }

    private boolean sortNumeric() {
        return StaticTreeSortUtilities.sortChildrenNumerically(this, this.usingUserObjectToString);
    }

    public static void sortTree(MutableTreeNode root) {
        MutableTreeNode curNode = root;
        boolean done = false;
        while (!done) {
            if (curNode instanceof SortsChildren) {
                SortsChildren cn = (SortsChildren)((Object)curNode);
                cn.sortChildren();
            }
            if (curNode.getChildCount() > 0) {
                curNode = (MutableTreeNode)curNode.getChildAt(0);
                continue;
            }
            boolean nextNodeFound = false;
            while (!done && !nextNodeFound) {
                if (curNode == root) {
                    done = true;
                    continue;
                }
                MutableTreeNode parent = (MutableTreeNode)curNode.getParent();
                int nextIndex = parent.getIndex(curNode) + 1;
                if (nextIndex < parent.getChildCount()) {
                    curNode = (MutableTreeNode)parent.getChildAt(nextIndex);
                    nextNodeFound = true;
                    continue;
                }
                curNode = parent;
            }
        }
    }

    @Override
    public void add(MutableTreeNode child) {
        super.add(child);
        if (this.getSortType() != 3) {
            this.sortChildren();
            if (this.model != null) {
                this.model.reload();
            }
        }
    }

    @Override
    public void insert(MutableTreeNode child, int index) {
        super.insert(child, index);
        if (this.getSortType() != 3) {
            this.sortChildren();
            if (this.model != null) {
                this.model.reload();
            }
        }
    }
}

