/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.tree;

import com.metamatrix.console.ui.tree.ChildSortingTreeNode;
import com.metamatrix.console.ui.tree.SavesExpansionState;
import com.metamatrix.console.ui.tree.TreePathExpansion;
import com.metamatrix.console.util.StaticTreeUtilities;
import com.metamatrix.toolbox.ui.widget.TreeWidget;
import java.util.Collection;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;

public class SortReadyJTree
extends TreeWidget
implements SavesExpansionState {
    public SortReadyJTree() {
        this.customizeAppearance();
    }

    private void customizeAppearance() {
        this.putClientProperty("JTree.lineStyle", "Angled");
    }

    public SortReadyJTree(TreeModel model) {
        super(model);
        this.customizeAppearance();
        this.sortModel();
    }

    @Override
    public void setModel(TreeModel model) {
        super.setModel(model);
        this.sortModel();
    }

    private void sortModel() {
        Object rootObj;
        if (this.getModel() != null && (rootObj = this.getModel().getRoot()) instanceof MutableTreeNode) {
            MutableTreeNode root = (MutableTreeNode)rootObj;
            ChildSortingTreeNode.sortTree(root);
        }
    }

    @Override
    public TreePathExpansion[] saveExpansionState() throws Exception {
        return StaticTreeUtilities.expansionState(this);
    }

    public void restoreExpansionState(TreePathExpansion[] saved) throws Exception {
        StaticTreeUtilities.restoreExpansionState(this, saved, true);
    }

    @Override
    public void restoreExpansionState(TreePathExpansion[] saved, Collection selectionListeners, Collection willExpandListeners, Collection expansionListeners) throws Exception {
        StaticTreeUtilities.restoreExpansionState(this, saved, true, selectionListeners, willExpandListeners, expansionListeners);
    }
}

