/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.treetable;

import com.metamatrix.console.ui.treetable.AbstractTreeTableModel;
import java.lang.reflect.Method;
import javax.swing.tree.TreeNode;

public class DynamicTreeTableModel
extends AbstractTreeTableModel {
    private String[] columnNames;
    private String[] getterMethodNames;
    private String[] setterMethodNames;
    private Class[] cTypes;

    public DynamicTreeTableModel(TreeNode root, String[] columnNames, String[] getterMethodNames, String[] setterMethodNames, Class[] cTypes) {
        super(root);
        this.columnNames = columnNames;
        this.getterMethodNames = getterMethodNames;
        this.setterMethodNames = setterMethodNames;
        this.cTypes = cTypes;
    }

    @Override
    public int getChildCount(Object node) {
        return ((TreeNode)node).getChildCount();
    }

    @Override
    public Object getChild(Object node, int i) {
        return ((TreeNode)node).getChildAt(i);
    }

    @Override
    public boolean isLeaf(Object node) {
        return ((TreeNode)node).isLeaf();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int column) {
        if (this.cTypes == null || column < 0 || column >= this.cTypes.length) {
            return null;
        }
        return this.columnNames[column];
    }

    @Override
    public Class getColumnClass(int column) {
        if (this.cTypes == null || column < 0 || column >= this.cTypes.length) {
            return null;
        }
        return this.cTypes[column];
    }

    @Override
    public Object getValueAt(Object node, int column) {
        Object value = null;
        try {
            String methodName = this.getterMethodNames[column];
            Class<?> cls = node.getClass();
            Method method = cls.getMethod(methodName, null);
            if (method != null) {
                value = method.invoke(node, null);
            }
        }
        catch (Throwable th) {
            // empty catch block
        }
        return value;
    }

    @Override
    public boolean isCellEditable(Object node, int column) {
        return this.setterMethodNames != null && this.setterMethodNames[column] != null;
    }

    @Override
    public void setValueAt(Object aValue, Object node, int column) {
        TreeNode parent;
        boolean found = false;
        try {
            Method[] methods = node.getClass().getMethods();
            for (int counter = methods.length - 1; counter >= 0; --counter) {
                Class<?> param;
                if (!methods[counter].getName().equals(this.setterMethodNames[column]) || methods[counter].getParameterTypes() == null || methods[counter].getParameterTypes().length != 1 || !(param = methods[counter].getParameterTypes()[0]).isInstance(aValue)) continue;
                found = true;
                methods[counter].invoke(node, aValue);
                break;
            }
        }
        catch (Throwable th) {
            System.out.println("exception: " + th);
        }
        if (found && (parent = ((TreeNode)node).getParent()) != null) {
            this.fireTreeNodesChanged(this, this.getPathToRoot(parent), new int[]{this.getIndexOfChild(parent, node)}, new Object[]{node});
        }
    }

    public TreeNode[] getPathToRoot(TreeNode aNode) {
        return this.getPathToRoot(aNode, 0);
    }

    private TreeNode[] getPathToRoot(TreeNode aNode, int depth) {
        TreeNode[] retNodes;
        if (aNode == null) {
            if (depth == 0) {
                return null;
            }
            retNodes = new TreeNode[depth];
        } else {
            retNodes = aNode == this.root ? new TreeNode[depth] : this.getPathToRoot(aNode.getParent(), ++depth);
            retNodes[retNodes.length - depth] = aNode;
        }
        return retNodes;
    }
}

