/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.treetable;

import com.metamatrix.console.ui.treetable.TreeTableModel;
import com.metamatrix.console.ui.treetable.TreeTableModelAdapter;
import com.metamatrix.console.ui.views.entitlements.AuthorizationsTreeTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class JTreeTable
extends JTable {
    protected TreeTableCellRenderer tree;
    private boolean columnsSizedSinceRendererSet = false;

    public JTreeTable(TreeTableModel treeTableModel) {
        this.tree = new TreeTableCellRenderer(treeTableModel);
        super.setModel(new TreeTableModelAdapter(treeTableModel, this.tree));
        ListToTreeSelectionModelWrapper selectionWrapper = new ListToTreeSelectionModelWrapper();
        this.tree.setSelectionModel(selectionWrapper);
        this.setSelectionModel(selectionWrapper.getListSelectionModel());
        this.setDefaultRenderer(TreeTableModel.class, this.tree);
        this.setDefaultEditor(TreeTableModel.class, new TreeTableCellEditor());
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        if (this.tree.getRowHeight() < 1) {
            this.setRowHeight(20);
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.tree != null) {
            this.tree.updateUI();
            this.setDefaultEditor(TreeTableModel.class, new TreeTableCellEditor());
        }
        LookAndFeel.installColorsAndFont(this, "Tree.background", "Tree.foreground", "Tree.font");
    }

    @Override
    public int getEditingRow() {
        return this.getColumnClass(this.editingColumn) == TreeTableModel.class ? -1 : this.editingRow;
    }

    private int realEditingRow() {
        return this.editingRow;
    }

    @Override
    public void sizeColumnsToFit(int resizingColumn) {
        TreeCellRenderer tcr;
        if (!this.columnsSizedSinceRendererSet && this instanceof AuthorizationsTreeTable && (tcr = ((AuthorizationsTreeTable)this).getTreeCellRenderer()) != null) {
            this.sizeColumns();
            this.columnsSizedSinceRendererSet = true;
        }
        super.sizeColumnsToFit(resizingColumn);
        if (this.getEditingColumn() != -1 && this.getColumnClass(this.editingColumn) == TreeTableModel.class) {
            Rectangle cellRect = this.getCellRect(this.realEditingRow(), this.getEditingColumn(), false);
            Component component = this.getEditorComponent();
            component.setBounds(cellRect);
            component.validate();
        }
    }

    @Override
    public void setRowHeight(int rowHeight) {
        super.setRowHeight(rowHeight);
        if (this.tree != null && this.tree.getRowHeight() != rowHeight) {
            this.tree.setRowHeight(this.getRowHeight());
        }
    }

    public JTree getTree() {
        return this.tree;
    }

    @Override
    public boolean editCellAt(int row, int column, EventObject e) {
        boolean retValue = super.editCellAt(row, column, e);
        if (retValue && this.getColumnClass(column) == TreeTableModel.class) {
            this.repaint(this.getCellRect(row, column, false));
        }
        return retValue;
    }

    @Override
    public void tableChanged(TableModelEvent theEvent) {
        super.tableChanged(theEvent);
        this.sizeColumns();
    }

    private void sizeColumns() {
        TableColumnModel model = this.getColumnModel();
        boolean hasRows = this.getRowCount() > 0;
        int preferredWidth = 0;
        double avgRowHeight = 0.0;
        int maxHeadHeight = 0;
        int numCols = model.getColumnCount();
        for (int i = 0; i < numCols; ++i) {
            TableColumn col = model.getColumn(i);
            int dataWidth = 20;
            if (hasRows) {
                TableCellRenderer rend = this.getCellRenderer(0, i);
                if (rend == null) {
                    Class<?> cls = this.getColumnClass(i);
                    rend = this.getDefaultRenderer(cls);
                }
                int numRows = this.getRowCount();
                for (int j = 0; j < numRows; ++j) {
                    if (i == 0) {
                        avgRowHeight += (double)this.getRowHeight(j);
                    }
                    if (rend == null) continue;
                    Component comp = this.prepareRenderer(rend, j, i);
                    int width = comp.getPreferredSize().width;
                    if (dataWidth >= width) continue;
                    dataWidth = width;
                }
            }
            int headWidth = 20;
            TableCellRenderer rend = col.getHeaderRenderer();
            if (rend == null) {
                try {
                    Method m = JTableHeader.class.getMethod("getDefaultRenderer", null);
                    rend = (TableCellRenderer)m.invoke((Object)this.getTableHeader(), null);
                }
                catch (Exception e) {
                    rend = null;
                }
            }
            if (rend != null) {
                Component comp = rend.getTableCellRendererComponent(this, col.getHeaderValue(), false, false, -1, i);
                Dimension compPreferredSize = comp.getPreferredSize();
                headWidth = compPreferredSize.width;
                maxHeadHeight = Math.max(compPreferredSize.height, maxHeadHeight);
            }
            int width = dataWidth > headWidth ? dataWidth : headWidth;
            col.setPreferredWidth(width += 8);
            col.setWidth(width);
            preferredWidth += width;
        }
        if (maxHeadHeight <= 0) {
            maxHeadHeight = 20;
        }
        avgRowHeight = this.getRowCount() > 0 ? avgRowHeight / (double)this.getRowCount() : (double)this.getRowHeight();
        int preferredHeight = (int)(avgRowHeight * 20.0 + (double)maxHeadHeight + 1.0E-6);
        Dimension viewportSize = new Dimension(preferredWidth, preferredHeight);
        this.setPreferredScrollableViewportSize(viewportSize);
    }

    class ListToTreeSelectionModelWrapper
    extends DefaultTreeSelectionModel {
        protected boolean updatingListSelectionModel;

        public ListToTreeSelectionModelWrapper() {
            this.getListSelectionModel().addListSelectionListener(this.createListSelectionListener());
        }

        ListSelectionModel getListSelectionModel() {
            return this.listSelectionModel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void resetRowSelection() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    super.resetRowSelection();
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        protected ListSelectionListener createListSelectionListener() {
            return new ListSelectionHandler();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateSelectedPathsFromSelectedRows() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    int min = this.listSelectionModel.getMinSelectionIndex();
                    int max = this.listSelectionModel.getMaxSelectionIndex();
                    this.clearSelection();
                    if (min != -1 && max != -1) {
                        for (int counter = min; counter <= max; ++counter) {
                            TreePath selPath;
                            if (!this.listSelectionModel.isSelectedIndex(counter) || (selPath = JTreeTable.this.tree.getPathForRow(counter)) == null) continue;
                            this.addSelectionPath(selPath);
                        }
                    }
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        class ListSelectionHandler
        implements ListSelectionListener {
            ListSelectionHandler() {
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ListToTreeSelectionModelWrapper.this.updateSelectedPathsFromSelectedRows();
            }
        }
    }

    static class TreeTableTextField
    extends JTextField {
        public int offset;

        TreeTableTextField() {
        }

        @Override
        public void reshape(int x, int y, int w, int h) {
            int newX = Math.max(x, this.offset);
            super.reshape(newX, y, w - (newX - x), h);
        }
    }

    public class TreeTableCellEditor
    extends DefaultCellEditor {
        public TreeTableCellEditor() {
            super(new TreeTableTextField());
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int r, int c) {
            Component component = super.getTableCellEditorComponent(table, value, isSelected, r, c);
            JTree t = JTreeTable.this.getTree();
            boolean rv = t.isRootVisible();
            int offsetRow = rv ? r : r - 1;
            Rectangle bounds = t.getRowBounds(offsetRow);
            int offset = bounds.x;
            TreeCellRenderer tcr = t.getCellRenderer();
            if (tcr instanceof DefaultTreeCellRenderer) {
                Object node = t.getPathForRow(offsetRow).getLastPathComponent();
                Icon icon = t.getModel().isLeaf(node) ? ((DefaultTreeCellRenderer)tcr).getLeafIcon() : (JTreeTable.this.tree.isExpanded(offsetRow) ? ((DefaultTreeCellRenderer)tcr).getOpenIcon() : ((DefaultTreeCellRenderer)tcr).getClosedIcon());
                if (icon != null) {
                    offset += ((DefaultTreeCellRenderer)tcr).getIconTextGap() + icon.getIconWidth();
                }
            }
            ((TreeTableTextField)this.getComponent()).offset = offset;
            return component;
        }

        @Override
        public boolean isCellEditable(EventObject e) {
            if (e instanceof MouseEvent) {
                MouseEvent me = (MouseEvent)e;
                if (me.getModifiers() == 0 || me.getModifiers() == 16) {
                    for (int counter = JTreeTable.this.getColumnCount() - 1; counter >= 0; --counter) {
                        if (JTreeTable.this.getColumnClass(counter) != TreeTableModel.class) continue;
                        MouseEvent newME = new MouseEvent(JTreeTable.this.tree, me.getID(), me.getWhen(), me.getModifiers(), me.getX() - JTreeTable.this.getCellRect((int)0, (int)counter, (boolean)true).x, me.getY(), me.getClickCount(), me.isPopupTrigger());
                        JTreeTable.this.tree.dispatchEvent(newME);
                        break;
                    }
                }
                return false;
            }
            return false;
        }
    }

    public class TreeTableCellRenderer
    extends JTree
    implements TableCellRenderer {
        protected int visibleRow;
        protected Border highlightBorder;

        public TreeTableCellRenderer(TreeModel model) {
            super(model);
        }

        @Override
        public void updateUI() {
            super.updateUI();
            TreeCellRenderer tcr = this.getCellRenderer();
            if (tcr instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer dtcr = (DefaultTreeCellRenderer)tcr;
                dtcr.setTextSelectionColor(UIManager.getColor("Table.selectionForeground"));
                dtcr.setBackgroundSelectionColor(UIManager.getColor("Table.selectionBackground"));
            }
        }

        @Override
        public void setRowHeight(int rowHeight) {
            if (rowHeight > 0) {
                super.setRowHeight(rowHeight);
                if (JTreeTable.this != null && JTreeTable.this.getRowHeight() != rowHeight) {
                    JTreeTable.this.setRowHeight(this.getRowHeight());
                }
            }
        }

        @Override
        public void setBounds(int x, int y, int w, int h) {
            super.setBounds(x, 0, w, JTreeTable.this.getHeight());
        }

        @Override
        public void paint(Graphics g) {
            g.translate(0, -this.visibleRow * this.getRowHeight());
            super.paint(g);
            if (this.highlightBorder != null) {
                this.highlightBorder.paintBorder(this, g, 0, this.visibleRow * this.getRowHeight(), this.getWidth(), this.getRowHeight());
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Color foreground;
            Color background;
            if (isSelected) {
                background = table.getSelectionBackground();
                foreground = table.getSelectionForeground();
            } else {
                background = table.getBackground();
                foreground = table.getForeground();
            }
            this.highlightBorder = null;
            if (JTreeTable.this.realEditingRow() == row && JTreeTable.this.getEditingColumn() == column) {
                background = UIManager.getColor("Table.focusCellBackground");
                foreground = UIManager.getColor("Table.focusCellForeground");
            } else if (hasFocus) {
                this.highlightBorder = UIManager.getBorder("Table.focusCellHighlightBorder");
                if (JTreeTable.this.isCellEditable(row, column)) {
                    background = UIManager.getColor("Table.focusCellBackground");
                    foreground = UIManager.getColor("Table.focusCellForeground");
                }
            }
            this.visibleRow = row;
            this.setBackground(background);
            TreeCellRenderer tcr = this.getCellRenderer();
            if (tcr instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer dtcr = (DefaultTreeCellRenderer)tcr;
                if (isSelected) {
                    dtcr.setTextSelectionColor(foreground);
                    dtcr.setBackgroundSelectionColor(background);
                } else {
                    dtcr.setTextNonSelectionColor(foreground);
                    dtcr.setBackgroundNonSelectionColor(background);
                }
            }
            return this;
        }
    }
}

