/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.util;

import com.metamatrix.common.log.LogManager;
import com.metamatrix.console.ui.ViewManager;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.ExternalException;
import com.metamatrix.console.util.StaticUtilities;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;

public abstract class AbstractPanelAction
extends AbstractAction {
    public static final String MENU_ITEM_NAME = "menu.item.name";
    private int mnemonic = 0;
    protected int type = -1;
    private HashSet comps = new HashSet();

    public AbstractPanelAction(int theType) {
        this.type = theType;
    }

    public AbstractPanelAction(String menuItemName) {
        this(-1);
        this.putValue(MENU_ITEM_NAME, menuItemName);
    }

    protected abstract void actionImpl(ActionEvent var1) throws ExternalException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent theEvent) {
        try {
            StaticUtilities.startWait(ViewManager.getMainFrame());
            this.actionImpl(theEvent);
        }
        catch (Exception theException) {
            this.handleError(theException);
        }
        finally {
            StaticUtilities.endWait(ViewManager.getMainFrame());
        }
    }

    public void addComponent(JComponent theComponent) {
        this.comps.add(theComponent);
        if (theComponent instanceof AbstractButton) {
            AbstractButton btn = (AbstractButton)theComponent;
            if (this.getValue("Name") != null) {
                btn.setText((String)this.getValue("Name"));
            }
            if (this.getValue("SmallIcon") != null) {
                btn.setIcon((Icon)this.getValue("SmallIcon"));
            }
            if (this.getValue(MENU_ITEM_NAME) != null && theComponent instanceof JMenuItem) {
                btn.setText((String)this.getValue(MENU_ITEM_NAME));
            }
            btn.setMnemonic(this.mnemonic);
            if (!(btn instanceof JMenuItem)) {
                btn.addActionListener(this);
            }
        }
        if (this.getValue("ShortDescription") != null) {
            theComponent.setToolTipText((String)this.getValue("ShortDescription"));
        }
        theComponent.setEnabled(this.isEnabled());
    }

    public Set getComponents() {
        return this.comps;
    }

    protected void handleError(Exception theException) {
        Object name = this.getValue("Name");
        if (name == null) {
            name = this.getValue(MENU_ITEM_NAME);
        }
        ExceptionUtility.showMessage("Error Performing Action " + name, theException.getMessage(), theException);
        LogManager.logError((String)"GENERAL", (Throwable)theException, (String)this.paramString());
    }

    public int getMnemonic() {
        return this.mnemonic;
    }

    @Override
    public void putValue(String theKey, Object theValue) {
        super.putValue(theKey, theValue);
        for (JComponent comp : this.comps) {
            if (comp instanceof AbstractButton) {
                if (theKey.equals("Name")) {
                    ((AbstractButton)comp).setText((String)theValue);
                } else if (theKey.equals("SmallIcon")) {
                    ((AbstractButton)comp).setIcon((Icon)theValue);
                } else if (theKey.equals(MENU_ITEM_NAME) && comp instanceof JMenuItem) {
                    ((AbstractButton)comp).setText((String)theValue);
                }
            }
            if (!theKey.equals("ShortDescription")) continue;
            comp.setToolTipText((String)theValue);
        }
    }

    public void removeComponent(JComponent theComponent) {
        if (this.comps.remove(theComponent) && theComponent instanceof AbstractButton) {
            ((AbstractButton)theComponent).removeActionListener(this);
        }
    }

    @Override
    public void setEnabled(boolean theEnabledFlag) {
        if (this.isEnabled() != theEnabledFlag) {
            super.setEnabled(theEnabledFlag);
            for (JComponent comp : this.comps) {
                comp.setEnabled(theEnabledFlag);
            }
        }
    }

    public void setMnemonic(int theMnemonic) {
        this.mnemonic = theMnemonic;
        for (JComponent comp : this.comps) {
            if (!(comp instanceof AbstractButton)) continue;
            ((AbstractButton)comp).setMnemonic(theMnemonic);
        }
    }

    public String paramString() {
        return new StringBuffer().append("class=").append(this.getClass()).append(", type=").append(this.type).append(", enabled=").append(this.isEnabled()).append(", attached components=").append(this.comps.size()).append(", mnemonic=").append(this.mnemonic).append(", name=").append(this.getValue("Name")).append(", menu item name=").append(this.getValue(MENU_ITEM_NAME)).append(", name=").append(this.getValue("ShortDescription")).toString();
    }

    public String toString() {
        String str = "AbstractPanelAction: " + this.paramString();
        return str;
    }
}

