/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.util;

import com.metamatrix.console.ui.layout.BasePanel;
import com.metamatrix.console.ui.util.WizardInterface;
import com.metamatrix.console.ui.util.WizardStepTextPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class BasicWizardSubpanelContainer
extends BasePanel {
    private JPanel lblStep;
    private JPanel pnlMainContent;
    private WizardInterface wizardInterface;
    private WizardStepTextPanel stepTextPanel;

    public BasicWizardSubpanelContainer(WizardInterface wizInterface) {
        this.wizardInterface = wizInterface;
        this.setLayout(new GridBagLayout());
        JPanel pnlStep = new JPanel(new GridLayout(1, 1));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.fill = 2;
        this.add((Component)pnlStep, gbc);
        this.lblStep = new JPanel();
        pnlStep.add(this.lblStep);
        this.pnlMainContent = new JPanel(new GridLayout(1, 1));
        this.pnlMainContent.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(3, 5, 3, 5)));
        gbc.gridy = 1;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)this.pnlMainContent, gbc);
    }

    public WizardInterface getWizardInterface() {
        return this.wizardInterface;
    }

    public void enableForwardButton(boolean bEnableState) {
        AbstractButton forwardButton = this.wizardInterface.getForwardButton();
        forwardButton.setEnabled(bEnableState);
    }

    public boolean isForwardButtonEnabled() {
        AbstractButton forwardButton = this.wizardInterface.getForwardButton();
        return forwardButton.isEnabled();
    }

    public void resolveForwardButton() {
        this.enableForwardButton(true);
    }

    public void setStepText(int stepNum, boolean optional, String header, String[] paragraphs) {
        this.lblStep.removeAll();
        this.lblStep.setLayout(new GridLayout(1, 1));
        this.stepTextPanel = new WizardStepTextPanel(stepNum, optional, header, paragraphs);
        this.lblStep.add(this.stepTextPanel);
    }

    public void setStepText(int stepNum, String header) {
        this.setStepText(stepNum, false, header, null);
    }

    public int getStepNum() {
        int stepNum = -1;
        if (this.stepTextPanel != null) {
            stepNum = this.stepTextPanel.getStepNum();
        }
        return stepNum;
    }

    public void replaceStepNum(int newStepNum) {
        if (this.stepTextPanel != null) {
            this.stepTextPanel.replaceStepNum(newStepNum);
        }
    }

    public String getEntireStepText() {
        return this.stepTextPanel.getText();
    }

    public void setMainContent(JComponent cmpComponent) {
        this.pnlMainContent.add(cmpComponent);
    }
}

