/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.util;

import com.metamatrix.common.tree.TreeNode;
import com.metamatrix.common.tree.directory.DirectoryEntry;
import com.metamatrix.common.tree.directory.DirectoryEntryFilter;
import com.metamatrix.common.tree.directory.DirectoryEntryView;
import com.metamatrix.common.tree.directory.FileSystemFilter;
import com.metamatrix.common.tree.directory.FileSystemView;
import com.metamatrix.console.ui.util.BasicWizardSubpanelContainer;
import com.metamatrix.console.ui.util.MDCPOpenStateListener;
import com.metamatrix.console.ui.util.ModifiedDirectoryChooserPanel;
import com.metamatrix.console.ui.util.WizardInterface;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.toolbox.preference.UserPreferences;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;

public class ChooserPanel
extends BasicWizardSubpanelContainer
implements MDCPOpenStateListener {
    private ModifiedDirectoryChooserPanel dirPnlChooser;
    private String userPrefKey = "metamatrix.console.directory";
    private String path = null;

    public ChooserPanel(WizardInterface wizardInterface, int step, int openOrSave, String stepDesc, String[] fileExtensions, String fileViewDescription, String userPreferenceKey) {
        this(wizardInterface, step, openOrSave, stepDesc, fileExtensions, fileViewDescription);
        this.userPrefKey = userPreferenceKey;
    }

    public ChooserPanel(WizardInterface wizardInterface, int step, int openOrSave, String stepDesc, String[] fileExtensions, String fileViewDescription) {
        super(wizardInterface);
        this.setStepText(step, stepDesc);
        FileSystemView view = new FileSystemView();
        String dirTxt = (String)UserPreferences.getInstance().getValue(this.userPrefKey);
        if (dirTxt != null) {
            try {
                view.setHome((TreeNode)view.lookup(dirTxt));
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        FileSystemFilter filter = new FileSystemFilter(view, fileExtensions, fileViewDescription);
        FileSystemFilter[] filters = new FileSystemFilter[]{filter};
        this.dirPnlChooser = new ModifiedDirectoryChooserPanel((DirectoryEntryView)view, openOrSave, (DirectoryEntryFilter[])filters, this){

            @Override
            protected JComponent createNavigationBar() {
                return null;
            }

            @Override
            protected void populateTopButtonsPanel() {
            }
        };
        this.dirPnlChooser.setAllowFolderCreation(false);
        this.dirPnlChooser.setShowNewFolderButton(false);
    }

    private void chooserStateChanged(String textEntered) {
        boolean enabling = textEntered.length() > 0;
        AbstractButton forwardButton = this.getWizardInterface().getForwardButton();
        forwardButton.setEnabled(enabling);
    }

    public ModifiedDirectoryChooserPanel getChooserPanel() {
        return this.dirPnlChooser;
    }

    public void init() {
        this.dirPnlChooser.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ev) {
                JTextComponent textField = (JTextComponent)ev.getSource();
                String textEntered = textField.getText().trim();
                ChooserPanel.this.chooserStateChanged(textEntered);
            }
        });
        this.setMainContent(this.dirPnlChooser);
    }

    @Override
    public void fileSelectionIsValid(boolean flag) {
        AbstractButton forwardButton = this.getWizardInterface().getForwardButton();
        forwardButton.setEnabled(flag);
    }

    public boolean canOpen() {
        return this.dirPnlChooser.getAcceptButton().isEnabled();
    }

    public String getEnteredFileName() {
        String name = null;
        String directory = this.dirPnlChooser.getParentDirectoryEntry().toString();
        DirectoryEntry fse = (DirectoryEntry)this.dirPnlChooser.getSelectedTreeNode();
        if (fse != null) {
            name = fse.getFullName();
        } else {
            if (!directory.endsWith(File.separator)) {
                directory = directory + File.separator;
            }
            String fileNameEntered = this.dirPnlChooser.getNameFieldText().trim();
            name = directory + fileNameEntered;
        }
        this.path = directory;
        return name;
    }

    public String getSelectedFullFileName() {
        DirectoryEntry result = (DirectoryEntry)this.dirPnlChooser.getSelectedTreeNode();
        if (result != null) {
            this.path = this.dirPnlChooser.getParentDirectoryEntry().toString();
            return result.getNamespace();
        }
        return null;
    }

    public String getSelectedFileName() {
        String fullName = this.getSelectedFullFileName();
        String fileName = StaticUtilities.getFileName(fullName);
        return fileName;
    }

    public String getDirectoryName() {
        String directoryName = null;
        String fullName = this.getSelectedFullFileName();
        if (fullName != null) {
            int index = fullName.lastIndexOf(File.separatorChar);
            directoryName = fullName.substring(0, index);
        }
        return directoryName;
    }

    public void saveCurrentDirLocation() {
        this.path = this.dirPnlChooser.getParentDirectoryEntry().toString();
        UserPreferences.getInstance().setValue(this.userPrefKey, this.path);
        UserPreferences.getInstance().saveChanges();
    }
}

