/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.util;

import com.metamatrix.toolbox.ui.widget.TableWidget;
import com.metamatrix.toolbox.ui.widget.table.EnhancedTableColumn;
import java.util.List;

public class ColumnSortInfo {
    private String colHeader;
    private boolean ascending;

    public static ColumnSortInfo[] getTableColumnSortInfo(TableWidget table) {
        int numSortColumns = table.getSortedColumnCount();
        ColumnSortInfo[] csi = new ColumnSortInfo[numSortColumns];
        List sortedColumns = table.getSortedColumns();
        if (numSortColumns == 1) {
            EnhancedTableColumn col = (EnhancedTableColumn)sortedColumns.get(0);
            String colName = (String)col.getIdentifier();
            boolean ascending = col.isSortedAscending();
            csi[0] = new ColumnSortInfo(colName, ascending);
        } else if (numSortColumns > 1) {
            for (EnhancedTableColumn col : sortedColumns) {
                int loc = col.getSortPriority() - 1;
                String colName = (String)col.getIdentifier();
                boolean ascending = col.isSortedAscending();
                csi[loc] = new ColumnSortInfo(colName, ascending);
            }
        }
        return csi;
    }

    public static void setColumnSortOrder(ColumnSortInfo[] csi, TableWidget table) {
        boolean firstSortCol = true;
        for (int i = 0; i < csi.length; ++i) {
            boolean addToExistingSortColumns;
            EnhancedTableColumn col = null;
            try {
                col = (EnhancedTableColumn)table.getColumn(csi[i].getColHeader());
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (col == null) continue;
            boolean bl = addToExistingSortColumns = !firstSortCol;
            if (csi[i].isAscending()) {
                table.setColumnSortedAscending(col, addToExistingSortColumns);
            } else {
                table.setColumnSortedDescending(col, addToExistingSortColumns);
            }
            firstSortCol = false;
        }
    }

    public ColumnSortInfo(String hdr, boolean asc) {
        this.colHeader = hdr;
        this.ascending = asc;
    }

    public String getColHeader() {
        return this.colHeader;
    }

    public boolean isAscending() {
        return this.ascending;
    }
}

