/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.util;

import com.metamatrix.console.ui.util.LazyBranchNode;
import com.metamatrix.metadata.runtime.api.MetadataID;
import com.metamatrix.metadata.runtime.api.MetadataObject;
import com.metamatrix.toolbox.ui.widget.util.IconFactory;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class ConsoleCellRenderer
implements ListCellRenderer,
TreeCellRenderer {
    public static final ImageIcon FOLDER_ICON;
    public static final ImageIcon FOLDER_OPEN_ICON;
    public static final ImageIcon LOCKED_MODEL_ICON;
    public static final ImageIcon MODEL_ICON;
    public static final ImageIcon LOCKED_DATASOURCE_ICON;
    public static final ImageIcon VIRTUAL_MODEL_ICON;
    public static final ImageIcon PHYSICAL_MODEL_ICON;
    public static final ImageIcon ATTRIBUTE_ICON;
    public static final ImageIcon STORED_PROCEDURE_ICON;
    public static final ImageIcon XML_DOCUMENT_ICON;
    public static final ImageIcon SERVICE_GROUP_ICON;
    public static final ImageIcon QUERY_ICON;
    public static final ImageIcon EXTRACTOR_ICON;
    public static final ImageIcon LOGGER_ICON;
    public static final ImageIcon USER_GROUP_ICON;
    public static final ImageIcon USER_ICON;
    public static final ImageIcon ROLE_ICON;
    public static final ImageIcon SERVICE_ICON;
    public static final ImageIcon VIRTUAL_MACHINE_ICON;
    public static final ImageIcon HOST_MACHINE_ICON;
    public static final ImageIcon MACHINE_GROUP_ICON;
    private DefaultListCellRenderer listCellRenderer = null;
    private DefaultTreeCellRenderer treeCellRenderer = null;
    private boolean useFullName = false;

    public ConsoleCellRenderer() {
        this(new DefaultListCellRenderer(), new DefaultTreeCellRenderer());
    }

    public ConsoleCellRenderer(DefaultListCellRenderer listCellRenderer, DefaultTreeCellRenderer treeCellRenderer) {
        this.listCellRenderer = listCellRenderer;
        this.treeCellRenderer = treeCellRenderer;
    }

    public void setUseFullName(boolean flag) {
        this.useFullName = flag;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.treeCellRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        this.treeCellRenderer.setText(this.getValueString(value));
        TreePath path = tree.getPathForRow(row);
        if (path != null) {
            path.getPathCount();
        }
        this.treeCellRenderer.setIcon(this.getValueIcon(value, expanded));
        return this.treeCellRenderer;
    }

    public void setServiceNotMachineGrouping(boolean serviceNotMachineGrouping) {
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean hasFocus) {
        this.listCellRenderer.getListCellRendererComponent((JList<?>)list, value, index, selected, hasFocus);
        this.listCellRenderer.setText(this.getValueString(value));
        this.listCellRenderer.setIcon(this.getValueIcon(value, false));
        return this.listCellRenderer;
    }

    public String getValueString(Object value) {
        if (!(value instanceof LazyBranchNode) && value instanceof DefaultMutableTreeNode) {
            value = ((DefaultMutableTreeNode)value).getUserObject();
        }
        String result = value instanceof MetadataObject ? this.getValueString(((MetadataObject)value).getID()) : (value instanceof MetadataID ? (this.useFullName ? ((MetadataID)value).getFullName() : ((MetadataID)value).getName()) : (value != null ? value.toString() : "null"));
        return result;
    }

    public Icon getValueIcon(Object value, boolean expanded) {
        Icon result = null;
        if (value == null) {
            return result;
        }
        if (value instanceof DefaultMutableTreeNode) {
            value = ((DefaultMutableTreeNode)value).getUserObject();
        }
        return result;
    }

    static {
        IconFactory.setDefaultJarPath("/com/metamatrix/console/images/");
        IconFactory.setDefaultRelativePath("../images/");
        FOLDER_ICON = IconFactory.getIconForImageFile("folder.gif");
        FOLDER_OPEN_ICON = IconFactory.getIconForImageFile("folderOpen.gif");
        LOCKED_MODEL_ICON = IconFactory.getIconForImageFile("locked_model.gif");
        MODEL_ICON = IconFactory.getIconForImageFile("model.gif");
        LOCKED_DATASOURCE_ICON = IconFactory.getIconForImageFile("locked_catalog.gif");
        VIRTUAL_MODEL_ICON = IconFactory.getIconForImageFile("rt_virtual_model_node.gif");
        PHYSICAL_MODEL_ICON = IconFactory.getIconForImageFile("rt_physical_model_node.gif");
        ATTRIBUTE_ICON = IconFactory.getIconForImageFile("dt_element_node.gif");
        STORED_PROCEDURE_ICON = IconFactory.getIconForImageFile("dt_physical_procedure_node.gif");
        XML_DOCUMENT_ICON = IconFactory.getIconForImageFile("dt_xml_document.gif");
        SERVICE_GROUP_ICON = IconFactory.getIconForImageFile("serviceGroup.gif");
        QUERY_ICON = IconFactory.getIconForImageFile("query.gif");
        EXTRACTOR_ICON = IconFactory.getIconForImageFile("extractpr.gif");
        LOGGER_ICON = IconFactory.getIconForImageFile("logger.gif");
        USER_GROUP_ICON = IconFactory.getIconForImageFile("groups16.gif");
        USER_ICON = IconFactory.getIconForImageFile("users16.gif");
        ROLE_ICON = IconFactory.getIconForImageFile("role.gif");
        SERVICE_ICON = IconFactory.getIconForImageFile("extractor.gif");
        VIRTUAL_MACHINE_ICON = IconFactory.getIconForImageFile("virtualMachine.gif");
        HOST_MACHINE_ICON = IconFactory.getIconForImageFile("hostMachine.gif");
        MACHINE_GROUP_ICON = IconFactory.getIconForImageFile("machineGroup.gif");
    }
}

