/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.util;

import com.metamatrix.console.ui.util.ComboData;
import com.metamatrix.toolbox.ui.UIDefaults;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;

class IconComboRenderer
extends JLabel
implements ListCellRenderer {
    final Icon diskIcon = UIDefaults.getInstance().getIcon("FileView.hardDriveIcon");
    final Icon folderIcon = UIDefaults.getInstance().getIcon("Tree.closedIcon");
    final Icon elementIcon = UIDefaults.getInstance().getIcon("Tree.leafIcon");
    protected Color m_textSelectionColor;
    protected Color m_textNonSelectionColor;
    protected Color m_textNonselectableColor;
    protected Color m_bkSelectionColor;
    protected Color m_bkNonSelectionColor;
    protected Color m_borderSelectionColor;
    protected Color m_textColor = this.m_textNonSelectionColor;
    protected Color m_bkColor = this.m_bkNonSelectionColor;
    protected boolean m_hasFocus;

    public IconComboRenderer() {
        this.setOpaque(false);
    }

    public Component getListCellRendererComponent(JList list, Object obj, int row, boolean sel, boolean hasFocus) {
        this.m_bkColor = list.getBackground();
        this.m_textColor = list.getForeground();
        this.m_bkSelectionColor = list.getSelectionBackground();
        this.m_textSelectionColor = list.getSelectionForeground();
        this.m_textNonSelectionColor = this.m_textColor;
        this.m_bkNonSelectionColor = this.m_bkColor;
        if (obj == null) {
            return this;
        }
        boolean selectable = true;
        if (obj instanceof ComboData) {
            ComboData comboData = (ComboData)obj;
            String displayName = comboData.toString();
            this.setText(displayName);
            if (comboData.isLeaf()) {
                this.setIcon(this.elementIcon);
            } else if (comboData.isRoot()) {
                this.setIcon(this.diskIcon);
            } else {
                this.setIcon(this.folderIcon);
            }
            EmptyBorder b = row == -1 ? new EmptyBorder(0, 0, 0, 0) : new EmptyBorder(0, comboData.getIndex() * 16, 0, 0);
            this.setBorder(b);
        }
        this.setFont(list.getFont());
        this.m_textColor = sel ? this.m_textSelectionColor : (selectable ? this.m_textNonSelectionColor : this.m_textNonselectableColor);
        this.m_bkColor = sel ? this.m_bkSelectionColor : this.m_bkNonSelectionColor;
        this.m_hasFocus = hasFocus;
        return this;
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(this.m_bkNonSelectionColor);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(this.m_bkColor);
        int offset = 0;
        g.fillRect(offset, 0, this.getWidth() - 1 - offset, this.getHeight() - 1);
        if (this.m_hasFocus) {
            g.setColor(this.m_borderSelectionColor);
            g.drawRect(offset, 0, this.getWidth() - 1 - offset, this.getHeight() - 1);
        }
        this.setForeground(this.m_textColor);
        this.setBackground(this.m_bkColor);
        super.paint(g);
    }
}

