/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JPanel;

public class IconComponent
extends JPanel
implements Icon {
    private Icon[] icons;
    private int iconWidth;
    private int iconHeight;

    public IconComponent(Icon[] icns) {
        this.icons = icns;
    }

    public IconComponent(Icon icn) {
        this.icons = new Icon[]{icn};
        this.setSize();
    }

    private void setSize() {
        int totalWidth = 0;
        int maxHeight = 0;
        for (int i = 0; i < this.icons.length; ++i) {
            int curWidth = this.icons[i].getIconWidth();
            int curHeight = this.icons[i].getIconHeight();
            totalWidth += curWidth;
            if (curHeight <= maxHeight) continue;
            maxHeight = curHeight;
        }
        this.iconWidth = totalWidth;
        this.iconHeight = maxHeight;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.iconWidth, this.iconHeight);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public void paint(Graphics g) {
        int widthSoFar = 0;
        for (int i = 0; i < this.icons.length; ++i) {
            int curHeight = this.icons[i].getIconHeight();
            int curWidth = this.icons[i].getIconWidth();
            int excessHeight = this.iconHeight - curHeight;
            int yOffset = excessHeight / 2;
            this.icons[i].paintIcon(this, g, widthSoFar, yOffset);
            widthSoFar += curWidth;
        }
    }

    @Override
    public int getIconHeight() {
        return this.iconHeight;
    }

    @Override
    public int getIconWidth() {
        return this.iconWidth;
    }

    @Override
    public void paintIcon(Component comp, Graphics g, int x, int y) {
        int widthSoFar = 0;
        for (int i = 0; i < this.icons.length; ++i) {
            int curHeight = this.icons[i].getIconHeight();
            int curWidth = this.icons[i].getIconWidth();
            int excessHeight = this.iconHeight - curHeight;
            int yOffset = excessHeight / 2;
            this.icons[i].paintIcon(comp, g, widthSoFar, yOffset);
            widthSoFar += curWidth;
        }
    }
}

