/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.util;

import com.metamatrix.console.ui.util.ItemsBlockedCallback;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class ItemsBlockedTreeSelectionListener
implements TreeSelectionListener {
    private JTree theTree;
    private ItemsBlockedCallback callback;

    public ItemsBlockedTreeSelectionListener(JTree tree, ItemsBlockedCallback cb) {
        this.theTree = tree;
        this.callback = cb;
    }

    @Override
    public void valueChanged(TreeSelectionEvent ev) {
        Object[] blockedItems = this.callback.getBlockedItems();
        int totalBlocked = 0;
        TreePath[] tp = this.theTree.getSelectionPaths();
        if (tp != null) {
            for (int i = 0; i < tp.length; ++i) {
                String lastNode = tp[i].getLastPathComponent().toString();
                int j = 0;
                boolean matchFound = false;
                while (j < blockedItems.length && !matchFound) {
                    if (lastNode.equals(blockedItems[j].toString())) {
                        this.theTree.removeSelectionPath(tp[i]);
                        matchFound = true;
                        ++totalBlocked;
                        continue;
                    }
                    ++j;
                }
            }
            if (tp.length == 1) {
                if (totalBlocked == 1) {
                    this.callback.itemSelectionBlocked();
                } else {
                    this.callback.itemSelectionChanged(tp[0]);
                }
            }
        }
    }
}

