/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.util;

import com.metamatrix.console.ui.tree.ChildSortingTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;

public abstract class LazyBranchNode
extends ChildSortingTreeNode {
    protected Object id;
    protected boolean populated = false;

    public LazyBranchNode(DefaultTreeModel treeModel, Object id) {
        super(treeModel);
        this.setUserObject(id);
        this.id = id;
    }

    @Override
    public void add(MutableTreeNode newChild) {
        if (!this.populated) {
            this.removeAllChildren();
            this.populated = true;
        }
        super.add(newChild);
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    public boolean isPopulated() {
        return this.populated;
    }

    public void setPopulated() {
        this.populated = true;
    }

    public void resetPopulated() {
        this.populated = false;
    }

    public abstract void populate() throws Exception;
}

