/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.util;

import com.metamatrix.common.object.PropertiedObject;
import com.metamatrix.common.object.PropertiedObjectEditor;
import com.metamatrix.common.object.PropertyDefinition;
import com.metamatrix.console.ui.ViewManager;
import com.metamatrix.console.ui.util.AbstractPropertiedObjectPanelHolder;
import com.metamatrix.console.ui.util.InitialAndCurrentValues;
import com.metamatrix.console.ui.util.POPWithButtonsController;
import com.metamatrix.console.ui.util.PropertiedObjectPanelHolder;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.property.PropertiedObjectPanel;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JPanel;

public class POPWithButtons
extends JPanel
implements PropertyChangeListener {
    private AbstractPropertiedObjectPanelHolder thePanel;
    private PropertiedObjectEditor theEditor;
    private AbstractButton applyButton;
    private AbstractButton resetButton;
    private Map valuesMap = new HashMap();
    private Map defsMap = new HashMap();
    private POPWithButtonsController controller;

    public POPWithButtons(AbstractPropertiedObjectPanelHolder pnl, PropertiedObjectEditor edtr, POPWithButtonsController ctrlr) {
        this.controller = ctrlr;
        this.theEditor = edtr;
        this.thePanel = pnl;
        this.thePanel.getThePanel().addPropertyChangeListener(this);
        this.init();
        this.setInitialValues();
        this.setButtons();
    }

    public POPWithButtons(PropertiedObjectPanel pnl, PropertiedObjectEditor editor, POPWithButtonsController controller) {
        this(new PropertiedObjectPanelHolder(pnl, null), editor, controller);
    }

    private void init() {
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        JPanel buttonsPanel = new JPanel();
        GridBagLayout bl = new GridBagLayout();
        buttonsPanel.setLayout(bl);
        JPanel buttonsInnerPanel = new JPanel(new GridLayout(1, 2, 8, 0));
        this.applyButton = new ButtonWidget("Apply");
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                POPWithButtons.this.applyPressed();
            }
        });
        this.resetButton = new ButtonWidget("Reset");
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                POPWithButtons.this.resetPressed();
            }
        });
        buttonsInnerPanel.add(this.applyButton);
        buttonsInnerPanel.add(this.resetButton);
        buttonsPanel.add(buttonsInnerPanel);
        bl.setConstraints(buttonsInnerPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.thePanel);
        this.add(buttonsPanel);
        layout.setConstraints(this.thePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        layout.setConstraints(buttonsPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    public PropertiedObjectEditor getEditor() {
        return this.theEditor;
    }

    public void setButtons() {
        boolean changed = this.anyValueChanged();
        this.applyButton.setEnabled(changed && !this.anyValueInvalid());
        this.resetButton.setEnabled(changed);
    }

    private void setInitialValues() {
        PropertiedObject propObj = this.thePanel.getThePanel().getPropertiedObject();
        if (propObj != null) {
            List defs = this.theEditor.getPropertyDefinitions(propObj);
            for (PropertyDefinition def : defs) {
                this.defsMap.put(def.getName(), def);
                Object value = this.theEditor.getValue(propObj, def);
                InitialAndCurrentValues vals = new InitialAndCurrentValues(value, value);
                this.valuesMap.put(def, vals);
            }
        }
        this.setButtons();
    }

    public PropertiedObjectPanel getPropertiedObjectPanel() {
        return this.thePanel.getThePanel();
    }

    public void setPropertiedObject(PropertiedObject propObj) {
        this.thePanel.getThePanel().setNameColumnHeaderWidth(0);
        this.thePanel.getThePanel().setPropertiedObject(propObj);
        this.setInitialValues();
    }

    private boolean anyValueInvalid() {
        List invalidDefs = this.thePanel.getThePanel().getInvalidDefinitions();
        boolean anyInvalid = invalidDefs.size() > 0;
        return anyInvalid;
    }

    public boolean anyValueChanged() {
        boolean changeFound = false;
        Iterator it = this.valuesMap.entrySet().iterator();
        while (it.hasNext() && !changeFound) {
            Map.Entry me = it.next();
            InitialAndCurrentValues vals = (InitialAndCurrentValues)me.getValue();
            if (vals.valuesEqual()) continue;
            changeFound = true;
        }
        return changeFound;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String defName = evt.getPropertyName();
        Object oldValue = evt.getOldValue();
        Object newValue = evt.getNewValue();
        PropertyDefinition defn = (PropertyDefinition)this.defsMap.get(defName);
        InitialAndCurrentValues vals = (InitialAndCurrentValues)this.valuesMap.get(defn);
        if (vals == null) {
            vals = new InitialAndCurrentValues(oldValue, newValue);
            this.valuesMap.put(defn, vals);
        } else {
            vals.setCurrentValue(newValue);
        }
        this.setButtons();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyPressed() {
        boolean proceeding = false;
        try {
            StaticUtilities.startWait(ViewManager.getMainFrame());
            proceeding = this.controller.doApplyChanges(this.thePanel.getThePanel());
        }
        catch (Exception e) {
            ExceptionUtility.showMessage("Failed modifying CB properties", e);
        }
        finally {
            StaticUtilities.endWait(ViewManager.getMainFrame());
        }
        if (proceeding) {
            this.setInitialValues();
            this.setButtons();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetPressed() {
        try {
            StaticUtilities.startWait(ViewManager.getMainFrame());
            PropertiedObject propObj = this.thePanel.getThePanel().getPropertiedObject();
            for (Map.Entry me : this.valuesMap.entrySet()) {
                InitialAndCurrentValues vals = (InitialAndCurrentValues)me.getValue();
                if (vals.valuesEqual()) continue;
                PropertyDefinition def = (PropertyDefinition)me.getKey();
                this.theEditor.setValue(propObj, def, vals.getInitialValue());
                vals.setCurrentValue(vals.getInitialValue());
            }
            this.thePanel.getThePanel().refreshDisplay();
            this.setButtons();
        }
        catch (Exception e) {
            ExceptionUtility.showMessage("Failed modifying CB properties", e);
        }
        finally {
            StaticUtilities.endWait(ViewManager.getMainFrame());
        }
    }

    public void setButtonsVisible(boolean flag) {
        this.applyButton.setVisible(flag);
        this.resetButton.setVisible(flag);
    }

    public boolean havePendingChanges() {
        return this.applyButton.isVisible() && this.applyButton.isEnabled();
    }
}

