/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.util;

import com.metamatrix.console.ui.util.AllAction;
import com.metamatrix.console.ui.util.CancelAction;
import com.metamatrix.console.ui.util.NoneAction;
import com.metamatrix.console.ui.util.SelectAllOrNoneMessageReceiver;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;

public class SelectAllOrNonePopupController {
    public static final String DEFAULT_ALL_TEXT = "Select All";
    public static final String DEFAULT_NONE_TEXT = "Select None";
    private SelectAllOrNoneMessageReceiver receiver;
    private Component[] components;
    private String selectAllText;
    private String selectNoneText;
    JPopupMenu popupMenu = new JPopupMenu();

    public SelectAllOrNonePopupController(SelectAllOrNoneMessageReceiver rcvr, Component[] comp, String allText, String noneText) {
        this.receiver = rcvr;
        this.components = comp;
        this.selectAllText = allText;
        this.selectNoneText = noneText;
        this.init();
    }

    public SelectAllOrNonePopupController(SelectAllOrNoneMessageReceiver rcvr, Component[] comp) {
        this(rcvr, comp, DEFAULT_ALL_TEXT, DEFAULT_NONE_TEXT);
    }

    private void init() {
        AllAction allAction = new AllAction(this.selectAllText, this.receiver);
        this.popupMenu.add(allAction);
        NoneAction noneAction = new NoneAction(this.selectNoneText, this.receiver);
        this.popupMenu.add(noneAction);
        CancelAction cancelAction = new CancelAction();
        this.popupMenu.add(cancelAction);
        for (int i = 0; i < this.components.length; ++i) {
            final int ss = i;
            this.components[i].addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent ev) {
                    this.check(ev);
                }

                private void check(MouseEvent ev) {
                    boolean notShowing = !SelectAllOrNonePopupController.this.popupMenu.isVisible();
                    boolean isTrigger = ev.isPopupTrigger();
                    if (notShowing && isTrigger) {
                        SelectAllOrNonePopupController.this.popupMenu.show(SelectAllOrNonePopupController.this.components[ss], ev.getX() + 10, ev.getY());
                    }
                }
            });
        }
    }
}

