/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.util;

import com.metamatrix.console.util.StaticQuickSorter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListModel;

public class StringListBasedListModel
extends DefaultListModel {
    private List list;
    private boolean keepSorted;

    public StringListBasedListModel(List l, boolean sortFlag) {
        this.list = l;
        this.keepSorted = sortFlag;
        if (this.keepSorted) {
            this.sort();
        }
    }

    public StringListBasedListModel(String[] s, boolean sortFlag) {
        this.keepSorted = sortFlag;
        this.list = new ArrayList();
        for (int i = 0; i < s.length; ++i) {
            this.list.add(s[i]);
        }
        if (this.keepSorted) {
            this.sort();
        }
    }

    @Override
    public int getSize() {
        return this.list.size();
    }

    @Override
    public Object getElementAt(int index) {
        Object obj = null;
        if (index >= 0 && index < this.getSize()) {
            obj = this.list.get(index);
        }
        return obj;
    }

    public void addElement(String element) {
        this.list.add(element);
        if (this.keepSorted) {
            this.sort();
        }
        this.refresh();
    }

    public void addElements(List elements) {
        for (String s : elements) {
            this.list.add(s);
        }
        if (this.keepSorted) {
            this.sort();
        }
        this.refresh();
    }

    public void addElements(String[] s) {
        for (int i = 0; i < s.length; ++i) {
            this.list.add(s[i]);
        }
        if (this.keepSorted) {
            this.sort();
        }
        this.refresh();
    }

    public void removeElement(String element) {
        int index = this.list.indexOf(element);
        if (index >= 0) {
            this.list.remove(element);
            this.refresh();
        }
    }

    @Override
    public void removeAllElements() {
        for (int i = this.list.size() - 1; i >= 0; --i) {
            this.list.remove(i);
        }
        this.refresh();
    }

    private void refresh() {
        this.fireContentsChanged(this, 0, this.list.size() - 1);
    }

    private void sort() {
        String[] unsorted = new String[this.list.size()];
        Iterator it = this.list.iterator();
        int loc = 0;
        while (it.hasNext()) {
            unsorted[loc] = (String)it.next();
            ++loc;
        }
        String[] sorted = StaticQuickSorter.quickStringSort(unsorted);
        for (int i = 0; i < sorted.length; ++i) {
            this.list.set(i, sorted[i]);
        }
    }
}

