/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.util;

import com.metamatrix.toolbox.ui.widget.table.DefaultTableCellRenderer;
import java.awt.Component;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class TableCellRendererFactory {
    private static Hashtable rendererMap = new Hashtable();

    private TableCellRendererFactory() {
    }

    public static TableCellRenderer createDateRenderer(SimpleDateFormat theFormatter) {
        TableCellRenderer renderer = (TableCellRenderer)rendererMap.get(theFormatter.toPattern());
        if (renderer == null) {
            renderer = new DateRenderer(theFormatter);
            rendererMap.put(theFormatter.toPattern(), renderer);
        }
        return renderer;
    }

    private static class DateRenderer
    extends DefaultTableCellRenderer {
        private SimpleDateFormat formatter;

        public DateRenderer(SimpleDateFormat theFormatter) {
            this.formatter = theFormatter;
        }

        @Override
        public Component getTableCellRendererComponent(JTable theTable, Object theValue, boolean theSelectedFlag, boolean theHasFocusFlag, int theRow, int theColumn) {
            Object value = theValue;
            if (theValue instanceof Date) {
                value = this.formatter.format((Date)value);
            }
            return super.getTableCellRendererComponent(theTable, value, theSelectedFlag, theHasFocusFlag, theRow, theColumn);
        }
    }
}

