/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.util;

import com.metamatrix.toolbox.ui.widget.LabelWidget;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class WizardStepTextPanel
extends JPanel {
    private static final int MINIMUM_HEIGHT = 20;
    private int stepNum;
    private boolean optional;
    private String header;
    private String[] paragraphs;
    private JTextArea textPane;

    public WizardStepTextPanel(int stepNum, boolean optional, String header, String[] paragraphs) {
        this.stepNum = stepNum;
        this.optional = optional;
        this.header = header;
        this.paragraphs = paragraphs;
        if (this.paragraphs == null) {
            this.paragraphs = new String[0];
        }
        this.init();
    }

    private void init() {
        Font defaultFont = new LabelWidget().getFont();
        Font font = new Font(defaultFont.getName(), 1, defaultFont.getSize());
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        String str = "";
        if (this.stepNum > 0) {
            str = str + "Step " + this.stepNum;
            if (this.optional) {
                str = str + " (Optional)";
            }
            str = str + ": ";
        }
        str = str + this.header;
        for (int i = 0; i < this.paragraphs.length; ++i) {
            str = str + '\n' + this.paragraphs[i];
        }
        this.setBorder(BorderFactory.createEtchedBorder());
        this.textPane = new JTextArea();
        this.textPane.setFont(font);
        this.textPane.setText(str);
        this.textPane.setLineWrap(true);
        this.textPane.setWrapStyleWord(true);
        this.textPane.setEditable(false);
        this.textPane.setBackground(new JPanel().getBackground());
        this.add(this.textPane);
        this.setBackground(this.textPane.getBackground());
        layout.setConstraints(this.textPane, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension superMinSize = super.getMinimumSize();
        Dimension ourMinSize = new Dimension(superMinSize.width, Math.max(superMinSize.height, 20));
        return ourMinSize;
    }

    public int getStepNum() {
        return this.stepNum;
    }

    public void replaceStepNum(int newStepNum) {
        String text = this.textPane.getText();
        int blankLoc = text.indexOf(32, 5);
        int colonLoc = text.indexOf(58, 5);
        int nextNonNumericLoc = Math.min(blankLoc, colonLoc);
        String newStepNumStr = new Integer(newStepNum).toString();
        String newText = text.substring(0, 5) + newStepNumStr + text.substring(nextNonNumericLoc);
        this.textPane.setText(newText);
    }

    public String getText() {
        return this.textPane.getText();
    }
}

