/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.util.property;

import com.metamatrix.console.ui.util.property.PropertyProvider;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.toolbox.ui.Validator;
import com.metamatrix.toolbox.ui.widget.TextFieldWidget;
import com.metamatrix.toolbox.ui.widget.text.DefaultTextFieldModel;
import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.text.Document;

public class GuiComponentFactory {
    public static final String SEPARATOR = ".";
    public static final String TYPE_DEFS_PROP = "com/metamatrix/console/ui/data/type_defs";
    public static final String TYPE_PREFIX = "type.";
    private static final String COLLAPSE = ".collapsespaces";
    private static final String COLUMNS = ".cols";
    private static final String INVALID_CHARS = ".invalidchars";
    private static final String LENGTH_MAX = ".length.max";
    private static final String LENGTH_MIN = ".length.min";
    private static final String REQUIRED = ".required";
    private static final String TRIM = ".trim";
    private static final String VALID_CHARS = ".validchars";
    private static Map descriptorMap = Collections.synchronizedMap(new HashMap());
    private static PropertyProvider propProvider = new PropertyProvider("com/metamatrix/console/ui/data/type_defs");

    private GuiComponentFactory() {
    }

    public static JComponent createComponent(String theKey, PropertyProvider thePropProvider) {
        if (theKey == null || thePropProvider == null) {
            throw new IllegalArgumentException("Either the key <" + theKey + ">, or the property provider <" + thePropProvider + "> is null.");
        }
        String className = thePropProvider.getString(theKey, true);
        if (className == null) {
            throw new IllegalArgumentException("The key <" + theKey + "> cannot be found.");
        }
        Class<?> objClass = null;
        try {
            objClass = Class.forName(className);
        }
        catch (Exception theException) {
            throw new IllegalArgumentException("The class <" + className + "> cannot be loaded.");
        }
        if (!JComponent.class.isAssignableFrom(objClass)) {
            throw new IllegalArgumentException("Class is not instanceof JComponent <" + objClass + ">.");
        }
        try {
            JComponent newComp = (JComponent)objClass.newInstance();
            GuiComponentFactory.setProperties(theKey, newComp, thePropProvider);
            return newComp;
        }
        catch (Exception theException) {
            theException.printStackTrace();
            return null;
        }
    }

    public static JPasswordField createPasswordField(String theType) {
        return GuiComponentFactory.createPasswordField(theType, propProvider);
    }

    public static JPasswordField createPasswordField(String theType, PropertyProvider thePropProvider) {
        if (theType == null || thePropProvider == null) {
            throw new IllegalArgumentException("Either the type <" + theType + ">, or the property provider <" + thePropProvider + "> is null.");
        }
        JPasswordField txf = new JPasswordField();
        DefaultTextFieldModel doc = new DefaultTextFieldModel();
        txf.setDocument(doc);
        ValidationProps props = GuiComponentFactory.getValidationProperties(theType, thePropProvider);
        new TextFieldInitializer(props, txf);
        return txf;
    }

    public static TextFieldWidget createTextField(String theType) {
        return GuiComponentFactory.createTextField(theType, propProvider);
    }

    public static TextFieldWidget createTextField(String theType, PropertyProvider thePropProvider) {
        if (theType == null || thePropProvider == null) {
            throw new IllegalArgumentException("Either the type <" + theType + ">, or the property provider <" + thePropProvider + "> is null.");
        }
        TextFieldWidget txf = new TextFieldWidget();
        ValidationProps props = GuiComponentFactory.getValidationProperties(theType, thePropProvider);
        new TextFieldInitializer(props, txf);
        return txf;
    }

    public static TextFieldWidget createTextField(String theType, String theKey, PropertyProvider thePropProvider) {
        if (theKey == null) {
            throw new IllegalArgumentException("The key is null.");
        }
        TextFieldWidget txf = GuiComponentFactory.createTextField(theType, thePropProvider);
        GuiComponentFactory.setProperties(theKey, txf, thePropProvider);
        return txf;
    }

    private static boolean getCollapseSpaces(String theType, PropertyProvider thePropProvider) {
        String temp = thePropProvider.getString(TYPE_PREFIX + theType + COLLAPSE, true);
        return temp == null ? true : Boolean.valueOf(temp);
    }

    private static int getColumns(String theType, PropertyProvider thePropProvider) {
        return thePropProvider.getInt(TYPE_PREFIX + theType + COLUMNS, 15);
    }

    private static String getInvalidCharacters(String theType, PropertyProvider thePropProvider) {
        return thePropProvider.getString(TYPE_PREFIX + theType + INVALID_CHARS, true);
    }

    private static boolean getIsRequired(String theType, PropertyProvider thePropProvider) {
        return thePropProvider.getBoolean(TYPE_PREFIX + theType + REQUIRED);
    }

    private static int getMaximumLength(String theType, PropertyProvider thePropProvider) {
        return thePropProvider.getInt(TYPE_PREFIX + theType + LENGTH_MAX, 15);
    }

    private static int getMinimumLength(String theType, PropertyProvider thePropProvider) {
        return thePropProvider.getInt(TYPE_PREFIX + theType + LENGTH_MIN, 1);
    }

    private static boolean getTrimSpaces(String theType, PropertyProvider thePropProvider) {
        String temp = thePropProvider.getString(TYPE_PREFIX + theType + TRIM, true);
        return temp == null ? true : Boolean.valueOf(temp);
    }

    private static ValidationProps getValidationProperties(String theType, PropertyProvider thePropProvider) {
        ValidationProps props = new ValidationProps();
        props.required = GuiComponentFactory.getIsRequired(theType, thePropProvider);
        props.collapse = GuiComponentFactory.getCollapseSpaces(theType, thePropProvider);
        props.lengthMin = GuiComponentFactory.getMinimumLength(theType, thePropProvider);
        props.lengthMax = GuiComponentFactory.getMaximumLength(theType, thePropProvider);
        props.cols = GuiComponentFactory.getColumns(theType, thePropProvider);
        props.invalidChars = GuiComponentFactory.getInvalidCharacters(theType, thePropProvider);
        props.validChars = GuiComponentFactory.getValidCharacters(theType, thePropProvider);
        props.trim = GuiComponentFactory.getTrimSpaces(theType, thePropProvider);
        return props;
    }

    private static String getValidCharacters(String theType, PropertyProvider thePropProvider) {
        return thePropProvider.getString(TYPE_PREFIX + theType + VALID_CHARS, true);
    }

    public static void setProperties(String theKey, JComponent theComponent, PropertyProvider thePropProvider) {
        if (theKey == null || thePropProvider == null || theComponent == null) {
            throw new IllegalArgumentException("Either the key <" + theKey + ">, the property provider <" + thePropProvider + ">, or the component <" + theComponent + "> is null.");
        }
        Class<?> objClass = theComponent.getClass();
        PropertyDescriptor[] propDescriptors = (PropertyDescriptor[])descriptorMap.get(objClass);
        if (!descriptorMap.containsKey(objClass)) {
            try {
                BeanInfo beanInfo = Introspector.getBeanInfo(objClass);
                propDescriptors = beanInfo.getPropertyDescriptors();
            }
            catch (IntrospectionException theException) {
                // empty catch block
            }
            descriptorMap.put(objClass, propDescriptors);
        }
        if (propDescriptors != null) {
            for (int i = 0; i < propDescriptors.length; ++i) {
                Method setMethod = null;
                if (propDescriptors[i] instanceof IndexedPropertyDescriptor) {
                    IndexedPropertyDescriptor ipd = (IndexedPropertyDescriptor)propDescriptors[i];
                    setMethod = ipd.getIndexedWriteMethod();
                } else {
                    setMethod = propDescriptors[i].getWriteMethod();
                }
                String prop = propDescriptors[i].getName();
                String propSuffix = theKey + SEPARATOR + prop;
                Object value = thePropProvider.getObject(propSuffix);
                if (value == null) continue;
                try {
                    setMethod.invoke((Object)theComponent, value);
                    continue;
                }
                catch (Exception theException) {
                    // empty catch block
                }
            }
        }
    }

    private static class TextFieldInitializer
    implements Validator {
        private ValidationProps props;
        private JTextField txf;

        public TextFieldInitializer(ValidationProps theProps, JTextField theTextField) {
            this.props = theProps;
            this.txf = theTextField;
            this.txf.setColumns(theProps.cols);
            Document tempDoc = this.txf.getDocument();
            if (tempDoc instanceof DefaultTextFieldModel) {
                DefaultTextFieldModel doc = (DefaultTextFieldModel)tempDoc;
                doc.setMaximumLength(this.props.lengthMax);
                if (this.props.invalidChars != null) {
                    try {
                        doc.setInvalidCharacters(this.props.invalidChars);
                    }
                    catch (ParseException theException) {}
                } else if (this.props.validChars != null) {
                    try {
                        doc.setValidCharacters(this.props.validChars);
                    }
                    catch (ParseException theException) {
                        // empty catch block
                    }
                }
                doc.addValidator(this);
            }
            this.txf.setMinimumSize(this.txf.getPreferredSize());
        }

        @Override
        public Object validate(Object theObject) {
            String text;
            if (!(theObject instanceof String)) {
                throw new IllegalArgumentException("Object is not a String. Class=" + theObject);
            }
            String original = (String)theObject;
            String string = text = theObject == null ? "" : original;
            if (this.props.trim) {
                text = text.trim();
            }
            if (this.props.collapse) {
                text = StringUtil.replaceAll((String)text, (String)"  ", (String)" ");
            }
            boolean result = true;
            if (!original.equals(text)) {
                this.txf.setText(text);
            }
            return new Boolean(result);
        }
    }

    private static class ValidationProps {
        public boolean collapse = true;
        public int cols = 15;
        public String invalidChars = null;
        public int lengthMax = 15;
        public int lengthMin = 0;
        public boolean required = false;
        public boolean trim = true;
        public String validChars = null;

        private ValidationProps() {
        }
    }
}

