/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.util.property;

import com.metamatrix.common.properties.ObjectPropertyManager;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class PropertyProvider {
    public static final String DEFAULT_ERROR_PREFIX = "**";
    public static final String COMMON_PROP = "com/metamatrix/console/ui/data/common_ui";
    private String errorPrefix = "**";
    protected AbstractButton DO_NOT_USE_1;
    protected ObjectPropertyManager DO_NOT_USE_2;
    private static Icon missingIcon;
    private List propFiles = new ArrayList();
    private static PropertyProvider defaultProvider;

    public PropertyProvider(String thePropertiesFile) {
        if (thePropertiesFile == null || thePropertiesFile.length() == 0) {
            throw new IllegalArgumentException("Properties file name is null or empty.");
        }
        this.propFiles.add(thePropertiesFile);
    }

    public PropertyProvider(List thePropertiesCollection) {
        if (thePropertiesCollection == null || thePropertiesCollection.isEmpty()) {
            throw new IllegalArgumentException("Properties collection is null or empty.");
        }
        int size = thePropertiesCollection.size();
        for (int i = 0; i < size; ++i) {
            Object obj = thePropertiesCollection.get(i);
            if (obj == null || !(obj instanceof String) || ((String)obj).length() == 0) {
                throw new IllegalArgumentException("Properties collection contains a null object, an object that is not a string, or an empty string.");
            }
            if (this.propFiles.contains(obj)) continue;
            this.propFiles.add(obj);
        }
    }

    public boolean getBoolean(String theKey) {
        String value = this.getString(theKey);
        return value.equals("true");
    }

    public static PropertyProvider getDefault() {
        if (defaultProvider == null) {
            defaultProvider = new PropertyProvider(COMMON_PROP);
        }
        return defaultProvider;
    }

    public String getErrorPrefix() {
        return this.errorPrefix;
    }

    public Icon getIcon(String theKey) {
        URL url;
        Icon result = null;
        String value = this.getString("temp." + theKey, true);
        result = value == null ? PropertyProvider.getMissingIcon() : ((url = ClassLoader.getSystemResource(value)) == null ? PropertyProvider.getMissingIcon() : new ImageIcon(url));
        return result;
    }

    public int getInt(String theKey, int theDefault) {
        int result = theDefault;
        String txt = this.getString(theKey, true);
        if (txt != null) {
            try {
                result = Integer.parseInt(txt);
            }
            catch (NumberFormatException theException) {
                // empty catch block
            }
        }
        return result;
    }

    public static Icon getMissingIcon() {
        if (missingIcon == null) {
            byte[] image = new byte[]{71, 73, 70, 56, 57, 97, 16, 0, 16, 0, -9, 0, 0, 0, 32, 0, 0, 96, 0, 48, 80, 48, 64, 64, 64, 80, 80, 80, 95, 95, 95, 96, 96, 96, 127, 127, 127, 63, 63, -33, 0, 127, -1, 64, 127, -97, 64, 127, -65, 0, -97, 0, 32, -128, 32, 64, -128, 64, 80, -112, 80, 127, -97, 127, 0, -65, -1, 64, -65, -65, 127, -65, -65, -91, 121, 17, -128, 32, -128, -97, 63, -97, -97, 127, -97, -65, 127, -65, -33, 0, -33, -1, 0, -1, -128, -128, -128, -112, -112, -112, -97, -97, -97, -113, -81, -113, -65, -97, -65, -96, -96, -96, -81, -81, -81, -80, -80, -80, -65, -65, -65, -65, -65, -1, -64, -64, -64, -49, -49, -49, -33, -33, -33, -17, -17, -17, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 33, -7, 4, 1, 0, 0, 20, 0, 44, 0, 0, 0, 0, 16, 0, 16, 0, 0, 8, -67, 0, 15, 8, 28, 72, 112, 32, -123, -125, 7, 80, -100, 88, -56, -112, -31, -127, 17, 7, 16, -98, 40, 81, -126, -125, -125, 13, 28, 40, -106, 56, -112, 2, 34, -123, 3, 19, 65, 64, -16, -48, 64, -128, 70, -114, 29, 5, -122, 124, -16, -128, 1, -128, -109, 3, 98, 14, 0, 89, 66, 4, -128, 0, 0, 6, -128, -48, 40, 2, -60, -120, -103, 19, 107, 14, 48, -80, 65, -124, 70, -118, 39, -128, 26, -83, 9, -126, -61, 4, 9, 11, 20, 16, 56, -79, -31, 4, -56, 3, 25, 53, 74, -120, -112, 0, 65, -121, 14, 35, 62, -98, 24, -127, 33, 107, 9, 9, 9, 72, -116, -40, 16, 86, -20, 8, 13, 23, 56, -104, 96, -72, -95, -61, 9, 10, 39, 58, -128, 28, -111, 33, -125, 5, -86, 117, -17, -30, -19, 0, 20, 67, -123, 15, 35, -64, 30, 60, 120, -126, 67, 10, -96, 4, 6, 36, 22, -52, 56, -29, -29, -124, 99, -85, 46, 30, -68, -16, 113, 1, -127, 29, 54, 83, -8, 41, 51, 102, 64, 0, 0, 59};
            missingIcon = new ImageIcon(image);
        }
        return missingIcon;
    }

    public Object getObject(String theKey) {
        String fileName;
        ObjectPropertyManager props;
        Object result = null;
        int size = this.propFiles.size();
        for (int i = 0; i < size && (result = (props = new ObjectPropertyManager(fileName = (String)this.propFiles.get(i))).get(theKey)) == null; ++i) {
        }
        return result;
    }

    public String getPropertiesFile(String theKey) {
        String result = null;
        int size = this.propFiles.size();
        for (int i = 0; i < size; ++i) {
            String fileName = (String)this.propFiles.get(i);
            ObjectPropertyManager props = new ObjectPropertyManager(fileName);
            result = props.getString(theKey);
            if (result == null) continue;
            result = (String)this.propFiles.get(i);
            break;
        }
        return result;
    }

    public String getString(String theKey) {
        return this.getString(theKey, false);
    }

    public String getString(String theKey, boolean theReturnNullFlag) {
        String fileName;
        ObjectPropertyManager props;
        String result = null;
        int size = this.propFiles.size();
        for (int i = 0; i < size && (result = (props = new ObjectPropertyManager(fileName = (String)this.propFiles.get(i))).getString(theKey)) == null; ++i) {
        }
        if (theReturnNullFlag) {
            return result;
        }
        return result == null ? DEFAULT_ERROR_PREFIX + theKey : result;
    }

    public String getString(String theKey, Object[] theArgs) {
        String result = null;
        String fmt = this.getString(theKey, true);
        if (fmt != null) {
            MessageFormat formatter = new MessageFormat(fmt);
            result = formatter.format(theArgs);
        }
        return result;
    }

    public void setErrorPrefix(String theErrorPrefix) {
        this.errorPrefix = theErrorPrefix == null || theErrorPrefix.length() == 0 ? DEFAULT_ERROR_PREFIX : theErrorPrefix;
    }
}

