/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.util.wizard;

import com.metamatrix.console.ui.util.wizard.WizardClient;
import com.metamatrix.console.ui.util.wizard.WizardClientPanel;
import java.util.List;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public abstract class AbstractWizardClient
implements WizardClient {
    private List lstPanels = new Vector();
    private int iFirstPanelIndex = 0;
    private String sTitle = "Default Wizard Title";
    private boolean bCancelClicked = false;
    private boolean bFinishClicked = false;
    private EventListenerList listeners;

    public AbstractWizardClient(String sTitle) {
        this.sTitle = sTitle;
    }

    protected void init() {
    }

    @Override
    public List getPanels() {
        if (this.lstPanels == null) {
            this.lstPanels = new Vector();
        }
        return this.lstPanels;
    }

    public void addPanel(WizardClientPanel wcp) {
        this.getPanels().add(wcp);
    }

    public void setFirstPanelIndex(int iIndex) {
        this.iFirstPanelIndex = iIndex;
    }

    @Override
    public int getFirstPanelIndex() {
        return this.iFirstPanelIndex;
    }

    @Override
    public String getTitle() {
        return this.sTitle;
    }

    @Override
    public void cancelClicked() {
        this.bCancelClicked = true;
        this.fireChangedEvent(new ChangeEvent(this));
    }

    public boolean isCancelClicked() {
        return this.bCancelClicked;
    }

    @Override
    public void finishClicked() {
        this.bFinishClicked = true;
        this.fireChangedEvent(new ChangeEvent(this));
    }

    public boolean isFinishClicked() {
        return this.bFinishClicked;
    }

    private EventListenerList getListeners() {
        if (this.listeners == null) {
            this.listeners = new EventListenerList();
        }
        return this.listeners;
    }

    public void addChangeListener(ChangeListener listener) {
        this.getListeners().add(ChangeListener.class, listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.getListeners().remove(ChangeListener.class, listener);
    }

    protected void fireChangedEvent(ChangeEvent e) {
        Object[] listeners = this.getListeners().getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(e);
        }
    }
}

