/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.util.wizard;

import com.metamatrix.console.ui.util.wizard.AbstractWizardClient;
import com.metamatrix.console.ui.util.wizard.WizardClient;
import com.metamatrix.console.ui.util.wizard.WizardClientPanel;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class WizardPane
extends JPanel
implements ChangeListener {
    public static final String BACK_BUTTON_TEXT = "< Back";
    public static final String NEXT_BUTTON_TEXT = "Next >";
    public static final String CANCEL_BUTTON_TEXT = "Cancel";
    public static final String FINISH_BUTTON_TEXT = "Finish";
    public static final int BACK_MNEMONIC = 66;
    public static final int NEXT_MNEMONIC = 78;
    public static final int CANCEL_MNEMONIC = 67;
    public static final int FINISH_MNEMONIC = 73;
    private JPanel pnlOuter = null;
    private JPanel pnlExplanation = null;
    private JPanel pnlExplanationOuter = null;
    private LabelWidget lblExplanation = null;
    private JPanel pnlContent = null;
    private JPanel pnlContentOuter = null;
    private JPanel pnlButtons = null;
    private JButton backButton;
    private JButton nextButton;
    private JButton cancelButton;
    private boolean showFlag = true;
    private WizardClientPanel wcpCurrentPanel = null;
    private int iCurrentPanelNumber = -1;
    private WizardClient wzcClient = null;
    private Window wnOwnerWindow = null;

    public WizardPane(Window wnOwnerWindow, WizardClient wzcClient) {
        this.wnOwnerWindow = wnOwnerWindow;
        this.wzcClient = wzcClient;
        wzcClient.getFirstPanelIndex();
        this.init();
    }

    public WizardPane(WizardClient wzcClient) {
        this.wzcClient = wzcClient;
        wzcClient.getFirstPanelIndex();
        this.init();
    }

    public void init() {
        this.setLayout(new BorderLayout());
        this.pnlOuter = new JPanel();
        this.pnlOuter.setLayout(new BoxLayout(this.pnlOuter, 1));
        this.pnlOuter.setBorder(new EmptyBorder(new Insets(10, 10, 20, 10)));
        this.add((Component)this.pnlOuter, "Center");
        this.createExplanationPanel();
        this.pnlOuter.add(this.pnlExplanationOuter);
        this.createContentPanel();
        this.pnlOuter.add(this.pnlContentOuter);
        this.createButtonPanel();
        this.pnlOuter.add(this.pnlButtons);
        this.addListening();
        this.processChange(this.iCurrentPanelNumber, this.iCurrentPanelNumber + 1);
    }

    private void addListening() {
        WizardClientPanel wcp2 = null;
        for (WizardClientPanel wcp2 : this.getWizardClient().getPanels()) {
            wcp2.addChangeListener(this);
        }
    }

    private WizardClient getWizardClient() {
        return this.wzcClient;
    }

    private int getPanelArraySize() {
        return this.getWizardClient().getPanels().size();
    }

    private void removeCurrentPanel() {
        if (this.wcpCurrentPanel != null) {
            this.pnlContent.remove((JPanel)((Object)this.wcpCurrentPanel));
        }
    }

    private void addNewPanel(WizardClientPanel wcp) {
        if (wcp != null) {
            this.pnlContent.add((Component)((JPanel)((Object)wcp)), "Center");
            if (wcp.getTitle() != null) {
                this.lblExplanation.setText(wcp.getTitle());
            }
        }
    }

    public void postRealize() {
        this.packMyOwner();
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }

    private void createButtonPanel() {
        this.backButton = new JButton(BACK_BUTTON_TEXT);
        this.backButton.setMnemonic(66);
        this.nextButton = new JButton(NEXT_BUTTON_TEXT);
        this.nextButton.setMnemonic(78);
        this.cancelButton = new JButton(CANCEL_BUTTON_TEXT);
        this.cancelButton.setMnemonic(67);
        this.backButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizardPane.this.backClicked();
            }
        });
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizardPane.this.nextClicked();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizardPane.this.cancelClicked();
            }
        });
        this.pnlButtons = new JPanel();
        this.pnlButtons.setLayout(new GridBagLayout());
        this.pnlButtons.add(this.backButton);
        this.pnlButtons.add(this.nextButton);
        this.pnlButtons.add(this.cancelButton);
        ((GridBagLayout)this.pnlButtons.getLayout()).setConstraints(this.backButton, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.1, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
        ((GridBagLayout)this.pnlButtons.getLayout()).setConstraints(this.nextButton, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.1, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        ((GridBagLayout)this.pnlButtons.getLayout()).setConstraints(this.cancelButton, new GridBagConstraints(2, 0, 1, 1, 0.1, 0.1, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.pnlButtons.setBorder(new EmptyBorder(new Insets(20, 10, 20, 10)));
    }

    private void createExplanationPanel() {
        this.pnlExplanation = new JPanel(new BorderLayout());
        this.lblExplanation = new LabelWidget("");
        this.pnlExplanation.add(this.lblExplanation);
        this.pnlExplanationOuter = new JPanel(new BorderLayout());
        this.pnlExplanationOuter.setBorder(new EtchedBorder(1));
        this.pnlExplanation.setBorder(new EmptyBorder(new Insets(10, 10, 10, 10)));
        this.pnlExplanationOuter.add(this.pnlExplanation);
    }

    private void createContentPanel() {
        this.pnlContent = new JPanel(new BorderLayout());
        this.pnlContentOuter = new JPanel(new BorderLayout());
        this.pnlContentOuter.setBorder(new EtchedBorder(1));
        this.pnlContent.setBorder(new EmptyBorder(new Insets(10, 10, 10, 10)));
        this.pnlContentOuter.add(this.pnlContent);
    }

    private WizardClientPanel getPanel(int iIndex) {
        int iTest = iIndex;
        int iPanelCount = this.getWizardClient().getPanels().size();
        if (++iTest > -1 && iTest <= iPanelCount) {
            return (WizardClientPanel)this.getWizardClient().getPanels().get(iIndex);
        }
        return null;
    }

    private void setBackButtonState(boolean bEnabled) {
        this.backButton.setEnabled(bEnabled);
    }

    private void setNextButtonState(boolean bEnabled) {
        this.nextButton.setEnabled(bEnabled);
    }

    private void processChange(int iCurrPanel, int iNextPanel) {
        if (iCurrPanel == -1) {
            this.getWizardClient().panelsChanging(iCurrPanel, iNextPanel);
            this.wcpCurrentPanel = this.getPanel(iNextPanel);
            this.addNewPanel(this.wcpCurrentPanel);
            this.iCurrentPanelNumber = iNextPanel;
        } else if (iNextPanel == this.getPanelArraySize() - 1) {
            this.getWizardClient().panelsChanging(iCurrPanel, iNextPanel);
            this.nextButton.setText(FINISH_BUTTON_TEXT);
            this.removeCurrentPanel();
            this.wcpCurrentPanel = this.getPanel(iNextPanel);
            this.addNewPanel(this.wcpCurrentPanel);
            this.iCurrentPanelNumber = iNextPanel;
            this.invalidate();
            this.repaint();
        } else if (iCurrPanel == this.getPanelArraySize() - 1 && iNextPanel < iCurrPanel) {
            this.getWizardClient().panelsChanging(iCurrPanel, iNextPanel);
            this.nextButton.setText(NEXT_BUTTON_TEXT);
            this.removeCurrentPanel();
            this.wcpCurrentPanel = this.getPanel(iNextPanel);
            this.addNewPanel(this.wcpCurrentPanel);
            this.iCurrentPanelNumber = iNextPanel;
            this.invalidate();
            this.repaint();
        } else {
            this.getWizardClient().panelsChanging(iCurrPanel, iNextPanel);
            this.nextButton.setText(NEXT_BUTTON_TEXT);
            this.removeCurrentPanel();
            this.wcpCurrentPanel = this.getPanel(iNextPanel);
            this.addNewPanel(this.wcpCurrentPanel);
            this.invalidate();
            this.repaint();
            this.iCurrentPanelNumber = iNextPanel;
        }
        this.setButtonStates(this.iCurrentPanelNumber);
        this.packMyOwner();
    }

    public void packMyOwner() {
        if (this.wnOwnerWindow != null) {
            this.wnOwnerWindow.pack();
        }
    }

    public void disposeOfMyOwner() {
        if (this.wnOwnerWindow != null) {
            this.wnOwnerWindow.dispose();
        }
    }

    public void setButtonStates(int iCurrPanel) {
        if (iCurrPanel == 0) {
            this.setBackButtonState(false);
            this.setNextButtonState(this.wcpCurrentPanel.isNextButtonEnablable());
        } else if (iCurrPanel == this.getPanelArraySize() - 1) {
            this.setBackButtonState(true);
            this.setNextButtonState(true);
        } else {
            this.setBackButtonState(true);
            this.setNextButtonState(this.wcpCurrentPanel.isNextButtonEnablable());
        }
    }

    public boolean getShowFlag() {
        return this.showFlag;
    }

    private void backClicked() {
        this.processChange(this.iCurrentPanelNumber, Math.max(this.iCurrentPanelNumber - 1, 0));
    }

    private void nextClicked() {
        if (this.nextButton.getText().equals(FINISH_BUTTON_TEXT)) {
            this.wzcClient.finishClicked();
            this.disposeOfMyOwner();
        } else {
            this.processChange(this.iCurrentPanelNumber, this.iCurrentPanelNumber + 1);
        }
    }

    private void cancelClicked() {
        this.wzcClient.cancelClicked();
        this.disposeOfMyOwner();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() instanceof WizardClientPanel) {
            this.setNextButtonState(((WizardClientPanel)e.getSource()).isNextButtonEnablable());
        } else if (e.getSource() instanceof AbstractWizardClient) {
            this.setNextButtonState(((WizardClientPanel)e.getSource()).isNextButtonEnablable());
        }
    }
}

