/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.util.wizard;

import com.metamatrix.console.ui.util.wizard.AbstractWizardClient;
import com.metamatrix.console.ui.util.wizard.WizardClientPanel;
import com.metamatrix.console.ui.util.wizard.WizardPane;
import com.metamatrix.console.util.StaticUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class WizardPaneDialog
extends JDialog {
    private WizardPane wpPane = null;
    private AbstractWizardClient wzcClient = null;

    public WizardPaneDialog(JFrame frFrame, AbstractWizardClient wzcClient) {
        super(frFrame, wzcClient.getTitle(), true);
        this.wzcClient = wzcClient;
        this.init();
        this.getWizardPane().setVisible(true);
        this.getWizardPane().postRealize();
    }

    public void init() {
        this.getContentPane().setLayout(new BorderLayout());
        this.wpPane = new WizardPane(this, this.wzcClient);
        this.getContentPane().add((Component)this.wpPane, "Center");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                WizardPaneDialog.this.getWizardPane().getCancelButton().doClick();
            }
        });
        this.pack();
        this.setLocation(StaticUtilities.centerFrame(this.getSize()));
    }

    public WizardPane getWizardPane() {
        return this.wpPane;
    }

    private List getPanelForClient() {
        return this.wzcClient.getPanels();
    }

    private Dimension calcPanelPreferrecdSize() {
        Dimension dimCompSize = null;
        WizardClientPanel wcp2 = null;
        int maxHeight = 0;
        int maxWidth = 0;
        List panelList = this.getPanelForClient();
        for (WizardClientPanel wcp2 : panelList) {
            dimCompSize = wcp2.getComponent().getPreferredSize();
            int iNewHeight = (int)Math.max((double)maxHeight, dimCompSize.getHeight());
            int iNewWidth = (int)Math.max((double)maxWidth, dimCompSize.getWidth());
            maxHeight = iNewHeight;
            maxWidth = iNewWidth;
        }
        return new Dimension(maxWidth + 200, maxHeight + 100);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.calcPanelPreferrecdSize();
    }
}

