/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.authorization;

import com.metamatrix.common.config.api.ComponentDefn;
import com.metamatrix.console.ui.layout.BasePanel;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.TextFieldWidget;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.SimpleDateFormat;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class AuthenticationProviderDetailsPanel
extends BasePanel {
    private TextFieldWidget createdField;
    private TextFieldWidget createdByField;
    private TextFieldWidget modifiedField;
    private TextFieldWidget modifiedByField;
    private JTextArea descriptionField;
    private ComponentDefn providerDefn;

    public AuthenticationProviderDetailsPanel() {
        this.init();
    }

    private void init() {
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        this.createdField = new TextFieldWidget();
        this.createdField.setEditable(false);
        this.createdByField = new TextFieldWidget();
        this.createdByField.setEditable(false);
        this.modifiedField = new TextFieldWidget();
        this.modifiedField.setEditable(false);
        this.modifiedByField = new TextFieldWidget();
        this.modifiedByField.setEditable(false);
        this.descriptionField = new JTextArea();
        this.descriptionField.setEditable(false);
        this.descriptionField.setWrapStyleWord(true);
        LabelWidget createdLabel = new LabelWidget("Created:");
        LabelWidget createdByLabel = new LabelWidget("By:");
        LabelWidget modifiedLabel = new LabelWidget("Modified:");
        LabelWidget modifiedByLabel = new LabelWidget("By:");
        LabelWidget descriptionLabel = new LabelWidget("Description:");
        this.add(this.createdField);
        this.add(this.createdByField);
        this.add(this.modifiedField);
        this.add(this.modifiedByField);
        this.add(createdLabel);
        this.add(createdByLabel);
        this.add(modifiedLabel);
        this.add(modifiedByLabel);
        JPanel descPanel = new JPanel();
        GridBagLayout dl = new GridBagLayout();
        descPanel.setLayout(dl);
        JScrollPane descFieldSP = new JScrollPane(this.descriptionField);
        descPanel.add(descriptionLabel);
        descPanel.add(descFieldSP);
        layout.setConstraints(createdLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        layout.setConstraints(this.createdField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 10), 0, 0));
        layout.setConstraints(createdByLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 10, 5, 5), 0, 0));
        layout.setConstraints(this.createdByField, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        layout.setConstraints(modifiedLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        layout.setConstraints(this.modifiedField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 10), 0, 0));
        layout.setConstraints(modifiedByLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 10, 5, 5), 0, 0));
        layout.setConstraints(this.modifiedByField, new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        layout.setConstraints(descPanel, new GridBagConstraints(0, 2, 4, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void populate() {
        SimpleDateFormat formatter = StaticUtilities.getDefaultDateFormat();
        if (this.providerDefn == null) {
            this.createdField.setText("");
            this.createdByField.setText("");
            this.modifiedField.setText("");
            this.modifiedByField.setText("");
            this.descriptionField.setText("");
        } else {
            this.createdField.setText(formatter.format(this.providerDefn.getCreatedDate()));
            this.createdByField.setText(this.providerDefn.getCreatedBy());
            this.modifiedField.setText(formatter.format(this.providerDefn.getLastChangedDate()));
            this.modifiedByField.setText(this.providerDefn.getLastChangedBy());
            this.descriptionField.setText(this.providerDefn.getDescription());
        }
    }

    public void setProvider(ComponentDefn defn) {
        this.providerDefn = defn;
        this.populate();
    }

    public ComponentDefn getProvider() {
        return this.providerDefn;
    }
}

