/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.authorization;

import com.metamatrix.common.actions.ModificationActionQueue;
import com.metamatrix.common.config.api.AuthenticationProvider;
import com.metamatrix.common.config.api.ComponentDefn;
import com.metamatrix.common.config.api.ComponentDefnID;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationObjectEditor;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.object.PropertiedObject;
import com.metamatrix.common.object.PropertiedObjectEditor;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.AuthenticationProviderManager;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.ui.layout.ConsoleMainFrame;
import com.metamatrix.console.ui.util.ExpertPropertiedObjectPanelHolder;
import com.metamatrix.console.ui.util.POPWithButtons;
import com.metamatrix.console.ui.util.POPWithButtonsController;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.toolbox.ui.widget.property.PropertiedObjectPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JPanel;

public class AuthenticationProviderPropertiesPanel
extends JPanel
implements POPWithButtonsController {
    private PropertiedObjectPanel pop;
    private ExpertPropertiedObjectPanelHolder popHolder;
    private POPWithButtons popWithButtons = null;
    private JPanel pnlOuter = new JPanel();
    private JPanel pnlPOPShell = new JPanel(new GridLayout(1, 1));
    private PropertiedObject poPropObject;
    private PropertiedObjectEditor poe;
    private ComponentDefn providerDefn;
    private boolean canModify;
    private ConnectionInfo connection;
    private ModificationActionQueue maq = null;
    private ConfigurationObjectEditor coe = null;

    public AuthenticationProviderPropertiesPanel(boolean modifiable, ConnectionInfo connection) {
        this.canModify = modifiable;
        this.connection = connection;
        this.init();
        try {
            this.coe = this.getAuthenticationProviderManager().getAuthenticationProviderEditor();
            this.maq = this.coe.getDestination();
            this.poe = this.getAuthenticationProviderManager().getPropertiedObjectEditor(this.maq);
        }
        catch (Exception ex) {
            LogManager.logError((String)"CONFIGURATION", (Throwable)ex, (String)"Error creating Membership Domain Provider Properties Panel.");
            ExceptionUtility.showMessage("Error creating Membership Domain Provider Properties Panel", ex);
        }
    }

    private AuthenticationProviderManager getAuthenticationProviderManager() {
        return ModelManager.getAuthenticationProviderManager(this.connection);
    }

    private void init() {
        this.pnlPOPShell.setPreferredSize(new Dimension(200, 300));
        this.setLayout(new BorderLayout());
        this.pnlOuter.setLayout(new GridBagLayout());
        this.add((Component)this.pnlPOPShell, "Center");
    }

    private PropertiedObjectEditor getPropertiedObjectEditor() {
        if (this.poe == null) {
            try {
                this.poe = this.getAuthenticationProviderManager().getPropertiedObjectEditor();
            }
            catch (Exception e) {
                ExceptionUtility.showMessage("Failed to get editor for Membership Domain Provider property panel  ", e);
            }
        }
        return this.poe;
    }

    private PropertiedObjectPanel getPropertiedObjectPanel() {
        if (this.pop == null) {
            try {
                StaticUtilities.startWait(ConsoleMainFrame.getInstance());
                this.poe = this.getPropertiedObjectEditor();
                this.pop = new PropertiedObjectPanel(this.poe, this.getAuthenticationProviderManager().getEncryptor());
            }
            catch (RuntimeException ex) {
                StaticUtilities.endWait(ConsoleMainFrame.getInstance());
                throw ex;
            }
            StaticUtilities.endWait(ConsoleMainFrame.getInstance());
        }
        return this.pop;
    }

    private void populateTable() {
        try {
            StaticUtilities.startWait(ConsoleMainFrame.getInstance());
            if (this.providerDefn == null) {
                this.pnlPOPShell.removeAll();
            } else {
                this.updatePropertiedObjectPanel();
            }
        }
        catch (RuntimeException ex) {
            StaticUtilities.endWait(ConsoleMainFrame.getInstance());
            ExceptionUtility.showMessage("Failed in populateTable", ex);
        }
        StaticUtilities.endWait(ConsoleMainFrame.getInstance());
    }

    public void setProvider(ComponentDefn defn) {
        this.providerDefn = defn;
        this.populateTable();
    }

    public ComponentDefn getProvider() {
        return this.providerDefn;
    }

    public void updatePropertiedObjectPanel() {
        ComponentDefn providerDefn = this.getProvider();
        try {
            this.poPropObject = this.getAuthenticationProviderManager().getPropertiedObject(providerDefn);
            this.getPropertiedObjectPanel().setNameColumnHeaderWidth(0);
            this.getPropertiedObjectPanel().setPropertiedObject(this.poPropObject, this.poe);
            this.poe.setReadOnly(this.poPropObject, false);
            this.getPropertiedObjectPanel().setShowRequiredProperties(true);
            this.getPropertiedObjectPanel().setShowInvalidProperties(true);
            this.getPropertiedObjectPanel().setShowHiddenProperties(false);
            this.getPropertiedObjectPanel().setShowExpertProperties(false);
            this.getPropertiedObjectPanel().setShowOptionalProperties(true);
            if (!this.canModify) {
                this.getPropertiedObjectPanel().setReadOnlyForced(true);
            }
            this.getPropertiedObjectPanel().createComponent();
            this.getPropertiedObjectPanel().refreshDisplay();
            boolean includeExpert = false;
            if (this.popHolder != null) {
                includeExpert = this.popHolder.isIncludingExpertProperties();
            }
            this.pnlPOPShell.removeAll();
            ItemListener includeExpertListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent ev) {
                    AuthenticationProviderPropertiesPanel.this.includeExpertStateChanged();
                }
            };
            ItemListener includeOptionalListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent ev) {
                    AuthenticationProviderPropertiesPanel.this.includeOptionalStateChanged();
                }
            };
            this.popHolder = new ExpertPropertiedObjectPanelHolder(this.pop, includeExpertListener, includeOptionalListener);
            this.popWithButtons = new POPWithButtons(this.popHolder, this.poe, (POPWithButtonsController)this);
            this.pnlPOPShell.add(this.popWithButtons);
            this.popHolder.setIsIncludingExpertProperties(includeExpert);
        }
        catch (Exception e) {
            ExceptionUtility.showMessage("Failed while creating Membership Domain Provider Panel", e);
        }
    }

    private void includeExpertStateChanged() {
        this.getPropertiedObjectPanel().setShowExpertProperties(this.popHolder.isIncludingExpertProperties());
        this.getPropertiedObjectPanel().refreshDisplay();
    }

    private void includeOptionalStateChanged() {
        this.getPropertiedObjectPanel().setShowOptionalProperties(this.popHolder.isIncludingOptionalProperties());
        this.getPropertiedObjectPanel().refreshDisplay();
    }

    public ComponentDefn getNewProvider() {
        return this.providerDefn;
    }

    @Override
    public boolean doApplyChanges(PropertiedObjectPanel pop) {
        boolean proceeding = true;
        try {
            StaticUtilities.displayModalDialogWithOK("Modify Membership Domain Provider", "Note: Change will not take effect until provider is restarted in the System State panel.");
            this.getAuthenticationProviderManager().saveProvider(this.maq);
            AuthenticationProvider provider = (AuthenticationProvider)this.getAuthenticationProviderManager().getConfigurationAdminAPI().getComponentDefn(Configuration.NEXT_STARTUP_ID, (ComponentDefnID)this.providerDefn.getID());
            this.setProvider((ComponentDefn)provider);
        }
        catch (Exception ex) {
            LogManager.logError((String)"CONFIGURATION", (Throwable)ex, (String)"Error saving connector binding changes.");
            ExceptionUtility.showMessage("Error saving Membership Domain provider changes", ex);
        }
        return proceeding;
    }

    public void applyProperties() {
        if (this.popWithButtons != null) {
            this.popWithButtons.applyPressed();
        }
    }

    public void resetProperties() {
        if (this.popWithButtons != null) {
            this.popWithButtons.resetPressed();
        }
    }

    public boolean anyValueChanged() {
        if (this.popWithButtons == null) {
            return false;
        }
        return this.popWithButtons.anyValueChanged();
    }
}

