/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.authorization;

import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.AuthenticationProviderManager;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.ui.util.BasicWizardSubpanelContainer;
import com.metamatrix.console.ui.util.WizardInterface;
import com.metamatrix.console.ui.util.property.GuiComponentFactory;
import com.metamatrix.console.ui.util.property.TypeConstants;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.TextFieldWidget;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class NewAuthenticationProviderSelectPanel
extends BasicWizardSubpanelContainer
implements TypeConstants {
    private LabelWidget lblProviderTypeName = new LabelWidget("*Provider Type:");
    private TextFieldWidget txfProviderName = GuiComponentFactory.createTextField("connectorbindingname");
    private LabelWidget lblProviderName = new LabelWidget("*Provider Name:");
    private JPanel pnlOuter = new JPanel();
    private HashMap hmNameProviderXref = null;
    private List arylProviders = null;
    private JComboBox cbxProviderSelection;
    private DefaultComboBoxModel cbxmdlProviderSelectionModel;
    private boolean hasBeenPainted = false;
    private ConnectionInfo connection = null;

    public NewAuthenticationProviderSelectPanel(WizardInterface wizardInterface, ConnectionInfo connection) {
        super(wizardInterface);
        this.connection = connection;
        this.init();
    }

    private AuthenticationProviderManager getAuthenticationProviderManager() {
        return ModelManager.getAuthenticationProviderManager(this.connection);
    }

    private void init() {
        this.setBoldFont(this.lblProviderTypeName);
        this.setBoldFont(this.lblProviderName);
        LabelWidget requiredFieldLabel = new LabelWidget("*Required field");
        this.setBoldFont(requiredFieldLabel);
        GridBagLayout layout = new GridBagLayout();
        this.pnlOuter.setLayout(layout);
        this.pnlOuter.add(this.lblProviderName);
        this.pnlOuter.add(this.txfProviderName);
        this.pnlOuter.add(this.lblProviderTypeName);
        JComboBox providerComboBox = this.getComboBox();
        this.pnlOuter.add(providerComboBox);
        this.pnlOuter.add(requiredFieldLabel);
        layout.setConstraints(this.lblProviderName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        layout.setConstraints(this.txfProviderName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        layout.setConstraints(this.lblProviderTypeName, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        layout.setConstraints(providerComboBox, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        layout.setConstraints(requiredFieldLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 12, 0, new Insets(15, 5, 5, 5), 0, 0));
        this.setMainContent(this.pnlOuter);
        this.setStepText(1, "Specify a Name and Select a Type for this Membership Domain Provider.");
        this.txfProviderName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent ev) {
            }

            @Override
            public void insertUpdate(DocumentEvent ev) {
                try {
                    String text = ev.getDocument().getText(0, ev.getDocument().getLength());
                    text = text.trim();
                    AbstractButton forwardButton = NewAuthenticationProviderSelectPanel.this.getWizardInterface().getForwardButton();
                    forwardButton.setEnabled(text.length() > 0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public void removeUpdate(DocumentEvent ev) {
                try {
                    String text = ev.getDocument().getText(0, ev.getDocument().getLength());
                    text = text.trim();
                    AbstractButton forwardButton = NewAuthenticationProviderSelectPanel.this.getWizardInterface().getForwardButton();
                    forwardButton.setEnabled(text.length() > 0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    private JComboBox getComboBox() {
        if (this.cbxProviderSelection == null) {
            this.cbxProviderSelection = new JComboBox();
            this.cbxmdlProviderSelectionModel = new DefaultComboBoxModel();
            this.cbxProviderSelection.setModel(this.cbxmdlProviderSelectionModel);
            this.hmNameProviderXref = null;
            this.arylProviders = this.getAuthenticationProviderManager().getAllProviderTypes();
            for (ComponentType ctProvider : this.arylProviders) {
                this.getProviderXref().put(ctProvider.getName(), ctProvider);
                this.cbxmdlProviderSelectionModel.addElement(ctProvider.getName());
            }
        }
        return this.cbxProviderSelection;
    }

    public String getNewProviderName() {
        return this.txfProviderName.getText();
    }

    public ComponentType getSelectedAuthenticationProvider() {
        DefaultComboBoxModel mdl = (DefaultComboBoxModel)this.cbxProviderSelection.getModel();
        String sSelectedProvider = (String)mdl.getSelectedItem();
        ComponentType ctProvider = (ComponentType)this.getProviderXref().get(sSelectedProvider);
        return ctProvider;
    }

    private HashMap getProviderXref() {
        if (this.hmNameProviderXref == null) {
            this.hmNameProviderXref = new HashMap();
        }
        return this.hmNameProviderXref;
    }

    private void setBoldFont(LabelWidget label) {
        Font tempFont = label.getFont();
        Font newFont = new Font(tempFont.getName(), 1, tempFont.getSize());
        label.setFont(newFont);
    }

    @Override
    public void paint(Graphics g) {
        if (!this.hasBeenPainted) {
            AbstractButton forwardButton = this.getWizardInterface().getForwardButton();
            forwardButton.setEnabled(false);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NewAuthenticationProviderSelectPanel.this.txfProviderName.requestFocus();
                }
            });
            this.hasBeenPainted = true;
        }
        super.paint(g);
    }
}

