/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.authorization;

import com.metamatrix.common.actions.ModificationActionQueue;
import com.metamatrix.common.config.api.AuthenticationProvider;
import com.metamatrix.common.config.api.ComponentDefn;
import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.ConfigurationObjectEditor;
import com.metamatrix.common.object.PropertiedObject;
import com.metamatrix.common.object.PropertiedObjectEditor;
import com.metamatrix.common.object.PropertyDefinition;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.AuthenticationProviderManager;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.ui.layout.ConsoleMainFrame;
import com.metamatrix.console.ui.util.BasicWizardSubpanelContainer;
import com.metamatrix.console.ui.util.ExpertPropertiedObjectPanelHolder;
import com.metamatrix.console.ui.util.InitialAndCurrentValues;
import com.metamatrix.console.ui.util.WizardInterface;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.TextFieldWidget;
import com.metamatrix.toolbox.ui.widget.property.PropertiedObjectPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JPanel;

public class NewAuthenticationProviderSpecificationPanel
extends BasicWizardSubpanelContainer
implements PropertyChangeListener,
ComponentListener {
    private PropertiedObjectPanel popThePanel;
    private ComponentType ctProviderType = null;
    private String sProviderName = "Unknown";
    private TextFieldWidget txfProviderTypeName = new TextFieldWidget();
    private LabelWidget lblProviderTypeName = new LabelWidget();
    private TextFieldWidget txfProviderName = new TextFieldWidget();
    private LabelWidget lblProviderName = new LabelWidget();
    private JPanel pnlOuter = new JPanel();
    private JPanel pnlPOPShell = new JPanel(new GridLayout(1, 1));
    private ConfigurationObjectEditor coeEditor;
    private ModificationActionQueue maqActionQForProvider;
    private AuthenticationProvider scdNewAuthenticationProvider;
    private PropertiedObject poPropObject;
    private PropertiedObjectEditor poeEditor;
    private ExpertPropertiedObjectPanelHolder popHolder;
    private Map valuesMap = new HashMap();
    private Map defsMap = new HashMap();
    private ConnectionInfo connection = null;

    public NewAuthenticationProviderSpecificationPanel(WizardInterface wizardInterface, ConnectionInfo connection) {
        super(wizardInterface);
        this.connection = connection;
        this.init();
    }

    private AuthenticationProviderManager getAuthenticationProviderManager() {
        return ModelManager.getAuthenticationProviderManager(this.connection);
    }

    private void init() {
        this.pnlPOPShell.setPreferredSize(new Dimension(200, 300));
        this.pnlOuter.setLayout(new GridBagLayout());
        this.lblProviderName.setText("Provider Name:");
        this.lblProviderTypeName.setText("Provider Type:");
        this.txfProviderName.setEditable(false);
        this.txfProviderTypeName.setEditable(false);
        this.pnlOuter.add((Component)this.lblProviderName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 5, 0), 5, 4));
        this.pnlOuter.add((Component)this.txfProviderName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 1), 1, 0));
        this.pnlOuter.add((Component)this.lblProviderTypeName, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 5, 0), 5, 4));
        this.pnlOuter.add((Component)this.txfProviderTypeName, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 1), 1, 0));
        this.pnlOuter.add((Component)this.pnlPOPShell, new GridBagConstraints(0, 2, 2, 3, 1.0, 1.0, 10, 1, new Insets(8, 0, 0, 1), 1, 0));
        this.setMainContent(this.pnlOuter);
        this.setStepText(2, "Specify Details for this Membership Domain Provider.");
        this.setupListening();
    }

    public ConfigurationObjectEditor getConfigurationObjectEditor() {
        return this.coeEditor;
    }

    private void updateTextFields() {
        this.txfProviderTypeName.setText(this.ctProviderType.getName());
        this.txfProviderName.setText(this.sProviderName);
    }

    public void updatePropertiedObjectPanel(ComponentType cType, String sProviderName, boolean initProvider) {
        boolean showingWaitCursor;
        this.ctProviderType = cType;
        this.sProviderName = sProviderName;
        this.updateTextFields();
        try {
            showingWaitCursor = true;
            StaticUtilities.startWait(ConsoleMainFrame.getInstance());
            this.coeEditor = this.getAuthenticationProviderManager().getAuthenticationProviderEditor();
            this.scdNewAuthenticationProvider = initProvider ? this.getAuthenticationProviderManager().getTentativeAuthenticationProvider(this.ctProviderType, this.coeEditor, sProviderName) : this.getAuthenticationProviderManager().copyAuthenticationProvider(this.scdNewAuthenticationProvider, this.coeEditor, sProviderName);
            this.maqActionQForProvider = this.coeEditor.getDestination();
            this.poPropObject = this.getAuthenticationProviderManager().getPropertiedObject((ComponentDefn)this.scdNewAuthenticationProvider);
            this.poeEditor = this.getAuthenticationProviderManager().getPropertiedObjectEditor(this.maqActionQForProvider);
            this.popThePanel = new PropertiedObjectPanel(this.poeEditor, this.getAuthenticationProviderManager().getEncryptor());
            this.poeEditor.setReadOnly(this.poPropObject, false);
            this.popThePanel.setNameColumnHeaderWidth(0);
            this.popThePanel.setPropertiedObject(this.poPropObject);
            this.popThePanel.setShowRequiredProperties(true);
            this.popThePanel.setShowInvalidProperties(true);
            this.popThePanel.setShowHiddenProperties(false);
            this.popThePanel.setShowExpertProperties(false);
            this.popThePanel.setShowOptionalProperties(true);
            this.popThePanel.refreshDisplay();
            this.popThePanel.createComponent();
            this.pnlPOPShell.removeAll();
            ItemListener includeExpertListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent ev) {
                    NewAuthenticationProviderSpecificationPanel.this.includeExpertStateChanged();
                }
            };
            ItemListener includeOptionalListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent ev) {
                    NewAuthenticationProviderSpecificationPanel.this.includeOptionalStateChanged();
                }
            };
            this.popHolder = new ExpertPropertiedObjectPanelHolder(this.popThePanel, includeExpertListener, includeOptionalListener);
            this.popHolder.setIsIncludingExpertProperties(false);
            this.popHolder.setIsIncludingOptionalProperties(true);
            this.pnlPOPShell.add(this.popHolder);
            this.setInitialValues();
            this.popThePanel.addPropertyChangeListener(this);
            this.setButtons();
        }
        catch (Exception e) {
            StaticUtilities.endWait(ConsoleMainFrame.getInstance());
            showingWaitCursor = false;
            ExceptionUtility.showMessage("Failed while creating Membership Domain Provider Panel", e);
        }
        if (showingWaitCursor) {
            StaticUtilities.endWait(ConsoleMainFrame.getInstance());
        }
    }

    private void includeExpertStateChanged() {
        this.popThePanel.setShowExpertProperties(this.popHolder.isIncludingExpertProperties());
        this.popThePanel.refreshDisplay();
    }

    private void includeOptionalStateChanged() {
        this.popThePanel.setShowOptionalProperties(this.popHolder.isIncludingOptionalProperties());
        this.popThePanel.refreshDisplay();
    }

    public AuthenticationProvider getNewAuthenticationProvider() {
        return this.scdNewAuthenticationProvider;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.setButtons();
    }

    public String getProviderName() {
        return this.txfProviderName.getText().trim();
    }

    public void setButtons() {
        AbstractButton forwardButton = this.getWizardInterface().getForwardButton();
        forwardButton.setEnabled(!this.anyValueInvalid());
        this.repaint();
    }

    private boolean anyValueInvalid() {
        int iInvalidCount = this.popThePanel.getInvalidDefinitions().size();
        boolean anyInvalid = iInvalidCount > 0;
        return anyInvalid;
    }

    private void setInitialValues() {
        PropertiedObject propObj = this.popThePanel.getPropertiedObject();
        List defs = this.poeEditor.getPropertyDefinitions(propObj);
        for (PropertyDefinition def : defs) {
            this.defsMap.put(def.getName(), def);
            Object value = this.poeEditor.getValue(propObj, def);
            InitialAndCurrentValues vals = new InitialAndCurrentValues(value, value);
            this.valuesMap.put(def, vals);
        }
    }

    public void setupListening() {
        this.addComponentListener(this);
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.setInitialPostRealizeState();
        this.removeComponentListener(this);
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    public void setInitialPostRealizeState() {
        this.setButtons();
    }
}

