/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.authorization;

import com.metamatrix.common.config.api.AuthenticationProvider;
import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.ConfigurationObjectEditor;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.AuthenticationProviderManager;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.ui.layout.ConsoleMainFrame;
import com.metamatrix.console.ui.util.WizardInterfaceImpl;
import com.metamatrix.console.ui.views.authorization.NewAuthenticationProviderSelectPanel;
import com.metamatrix.console.ui.views.authorization.NewAuthenticationProviderSpecificationPanel;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;

public class NewAuthenticationProviderWizardController
extends WizardInterfaceImpl {
    private static final int PROVIDER_SELECT_PAGE_NUM = 0;
    private NewAuthenticationProviderSelectPanel providerSelectPanel;
    private ComponentType currentlySelectedProvider = null;
    private String sNewCBName = null;
    private NewAuthenticationProviderSpecificationPanel specsPanel;
    private JDialog dialog;
    private int currentPage = -1;
    private ButtonWidget nextButton;
    private ButtonWidget cancelButton;
    private ButtonWidget finishButton;
    private AuthenticationProvider scdNewAuthenticationProvider = null;
    private ConnectionInfo connection;

    public NewAuthenticationProviderWizardController(ConnectionInfo connection) {
        this.connection = connection;
    }

    private AuthenticationProviderManager getAuthenticationProviderManager() {
        return ModelManager.getAuthenticationProviderManager(this.connection);
    }

    public AuthenticationProvider runWizard() {
        this.providerSelectPanel = new NewAuthenticationProviderSelectPanel(this, this.connection);
        this.specsPanel = new NewAuthenticationProviderSpecificationPanel(this, this.connection);
        if (this.providerSelectPanel != null && this.specsPanel != null) {
            this.addPage(this.providerSelectPanel);
            this.addPage(this.specsPanel);
            this.dialog = new JDialog((Frame)ConsoleMainFrame.getInstance(), "Create New Membership Domain Provider Wizard");
            this.dialog.setModal(true);
            this.cancelButton = this.getCancelButton();
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    NewAuthenticationProviderWizardController.this.cancelPressed();
                }
            });
            this.getBackButton();
            this.finishButton = this.getFinishButton();
            this.finishButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    NewAuthenticationProviderWizardController.this.finishPressed();
                }
            });
            this.nextButton = this.getNextButton();
            this.dialog.getContentPane().add(this);
            this.dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent ev) {
                    NewAuthenticationProviderWizardController.this.cancelPressed();
                }
            });
            this.dialog.pack();
            this.currentPage = 0;
            NewAuthenticationProviderWizardController.setLocationOn(this.dialog);
            this.dialog.show();
        }
        return this.scdNewAuthenticationProvider;
    }

    private void cancelPressed() {
        this.dialog.dispose();
    }

    public void importFileSelected() {
        this.nextButton.setEnabled(true);
    }

    private void finishPressed() {
        this.createAuthenticationProvider();
        this.dialog.dispose();
    }

    public JDialog getDialog() {
        return this.dialog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void showNextPage() {
        boolean bContinue = false;
        try {
            StaticUtilities.startWait(this.getDialog().getContentPane());
            bContinue = this.goingToNextPage();
        }
        catch (Exception e) {
            ExceptionUtility.showMessage("Failed testing new provider name for uniqueness", e);
        }
        finally {
            StaticUtilities.endWait(this.getDialog().getContentPane());
        }
        if (bContinue) {
            ++this.currentPage;
            super.showNextPage();
        }
    }

    @Override
    public void showPreviousPage() {
        this.goingToPreviousPage();
        --this.currentPage;
        super.showPreviousPage();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension unadjusted = super.getPreferredSize();
        return new Dimension(Math.max(unadjusted.width, (int)((double)screenSize.width * 0.7)), unadjusted.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean goingToNextPage() {
        bContinue = true;
        switch (this.currentPage) {
            case 0: {
                bNameIsUnique = false;
                bNameIsUnique = this.nameIsUnique();
                if (!bNameIsUnique) ** GOTO lbl20
                connector = this.providerSelectPanel.getSelectedAuthenticationProvider();
                typeChanged = connector.equals(this.currentlySelectedProvider) == false;
                v0 = nameChanged = this.sNewCBName == null || this.sNewCBName.equals(this.providerSelectPanel.getNewProviderName()) == false;
                if (!typeChanged && !nameChanged) ** GOTO lbl20
                try {
                    StaticUtilities.startWait(this.dialog.getContentPane());
                    this.specsPanel.updatePropertiedObjectPanel(this.providerSelectPanel.getSelectedAuthenticationProvider(), this.providerSelectPanel.getNewProviderName(), typeChanged);
                }
                finally {
                    StaticUtilities.endWait(this.dialog.getContentPane());
                }
                this.currentlySelectedProvider = connector;
                this.sNewCBName = this.providerSelectPanel.getNewProviderName();
lbl20:
                // 3 sources

                if (!(bContinue = bNameIsUnique)) break;
                this.enableNextButton(true);
                this.specsPanel.setButtons();
            }
        }
        return bContinue;
    }

    public void goingToPreviousPage() {
        this.enableNextButton(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean nameIsUnique() {
        String sName = this.providerSelectPanel.getNewProviderName();
        boolean bNameNotUnique = false;
        try {
            StaticUtilities.startWait(this.dialog.getContentPane());
            bNameNotUnique = this.getAuthenticationProviderManager().providerTypeNameAlreadyExists(sName);
        }
        catch (Exception e) {
            ExceptionUtility.showMessage("Failed testing new provider name for uniqueness", e);
        }
        finally {
            StaticUtilities.endWait(this.dialog.getContentPane());
        }
        if (bNameNotUnique) {
            StaticUtilities.displayModalDialogWithOK("Domain Provider Already Exists", "A Provider already exists with the name \"" + sName + "\".  Please enter a unique name.");
        }
        return !bNameNotUnique;
    }

    public static void setLocationOn(Component comp) {
        Point p = StaticUtilities.centerFrame(comp.getSize());
        comp.setLocation(p.x, p.y);
    }

    public void enableNextButton(boolean b) {
        ButtonWidget btnNext = null;
        btnNext = this.getNextButton();
        if (btnNext != null) {
            btnNext.setEnabled(b);
        } else {
            btnNext = this.getFinishButton();
            if (btnNext != null) {
                btnNext.setEnabled(b);
            }
        }
    }

    private void createAuthenticationProvider() {
        AuthenticationProvider provider = this.specsPanel.getNewAuthenticationProvider();
        ConfigurationObjectEditor coe = this.specsPanel.getConfigurationObjectEditor();
        try {
            this.getAuthenticationProviderManager().createAuthenticationProvider(provider, coe);
            this.scdNewAuthenticationProvider = provider;
        }
        catch (Exception ex) {
            String msg = "Error creating Membership Domain provider.";
            LogManager.logError((String)"CONNECTOR_BINDINGS", (Throwable)ex, (String)msg);
            ExceptionUtility.showMessage(msg, ex);
        }
    }
}

