/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.authorization;

import com.metamatrix.api.exception.ComponentNotFoundException;
import com.metamatrix.api.exception.security.AuthorizationException;
import com.metamatrix.common.config.api.AuthenticationProvider;
import com.metamatrix.common.config.api.ComponentDefn;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ServiceComponentDefn;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.AuthenticationProviderManager;
import com.metamatrix.console.models.ConfigurationManager;
import com.metamatrix.console.models.GroupsManager;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.notification.AddedConnectorBindingNotification;
import com.metamatrix.console.notification.RuntimeUpdateNotification;
import com.metamatrix.console.security.UserCapabilities;
import com.metamatrix.console.ui.ViewManager;
import com.metamatrix.console.ui.layout.BasePanel;
import com.metamatrix.console.ui.layout.ConsoleMainFrame;
import com.metamatrix.console.ui.layout.MenuEntry;
import com.metamatrix.console.ui.layout.WorkspacePanel;
import com.metamatrix.console.ui.util.AbstractPanelAction;
import com.metamatrix.console.ui.util.CenteredOptionPane;
import com.metamatrix.console.ui.views.authorization.AuthenticationProviderDetailsPanel;
import com.metamatrix.console.ui.views.authorization.AuthenticationProviderPropertiesPanel;
import com.metamatrix.console.ui.views.authorization.NewAuthenticationProviderWizardController;
import com.metamatrix.console.ui.views.authorization.ProviderPanelAction;
import com.metamatrix.console.ui.views.deploy.event.ConfigurationChangeEvent;
import com.metamatrix.console.ui.views.deploy.event.ConfigurationChangeListener;
import com.metamatrix.console.util.DialogUtility;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.ExternalException;
import com.metamatrix.console.util.Refreshable;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.toolbox.ui.UIDefaults;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.Splitter;
import com.metamatrix.toolbox.ui.widget.TableWidget;
import com.metamatrix.toolbox.ui.widget.TitledBorder;
import com.metamatrix.toolbox.ui.widget.table.DefaultTableCellRenderer;
import com.metamatrix.toolbox.ui.widget.table.DefaultTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

public class ProvidersMain
extends BasePanel
implements ConfigurationChangeListener,
WorkspacePanel,
Refreshable {
    public static final int DOMAIN_NAME_COL_NUM = 0;
    public static final int PROVIDER_TYPE_COL_NUM = 1;
    public static final int DETAILS_TAB_NUM = 0;
    public static final int PROPERTIES_TAB_NUM = 1;
    private static final String NEW_CONNECTOR_TITLE = "New...";
    private static final String DELETE_CONNECTOR_TITLE = "Delete";
    private ProviderPanelAction actionNewProvider;
    private ProviderPanelAction actionDeleteProvider;
    private ConnectionInfo connection;
    private TableWidget table;
    private DefaultTableModel tableModel;
    private ButtonWidget newButton;
    private ButtonWidget deleteButton;
    private ButtonWidget moveRowUpButton;
    private ButtonWidget moveRowDownButton;
    private AuthenticationProviderDetailsPanel detailsPanel;
    private AuthenticationProviderPropertiesPanel propertiesPanel;
    private List selectedProviders = new ArrayList();
    private ListSelectionListener listSelectionListener;
    private JTabbedPane tabbedPane;
    private JSplitPane splitPane;
    private List currentActions = new ArrayList();
    private HashMap nameProviderMap = null;
    private boolean canModify;

    public ProvidersMain(ConnectionInfo conn) {
        this.connection = conn;
        this.init();
    }

    private AuthenticationProviderManager getAuthenticationProviderManager() {
        return ModelManager.getAuthenticationProviderManager(this.connection);
    }

    private ConfigurationManager getConfigurationManager() {
        return ModelManager.getConfigurationManager(this.connection);
    }

    private GroupsManager getGroupsManager() {
        return ModelManager.getGroupsManager(this.connection);
    }

    private void init() {
        this.canModify = false;
        try {
            UserCapabilities cap = UserCapabilities.getInstance();
            this.canModify = cap.canModifySecurity(this.connection);
            if (this.canModify) {
                this.getConfigurationManager().addConfigurationChangeListener(this);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.createActions();
        JPanel tablePanel = this.createTablePanel();
        this.tabbedPane = this.createTabbedPane();
        this.splitPane = new Splitter(0, true, tablePanel, this.tabbedPane);
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        this.add(this.splitPane);
        layout.setConstraints(this.splitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        JPanel buttonsPanel = this.createProviderButtonsPanel();
        if (this.canModify) {
            this.add(buttonsPanel);
            layout.setConstraints(buttonsPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        }
        this.listSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent ev) {
                ProvidersMain.this.tableSelectionChanged();
            }
        };
        this.table.getSelectionModel().addListSelectionListener(this.listSelectionListener);
        this.refresh();
    }

    private JPanel createTablePanel() {
        JPanel tablePanel = new JPanel(new GridBagLayout());
        this.tableModel = new DefaultTableModel((Vector)new Vector<String>(Arrays.asList("Domain Name", "Provider Type")), 0);
        this.table = new TableWidget((TableModel)this.tableModel, true);
        this.table.setEditable(false);
        this.table.sizeColumnsToFitContainer(0);
        this.table.sizeColumnsToFitContainer(1);
        this.table.setSelectionMode(2);
        this.table.setSortable(false);
        JScrollPane tableSP = new JScrollPane(this.table);
        GridBagConstraints gbcTable = new GridBagConstraints();
        gbcTable.gridx = 0;
        gbcTable.gridy = 0;
        gbcTable.insets = new Insets(3, 3, 0, 0);
        gbcTable.fill = 1;
        gbcTable.weightx = 1.0;
        gbcTable.weighty = 1.0;
        tablePanel.add((Component)tableSP, gbcTable);
        gbcTable.gridx = 1;
        gbcTable.fill = 0;
        gbcTable.weightx = 0.0;
        gbcTable.weighty = 0.0;
        tablePanel.add((Component)this.createTableButtonsPanel(), gbcTable);
        return tablePanel;
    }

    private JPanel createTableButtonsPanel() {
        JPanel buttonsPanel = new JPanel(new GridLayout(2, 1, 0, 6));
        this.moveRowUpButton = new ButtonWidget("Up");
        this.moveRowUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ProvidersMain.this.moveRowUpPressed();
            }
        });
        this.moveRowDownButton = new ButtonWidget("Down");
        this.moveRowDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ProvidersMain.this.moveRowDownPressed();
            }
        });
        buttonsPanel.add(this.moveRowUpButton);
        buttonsPanel.add(this.moveRowDownButton);
        return buttonsPanel;
    }

    private JPanel createProviderButtonsPanel() {
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new GridLayout(1, 4, 5, 5));
        this.newButton = new ButtonWidget(NEW_CONNECTOR_TITLE);
        this.deleteButton = new ButtonWidget(DELETE_CONNECTOR_TITLE);
        if (this.canModify) {
            this.setup(this.newButton, this.actionNewProvider);
            this.actionNewProvider.setEnabled(true);
            this.setup(this.deleteButton, this.actionDeleteProvider);
            this.actionDeleteProvider.setEnabled(false);
        } else {
            this.actionNewProvider.setEnabled(false);
            this.actionDeleteProvider.setEnabled(false);
        }
        buttonsPanel.add(this.newButton);
        buttonsPanel.add(this.deleteButton);
        return buttonsPanel;
    }

    private JTabbedPane createTabbedPane() {
        this.tabbedPane = new JTabbedPane();
        this.detailsPanel = new AuthenticationProviderDetailsPanel();
        this.propertiesPanel = new AuthenticationProviderPropertiesPanel(this.canModify, this.connection);
        this.tabbedPane.addTab("Details", this.detailsPanel);
        this.tabbedPane.addTab("Properties", this.propertiesPanel);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ev) {
                ProvidersMain.this.selectedTabChanged();
            }
        });
        return this.tabbedPane;
    }

    public void createActions() {
        this.actionNewProvider = new ProviderPanelAction(0, this);
        this.actionNewProvider.putValue("Name", NEW_CONNECTOR_TITLE);
        this.addActionToList("action", this.actionNewProvider);
        this.actionDeleteProvider = new ProviderPanelAction(1, this);
        this.actionDeleteProvider.putValue("Name", DELETE_CONNECTOR_TITLE);
        this.addActionToList("action", this.actionDeleteProvider);
    }

    public void addActionToList(String sID, Action act) {
        this.currentActions.add(new MenuEntry(sID, act));
    }

    private void setup(AbstractButton theButton, AbstractPanelAction theAction) {
        theAction.addComponent(theButton);
    }

    private void populateTable() {
        this.tableModel.setNumRows(0);
        List providerOrder = this.getAuthenticationOrder();
        try {
            ArrayList providers = new ArrayList(this.getAuthenticationProviderManager().getAllProviders());
            block2: for (String providerName : providerOrder) {
                Iterator it = providers.iterator();
                while (it.hasNext()) {
                    AuthenticationProvider provider = (AuthenticationProvider)it.next();
                    if (!provider.getName().equalsIgnoreCase(providerName)) continue;
                    this.addProviderToTableModel(provider);
                    it.remove();
                    continue block2;
                }
            }
            Iterator iter = providers.iterator();
            while (iter.hasNext()) {
                this.addProviderToTableModel((AuthenticationProvider)iter.next());
            }
            this.updateProviderOrder();
        }
        catch (Exception ex) {
            ExceptionUtility.showMessage("Retrieve basic provider info", ex);
            LogManager.logError((String)"CONNECTOR_BINDINGS", (Throwable)ex, (String)"Error retrieving basic provider info.");
        }
        this.forceTableSelection(this.getSelectedProviders());
    }

    private void addProviderToTableModel(AuthenticationProvider provider) {
        Vector<Object> vec = new Vector<Object>(Arrays.asList(null, null));
        vec.setElementAt(provider.getName(), 0);
        vec.setElementAt(provider.getComponentTypeID().getName(), 1);
        this.tableModel.addRow(vec);
    }

    private List getAuthenticationOrder() {
        List domainOrder = null;
        try {
            domainOrder = this.getGroupsManager().getDomainNames();
        }
        catch (AuthorizationException e) {
            e.printStackTrace();
        }
        catch (ComponentNotFoundException e) {
            e.printStackTrace();
        }
        catch (ExternalException e) {
            e.printStackTrace();
        }
        return domainOrder;
    }

    private void setAuthenticationOrder(List authOrder) {
        try {
            this.getGroupsManager().setDomainOrder(authOrder);
            this.updateConfiguration(authOrder);
        }
        catch (AuthorizationException e) {
            e.printStackTrace();
        }
        catch (ComponentNotFoundException e) {
            e.printStackTrace();
        }
        catch (ExternalException e) {
            e.printStackTrace();
        }
    }

    private void updateConfiguration(List authOrder) throws ExternalException {
        StringBuffer sb = new StringBuffer();
        Iterator iter = authOrder.iterator();
        while (iter.hasNext()) {
            String providerStr = (String)iter.next();
            sb.append(providerStr);
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        Configuration config = this.getConfigurationManager().getConfig(Configuration.NEXT_STARTUP_ID);
        ServiceComponentDefn serviceDefn = config.getServiceComponentDefn("MembershipService");
        Properties currentProps = serviceDefn.getProperties();
        currentProps.put("security.membership.DomainOrder", sb.toString());
        this.getConfigurationManager().modifyService(serviceDefn, currentProps);
    }

    public void moveRowDownPressed() {
        int selectedRow = this.table.getSelectedRow();
        int nRows = this.table.getRowCount();
        if (selectedRow > -1 && selectedRow < nRows - 1) {
            this.tableModel.moveRow(selectedRow, selectedRow, selectedRow + 1);
        }
        this.table.setRowSelectionInterval(selectedRow + 1, selectedRow + 1);
        this.updateProviderOrder();
    }

    public void moveRowUpPressed() {
        int selectedRow = this.table.getSelectedRow();
        int nRows = this.table.getRowCount();
        if (selectedRow > 0 && selectedRow < nRows) {
            this.tableModel.moveRow(selectedRow, selectedRow, selectedRow - 1);
        }
        this.table.setRowSelectionInterval(selectedRow - 1, selectedRow - 1);
        this.updateProviderOrder();
    }

    private AuthenticationProvider getProviderForRow(int rowIndex) {
        Vector rowVec = this.tableModel.getDataVector().get(rowIndex);
        String name = (String)rowVec.elementAt(0);
        return (AuthenticationProvider)this.nameProviderMap.get(name);
    }

    private void updateProviderOrder() {
        ArrayList<String> providerOrderedList = new ArrayList<String>();
        int nRows = this.table.getRowCount();
        for (int i = 0; i < nRows; ++i) {
            Vector rowVec = this.tableModel.getDataVector().get(i);
            String name = (String)rowVec.elementAt(0);
            providerOrderedList.add(name);
        }
        this.setAuthenticationOrder(providerOrderedList);
    }

    private void setUpDownButtonEnabledStates() {
        boolean enableUpButton = false;
        boolean enableDownButton = false;
        if (this.canModify) {
            int selectedRow = this.table.getSelectedRow();
            int nRows = this.table.getRowCount();
            if (selectedRow > -1 && selectedRow < nRows - 1) {
                enableDownButton = true;
            }
            if (selectedRow > 0 && selectedRow < nRows) {
                enableUpButton = true;
            }
        }
        this.moveRowDownButton.setEnabled(enableDownButton);
        this.moveRowUpButton.setEnabled(enableUpButton);
    }

    private void forceTableSelection(List providers) {
        this.table.getSelectionModel().clearSelection();
        for (AuthenticationProvider provider : providers) {
            int rowForSelected = this.rowForProvider(provider.toString());
            if (rowForSelected < 0) continue;
            this.table.getSelectionModel().addSelectionInterval(rowForSelected, rowForSelected);
            this.table.scrollRectToVisible(this.table.getCellRect(rowForSelected, 0, true));
        }
    }

    @Override
    public void postRealize() {
        this.splitPane.setDividerLocation(0.4);
        if (this.table.getRowCount() > 0) {
            this.table.setRowSelectionInterval(0, 0);
        }
    }

    public void newPressed() {
        AuthenticationProvider newProviderDefn = this.doNewProviderWizard();
        if (newProviderDefn != null) {
            this.setSelectedProvider(newProviderDefn);
            this.refresh();
        }
    }

    private AuthenticationProvider doNewProviderWizard() {
        NewAuthenticationProviderWizardController controller = new NewAuthenticationProviderWizardController(this.connection);
        AuthenticationProvider provider = controller.runWizard();
        return provider;
    }

    public void deletePressed() {
        this.showDeleteConfirmDialog();
    }

    public void showDeleteConfirmDialog() {
        String msg = "Delete selected Membership Domain providers?";
        int response = CenteredOptionPane.showConfirmDialog(ConsoleMainFrame.getInstance(), msg, "Confirm Deletion", 0);
        if (response == 0) {
            try {
                this.getAuthenticationProviderManager().deleteProviders(this.selectedProviders);
            }
            catch (Exception ex) {
                ExceptionUtility.showMessage("Delete Membership Domain providers", ex);
                LogManager.logError((String)"CONNECTOR_BINDINGS", (Throwable)ex, (String)"Error in deleting Membership Domain providers.");
            }
            this.deleteButton.setEnabled(false);
            this.refresh();
        }
    }

    public void showDeleteRefuseServiceIsDeployedDialog() {
        String msg = "Delete not allowed, Connector Binding(s) is running.";
        String sTitle = "Confirm Deletion";
        CenteredOptionPane.showConfirmDialog(ConsoleMainFrame.getInstance(), msg, sTitle, -1);
    }

    private int rowForProvider(String provider) {
        int matchRow = -1;
        int numRows = this.table.getRowCount();
        int row = 0;
        while (row < numRows && matchRow < 0) {
            String curRowProvider = this.table.getValueAt(row, 0).toString();
            if (curRowProvider.equals(provider)) {
                matchRow = row;
                continue;
            }
            ++row;
        }
        return matchRow;
    }

    private List getSelectedProviders() {
        return this.selectedProviders;
    }

    private void setSelectedProvider(AuthenticationProvider provider) {
        this.selectedProviders.clear();
        this.selectedProviders.add(provider);
    }

    private void setSelectedProviders(List providers) {
        this.selectedProviders.clear();
        this.selectedProviders.addAll(providers);
    }

    private void clearSelectedProviders() {
        this.selectedProviders.clear();
    }

    @Override
    public void receiveUpdateNotification(RuntimeUpdateNotification notification) {
        if (notification instanceof AddedConnectorBindingNotification) {
            this.refresh();
        }
    }

    @Override
    public void refresh() {
        ArrayList oldSelectedProviders = new ArrayList(this.getSelectedProviders());
        try {
            this.constructProviderXref();
            this.populateTable();
        }
        catch (Exception ex) {
            ExceptionUtility.showMessage("Failed while refreshing the Connector Binding list", ex);
            LogManager.logError((String)"CONNECTOR_BINDINGS", (Throwable)ex, (String)"Failed while refreshing the Connector Binding list");
        }
        this.setSelectedProviders(oldSelectedProviders);
        this.forceTableSelection(oldSelectedProviders);
        this.setUpDownButtonEnabledStates();
    }

    private void tableSelectionChanged() {
        boolean cancelled = false;
        List bindings = this.getSelectedProviders();
        if (bindings.size() == 1 && this.anyValueChanged()) {
            AuthenticationProvider provider = (AuthenticationProvider)bindings.get(0);
            String message = "Save changes to Membership Domain provider " + provider + " ?";
            int response = DialogUtility.showPendingChangesDialog(message, this.getConnection().getURL(), this.getConnection().getUser());
            switch (response) {
                case 0: {
                    this.applyProperties();
                    break;
                }
                case 1: {
                    this.resetProperties();
                    break;
                }
                case 2: {
                    cancelled = true;
                    this.table.getSelectionModel().removeListSelectionListener(this.listSelectionListener);
                    ArrayList<AuthenticationProvider> newList = new ArrayList<AuthenticationProvider>();
                    newList.add(provider);
                    this.forceTableSelection(newList);
                    this.table.getSelectionModel().addListSelectionListener(this.listSelectionListener);
                }
            }
        }
        if (!cancelled) {
            StaticUtilities.startWait(ViewManager.getMainFrame());
            int[] selectedRows = this.table.getSelectedRows();
            int numSelected = selectedRows.length;
            if (numSelected == 0) {
                this.tableSelectionChangedNoneSelected();
            } else if (numSelected == 1) {
                this.tableSelectionChangedOneSelected(selectedRows[0]);
            } else {
                this.tableSelectionChangedMultipleSelected(selectedRows);
            }
            this.forceRepaint();
            StaticUtilities.endWait(ViewManager.getMainFrame());
        }
    }

    private void tableSelectionChangedNoneSelected() {
        this.clearSelectedProviders();
        this.actionDeleteProvider.setEnabled(false);
        this.moveRowUpButton.setEnabled(false);
        this.moveRowDownButton.setEnabled(false);
        Border border = this.createTabBorder(null);
        int curTab = this.tabbedPane.getSelectedIndex();
        switch (curTab) {
            case 0: {
                if (this.detailsPanel.getProvider() == null) break;
                this.detailsPanel.setProvider(null);
                this.detailsPanel.setBorder(border);
                break;
            }
            case 1: {
                if (this.propertiesPanel.getProvider() == null) break;
                this.propertiesPanel.setProvider(null);
                this.propertiesPanel.setBorder(border);
            }
        }
    }

    private void tableSelectionChangedOneSelected(int selectedRow) {
        int convertedRow = this.table.convertRowIndexToModel(selectedRow);
        String selectedName = (String)this.table.getModel().getValueAt(convertedRow, 0);
        AuthenticationProvider provider = (AuthenticationProvider)this.getProviderXref().get(selectedName);
        this.setSelectedProvider(provider);
        this.actionDeleteProvider.setEnabled(this.canModify);
        this.setUpDownButtonEnabledStates();
        Border border = this.createTabBorder(provider);
        int curTab = this.tabbedPane.getSelectedIndex();
        switch (curTab) {
            case 0: {
                this.detailsPanel.setProvider((ComponentDefn)provider);
                this.detailsPanel.setBorder(border);
                break;
            }
            case 1: {
                this.propertiesPanel.setProvider((ComponentDefn)provider);
                this.propertiesPanel.setBorder(border);
            }
        }
    }

    private void tableSelectionChangedMultipleSelected(int[] selectedRows) {
        AuthenticationProvider provider = null;
        for (int selectedRow : selectedRows) {
            int convertedRow = this.table.convertRowIndexToModel(selectedRow);
            String selectedName = (String)this.table.getModel().getValueAt(convertedRow, 0);
            provider = (AuthenticationProvider)this.getProviderXref().get(selectedName);
        }
        this.setSelectedProvider(provider);
        this.actionDeleteProvider.setEnabled(this.canModify);
        this.moveRowUpButton.setEnabled(false);
        this.moveRowDownButton.setEnabled(false);
        Border border = this.createTabBorder(null);
        int curTab = this.tabbedPane.getSelectedIndex();
        switch (curTab) {
            case 0: {
                if (this.detailsPanel.getProvider() == null) break;
                this.detailsPanel.setProvider(null);
                this.detailsPanel.setBorder(border);
                break;
            }
            case 1: {
                if (this.propertiesPanel.getProvider() == null) break;
                this.propertiesPanel.setProvider(null);
                this.propertiesPanel.setBorder(border);
            }
        }
    }

    private void selectedTabChanged() {
        int curTab = this.tabbedPane.getSelectedIndex();
        int numSelected = this.selectedProviders.size();
        AuthenticationProvider selectedProvider = null;
        if (numSelected == 1) {
            selectedProvider = (AuthenticationProvider)this.selectedProviders.get(0);
        }
        switch (curTab) {
            case 0: {
                boolean needsRefresh;
                if (selectedProvider == null) {
                    needsRefresh = this.detailsPanel.getProvider() != null;
                } else {
                    boolean bl = needsRefresh = !selectedProvider.equals(this.detailsPanel.getProvider());
                }
                if (!needsRefresh) break;
                this.detailsPanel.setProvider((ComponentDefn)selectedProvider);
                this.detailsPanel.setBorder(this.createTabBorder(selectedProvider));
                break;
            }
            case 1: {
                boolean needsRefresh;
                if (selectedProvider == null) {
                    needsRefresh = this.propertiesPanel.getProvider() != null;
                } else {
                    boolean bl = needsRefresh = !selectedProvider.equals(this.propertiesPanel.getProvider());
                }
                if (!needsRefresh) break;
                this.propertiesPanel.setProvider((ComponentDefn)selectedProvider);
                this.propertiesPanel.setBorder(this.createTabBorder(selectedProvider));
            }
        }
        this.forceRepaint();
    }

    private Border createTabBorder(AuthenticationProvider defn) {
        String title = defn == null ? "" : "Membership Domain Provider:  " + defn.toString();
        TitledBorder border = new TitledBorder(title);
        return border;
    }

    @Override
    public List resume() {
        return this.currentActions;
    }

    @Override
    public String getTitle() {
        return "Membership Domain Providers";
    }

    @Override
    public ConnectionInfo getConnection() {
        return this.connection;
    }

    private HashMap getProviderXref() {
        if (this.nameProviderMap == null) {
            this.constructProviderXref();
        }
        return this.nameProviderMap;
    }

    private void constructProviderXref() {
        this.nameProviderMap = new HashMap();
        ArrayList providersList = null;
        try {
            providersList = new ArrayList(this.getAuthenticationProviderManager().getAllProviders());
        }
        catch (Exception e) {
            ExceptionUtility.showMessage("Failed while loading data into Membership Domain Provider Panel", e);
        }
        Iterator it = providersList.iterator();
        AuthenticationProvider tempDefn = null;
        while (it.hasNext()) {
            tempDefn = (AuthenticationProvider)it.next();
            this.nameProviderMap.put(tempDefn.toString(), tempDefn);
        }
    }

    private void forceRepaint() {
        StaticUtilities.jiggleSplitter(this.splitPane);
    }

    @Override
    public void configurationChanged(ConfigurationChangeEvent theEvent) {
        if (theEvent.getType() == 16) {
            this.refresh();
        }
    }

    private void applyProperties() {
        if (this.propertiesPanel != null) {
            this.propertiesPanel.applyProperties();
        }
    }

    private void resetProperties() {
        if (this.propertiesPanel != null) {
            this.propertiesPanel.resetProperties();
        }
    }

    private boolean anyValueChanged() {
        if (this.propertiesPanel == null) {
            return false;
        }
        return this.propertiesPanel.anyValueChanged();
    }

    private boolean rowIsEnabled(TableModel model, int row) {
        boolean enabled = false;
        AuthenticationProvider provider = this.getProviderForRow(row);
        if (provider != null) {
            enabled = provider.isActivated();
        }
        return enabled;
    }

    public final class ProvidersCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable theTable, Object theValue, boolean theSelectedFlag, boolean theHasFocusFlag, int theRow, int theColumn) {
            Component comp = super.getTableCellRendererComponent(theTable, theValue, theSelectedFlag, theHasFocusFlag, theRow, theColumn);
            if (theHasFocusFlag) {
                ((JComponent)comp).setBorder(UIDefaults.getInstance().getBorder("Table.focusCellHighlightBorder"));
            } else {
                ((JComponent)comp).setBorder(UIDefaults.getInstance().getBorder("Table.noFocusBorder"));
            }
            if (theSelectedFlag) {
                comp.setBackground(theTable.getSelectionBackground());
            } else if (!ProvidersMain.this.rowIsEnabled(ProvidersMain.this.tableModel, theRow)) {
                comp.setBackground(Color.PINK);
            } else {
                comp.setBackground(theTable.getBackground());
            }
            return comp;
        }
    }
}

