/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.authorization;

import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationID;
import com.metamatrix.common.config.api.ConfigurationModelContainer;
import com.metamatrix.common.config.api.ServiceComponentDefn;
import com.metamatrix.console.ConsolePlugin;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.ConfigurationManager;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.notification.RuntimeUpdateNotification;
import com.metamatrix.console.ui.layout.BasePanel;
import com.metamatrix.console.ui.layout.WorkspacePanel;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.ExternalException;
import com.metamatrix.console.util.Refreshable;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.platform.admin.api.AuthorizationAdminAPI;
import com.metamatrix.platform.admin.api.MembershipAdminAPI;
import com.metamatrix.platform.security.api.Credentials;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.CheckBox;
import com.metamatrix.toolbox.ui.widget.DialogPanel;
import com.metamatrix.toolbox.ui.widget.DialogWindow;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.TextFieldWidget;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SummaryMain
extends BasePanel
implements WorkspacePanel,
Refreshable {
    private static final String SPACE = " ";
    private ConnectionInfo connection;
    private CheckBox chkbxEnableAuth;
    private ButtonWidget applyButton;
    private ButtonWidget resetButton;
    private TextFieldWidget usernameTextField;
    private ButtonWidget changePasswordButton;
    private String newPassword;

    public SummaryMain(ConnectionInfo conn) {
        this.connection = conn;
        this.init();
    }

    private void init() {
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        JPanel summaryPanel = this.createSummaryPanel();
        this.add(summaryPanel);
        layout.setConstraints(summaryPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.refresh(Configuration.STARTUP_ID);
    }

    private ConfigurationManager getConfigurationManager() {
        return ModelManager.getConfigurationManager(this.connection);
    }

    private JPanel createSummaryPanel() {
        JPanel summaryPanel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        summaryPanel.setLayout(layout);
        this.chkbxEnableAuth = new CheckBox(SPACE + ConsolePlugin.Util.getString("SummaryMain.enableAuthCheckBox.label"));
        this.chkbxEnableAuth.setToolTipText(ConsolePlugin.Util.getString("SummaryMain.enableAuthCheckBox.tooltip"));
        this.chkbxEnableAuth.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ev) {
                SummaryMain.this.updateWidgetEnabledStates();
            }
        });
        summaryPanel.add(this.chkbxEnableAuth);
        layout.setConstraints(this.chkbxEnableAuth, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(2, 2, 2, 2), 0, 0));
        JPanel resetAdminUsernamePanel = this.createResetAdminUsernamePanel();
        summaryPanel.add(resetAdminUsernamePanel);
        layout.setConstraints(resetAdminUsernamePanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 2, 2, 2), 0, 0));
        JPanel resetAdminPasswordPanel = this.createResetAdminPasswordPanel();
        summaryPanel.add(resetAdminPasswordPanel);
        layout.setConstraints(resetAdminPasswordPanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 2, 2, 2), 0, 0));
        JPanel buttonPanel = this.createButtonPanel();
        summaryPanel.add(buttonPanel);
        layout.setConstraints(buttonPanel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 2, 2, 2), 0, 0));
        return summaryPanel;
    }

    private JPanel createButtonPanel() {
        JPanel buttonPanel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        buttonPanel.setLayout(layout);
        this.applyButton = new ButtonWidget(ConsolePlugin.Util.getString("SummaryMain.applyButton.text"));
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                SummaryMain.this.applyButtonPressed();
            }
        });
        buttonPanel.add(this.applyButton);
        layout.setConstraints(this.applyButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.resetButton = new ButtonWidget(ConsolePlugin.Util.getString("SummaryMain.resetButton.text"));
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                SummaryMain.this.refresh(Configuration.NEXT_STARTUP_ID);
            }
        });
        buttonPanel.add(this.resetButton);
        layout.setConstraints(this.resetButton, new GridBagConstraints(1, 0, 1, 1, 0.8, 1.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        return buttonPanel;
    }

    private JPanel createResetAdminUsernamePanel() {
        JPanel resetPanel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        resetPanel.setLayout(layout);
        LabelWidget setUsernameLabel = new LabelWidget(ConsolePlugin.Util.getString("SummaryMain.username.label"));
        resetPanel.add(setUsernameLabel);
        layout.setConstraints(setUsernameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.usernameTextField = new TextFieldWidget(30);
        resetPanel.add(this.usernameTextField);
        layout.setConstraints(this.usernameTextField, new GridBagConstraints(1, 0, 1, 1, 0.8, 1.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.usernameTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent ev) {
                SummaryMain.this.updateWidgetEnabledStates();
            }

            @Override
            public void insertUpdate(DocumentEvent ev) {
                SummaryMain.this.updateWidgetEnabledStates();
            }

            @Override
            public void removeUpdate(DocumentEvent ev) {
                SummaryMain.this.updateWidgetEnabledStates();
            }
        });
        return resetPanel;
    }

    private JPanel createResetAdminPasswordPanel() {
        JPanel resetPanel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        resetPanel.setLayout(layout);
        LabelWidget setPasswordLabel = new LabelWidget(ConsolePlugin.Util.getString("SummaryMain.password.label"));
        resetPanel.add(setPasswordLabel);
        layout.setConstraints(setPasswordLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        String text = ConsolePlugin.Util.getString("SummaryMain.changePassButton.text");
        this.changePasswordButton = new ButtonWidget(text);
        this.changePasswordButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                SummaryMain.this.setNewPassword();
                SummaryMain.this.updateWidgetEnabledStates();
            }
        });
        resetPanel.add(this.changePasswordButton);
        layout.setConstraints(this.changePasswordButton, new GridBagConstraints(1, 0, 1, 1, 0.8, 1.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        return resetPanel;
    }

    private void setNewPassword() {
        PasswordConfirmPanel pcp = new PasswordConfirmPanel();
        DialogWindow.show(this, ConsolePlugin.Util.getString("SummaryMain.resetPasswordDialog.title"), pcp);
        if (pcp.getSelectedButton() == pcp.getAcceptButton()) {
            char[] newPass = pcp.getNewPassword();
            String newPassStr = new String(newPass);
            char[] newPassConfirm = pcp.getNewPassword2();
            String newPassConfirmStr = new String(newPassConfirm);
            this.newPassword = null;
            if (newPassStr == null || newPassStr.length() == 0) {
                String title = ConsolePlugin.Util.getString("SummaryMain.invalidPasswordDialog.title");
                String msg = ConsolePlugin.Util.getString("SummaryMain.invalidPasswordDialog.invalidNewPass.msg");
                StaticUtilities.displayModalDialogWithOK(title, msg);
                return;
            }
            if (newPassConfirmStr == null || newPassConfirmStr.length() == 0) {
                String title = ConsolePlugin.Util.getString("SummaryMain.invalidPasswordDialog.title");
                String msg = ConsolePlugin.Util.getString("SummaryMain.invalidPasswordDialog.invalidNewPassConf.msg");
                StaticUtilities.displayModalDialogWithOK(title, msg);
                return;
            }
            if (!newPassConfirmStr.equals(newPassStr)) {
                String title = ConsolePlugin.Util.getString("SummaryMain.passNoMatchDialog.title");
                String msg = ConsolePlugin.Util.getString("SummaryMain.passNoMatchDialog.msg");
                StaticUtilities.displayModalDialogWithOK(title, msg);
                return;
            }
            this.newPassword = newPassConfirmStr;
        } else {
            String title = ConsolePlugin.Util.getString("SummaryMain.cancelResetDialog.title");
            String msg = ConsolePlugin.Util.getString("SummaryMain.cancelResetDialog.msg");
            StaticUtilities.displayModalDialogWithOK(title, msg);
            this.newPassword = null;
        }
    }

    private boolean hasPasswordUpdate() {
        return this.newPassword != null;
    }

    private boolean hasUsernameUpdate() {
        String nextStartUser = this.getUsername(Configuration.NEXT_STARTUP_ID);
        String enteredUser = this.usernameTextField.getText();
        return enteredUser != null && enteredUser.trim().length() > 0 && !enteredUser.equals(nextStartUser);
    }

    private boolean enteredUserIsEmpty() {
        String enteredUser = this.usernameTextField.getText();
        return enteredUser == null || enteredUser.trim().length() == 0;
    }

    private boolean enteredUserIsValid() {
        String enteredUser = this.usernameTextField.getText();
        if (enteredUser == null || enteredUser.trim().length() == 0) {
            return false;
        }
        char[] userChars = enteredUser.trim().toCharArray();
        for (int i = 0; i < userChars.length; ++i) {
            if (StringUtil.isLetterOrDigit((char)userChars[i])) continue;
            return false;
        }
        return true;
    }

    private boolean hasEnabledUpdate() {
        boolean nextStartEnabledState = this.getEnabledState(Configuration.NEXT_STARTUP_ID);
        return nextStartEnabledState != this.chkbxEnableAuth.isSelected();
    }

    private String getUsername(ConfigurationID configID) {
        Configuration config = this.getConfigurationManager().getConfig(configID);
        ServiceComponentDefn serviceDefn = config.getServiceComponentDefn("MembershipService");
        String user = serviceDefn.getProperty("security.membership.admin.username");
        return user;
    }

    private boolean getEnabledState(ConfigurationID configID) {
        ConfigurationModelContainer configModel = this.getConfigurationManager().getConfigModel(configID);
        Configuration config = this.getConfigurationManager().getConfig(configID);
        ServiceComponentDefn serviceDefn = config.getServiceComponentDefn("MembershipService");
        Properties props = configModel.getDefaultPropertyValues(serviceDefn.getComponentTypeID());
        String enabledDefault = props.getProperty("security.membership.security.enabled");
        boolean enabledState = false;
        String enabled = serviceDefn.getProperty("security.membership.security.enabled");
        if (enabled != null) {
            enabledState = new Boolean(enabled);
        } else if (enabledDefault != null) {
            enabledState = new Boolean(enabledDefault);
        }
        return enabledState;
    }

    private void applyButtonPressed() {
        block6: {
            if (!this.enteredUserIsValid()) {
                String title = ConsolePlugin.Util.getString("SummaryMain.invalidUserDialog.title");
                String msg = ConsolePlugin.Util.getString("SummaryMain.invalidUserDialog.msg");
                StaticUtilities.displayModalDialogWithOK(title, msg);
                return;
            }
            String dialogText = ConsolePlugin.Util.getString("SummaryMain.confirmPasswordDialog.msg");
            CurrentPasswordConfirmPanel pcp = new CurrentPasswordConfirmPanel(dialogText);
            DialogWindow.show(this, ConsolePlugin.Util.getString("SummaryMain.confirmPasswordDialog.title"), pcp);
            if (pcp.getSelectedButton() == pcp.getAcceptButton()) {
                char[] currentPass = pcp.getCurrentPassword();
                String currentPassStr = new String(currentPass);
                if (currentPassStr == null || currentPassStr.length() == 0) {
                    String title = ConsolePlugin.Util.getString("SummaryMain.invalidPasswordDialog.title");
                    String msg = ConsolePlugin.Util.getString("SummaryMain.invalidPasswordDialog.invalidCurrentPass.msg");
                    StaticUtilities.displayModalDialogWithOK(title, msg);
                    return;
                }
                MembershipAdminAPI membershipAPI = ModelManager.getMembershipAPI(this.connection);
                try {
                    if (!membershipAPI.authenticateUser(this.connection.getUser(), new Credentials(currentPass), null, null)) {
                        String title = ConsolePlugin.Util.getString("SummaryMain.authErrorDialog.title");
                        String msg = ConsolePlugin.Util.getString("SummaryMain.authErrorDialog.msg");
                        StaticUtilities.displayModalDialogWithOK(title, msg);
                        return;
                    }
                    break block6;
                }
                catch (Exception err) {
                    String title = ConsolePlugin.Util.getString("SummaryMain.authErrorDialog.title");
                    String msg = ConsolePlugin.Util.getString("SummaryMain.authErrorMessage.text");
                    ExceptionUtility.showMessage(title, msg, err);
                    return;
                }
            }
            String title = ConsolePlugin.Util.getString("SummaryMain.cancelApplyDialog.title");
            String msg = ConsolePlugin.Util.getString("SummaryMain.cancelApplyDialog.msg");
            StaticUtilities.displayModalDialogWithOK(title, msg);
            return;
        }
        this.updateNextStartupConfigWithPendingChanges();
        this.refresh(Configuration.NEXT_STARTUP_ID);
    }

    private void updateNextStartupConfigWithPendingChanges() {
        Configuration config = this.getConfigurationManager().getConfig(Configuration.NEXT_STARTUP_ID);
        ServiceComponentDefn serviceDefn = config.getServiceComponentDefn("MembershipService");
        Properties nextStartupProperties = serviceDefn.getProperties();
        Properties props = (Properties)nextStartupProperties.clone();
        String user = this.usernameTextField.getText();
        if (user != null && user.trim().length() > 0) {
            props.setProperty("security.membership.admin.username", user);
        }
        if (this.newPassword != null && this.newPassword.trim().length() > 0) {
            props.setProperty("security.membership.admin.password", this.newPassword);
        }
        props.setProperty("security.membership.security.enabled", new Boolean(this.chkbxEnableAuth.isSelected()).toString());
        try {
            this.getConfigurationManager().modifyService(serviceDefn, props);
            String title = ConsolePlugin.Util.getString("SummaryMain.configModifiedDialog.title");
            String msg = ConsolePlugin.Util.getString("SummaryMain.configModifiedDialog.msg");
            StaticUtilities.displayModalDialogWithOK(title, msg);
        }
        catch (ExternalException err) {
            ExceptionUtility.showMessage(ConsolePlugin.Util.getString("SummaryMain.updateConfigError.text"), (Throwable)((Object)err));
        }
    }

    @Override
    public void refresh() {
        this.refresh(Configuration.NEXT_STARTUP_ID);
    }

    public void refresh(ConfigurationID configID) {
        String nsUsername = this.getUsername(configID);
        this.usernameTextField.setText(nsUsername);
        boolean nsEnabled = this.getEnabledState(configID);
        this.chkbxEnableAuth.setSelected(new Boolean(nsEnabled));
        this.newPassword = null;
        this.updateWidgetEnabledStates();
    }

    private boolean isSuperUser() {
        boolean isSuperUser = false;
        AuthorizationAdminAPI authAPI = ModelManager.getAuthorizationAPI(this.connection);
        try {
            isSuperUser = authAPI.isSuperUser(this.connection.getUser());
        }
        catch (Exception e) {
            ExceptionUtility.showMessage(ConsolePlugin.Util.getString("SummaryMain.getSettingsError.text"), e);
        }
        return isSuperUser;
    }

    private void updateWidgetEnabledStates() {
        boolean isSuperUser = this.isSuperUser();
        this.chkbxEnableAuth.setEnabled(isSuperUser);
        this.usernameTextField.setEnabled(isSuperUser);
        this.changePasswordButton.setEnabled(isSuperUser);
        if (!isSuperUser) {
            this.applyButton.setEnabled(isSuperUser);
            this.resetButton.setEnabled(isSuperUser);
        } else if (this.enteredUserIsEmpty()) {
            this.applyButton.setEnabled(false);
            this.resetButton.setEnabled(true);
        } else if (this.hasUsernameUpdate() || this.hasPasswordUpdate() || this.hasEnabledUpdate()) {
            this.applyButton.setEnabled(true);
            this.resetButton.setEnabled(true);
        } else {
            this.applyButton.setEnabled(false);
            this.resetButton.setEnabled(false);
        }
    }

    @Override
    public String getTitle() {
        return ConsolePlugin.Util.getString("SummaryMain.pageTitle.text");
    }

    @Override
    public ConnectionInfo getConnection() {
        return this.connection;
    }

    @Override
    public List resume() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public void receiveUpdateNotification(RuntimeUpdateNotification notification) {
    }

    private class PasswordConfirmPanel
    extends DialogPanel {
        private JPasswordField newPasswordField;
        private JPasswordField newPasswordField2;

        public PasswordConfirmPanel() {
            this.init();
        }

        protected char[] getNewPassword() {
            if (this.newPasswordField != null) {
                return this.newPasswordField.getPassword();
            }
            return new char[0];
        }

        protected char[] getNewPassword2() {
            if (this.newPasswordField2 != null) {
                return this.newPasswordField2.getPassword();
            }
            return new char[0];
        }

        private void init() {
            JPanel confirmPasswordPanel = new JPanel();
            this.setContent(confirmPasswordPanel);
            GridBagLayout layout = new GridBagLayout();
            confirmPasswordPanel.setLayout(layout);
            String text = ConsolePlugin.Util.getString("SummaryMain.newPassLabel.text");
            LabelWidget newPasswordLabel = new LabelWidget(text);
            confirmPasswordPanel.add(newPasswordLabel);
            layout.setConstraints(newPasswordLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
            this.newPasswordField = new JPasswordField(30);
            confirmPasswordPanel.add(this.newPasswordField);
            layout.setConstraints(this.newPasswordField, new GridBagConstraints(1, 0, 1, 1, 0.8, 1.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
            text = ConsolePlugin.Util.getString("SummaryMain.newPassConfLabel.text");
            LabelWidget newPasswordLabel2 = new LabelWidget(text);
            confirmPasswordPanel.add(newPasswordLabel2);
            layout.setConstraints(newPasswordLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
            this.newPasswordField2 = new JPasswordField(30);
            confirmPasswordPanel.add(this.newPasswordField2);
            layout.setConstraints(this.newPasswordField2, new GridBagConstraints(1, 1, 1, 1, 0.8, 1.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        }
    }

    private class CurrentPasswordConfirmPanel
    extends DialogPanel {
        private JPasswordField currentPasswordField;

        public CurrentPasswordConfirmPanel(String messageText) {
            this.init(messageText);
        }

        protected char[] getCurrentPassword() {
            if (this.currentPasswordField != null) {
                return this.currentPasswordField.getPassword();
            }
            return new char[0];
        }

        private void init(String messageText) {
            JPanel confirmPasswordPanel = new JPanel();
            this.setContent(confirmPasswordPanel);
            GridBagLayout layout = new GridBagLayout();
            confirmPasswordPanel.setLayout(layout);
            LabelWidget messageLabel = new LabelWidget(messageText);
            confirmPasswordPanel.add(messageLabel);
            layout.setConstraints(messageLabel, new GridBagConstraints(0, 0, 2, 1, 0.0, 1.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
            String text = ConsolePlugin.Util.getString("SummaryMain.currentPassLabel.text");
            LabelWidget currentAdminPasswordLabel = new LabelWidget(text);
            confirmPasswordPanel.add(currentAdminPasswordLabel);
            layout.setConstraints(currentAdminPasswordLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
            this.currentPasswordField = new JPasswordField(30);
            confirmPasswordPanel.add(this.currentPasswordField);
            layout.setConstraints(this.currentPasswordField, new GridBagConstraints(1, 1, 1, 1, 0.8, 1.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        }
    }
}

