/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.connector;

import com.metamatrix.admin.api.server.ServerAdmin;
import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.xml.XMLConfigurationImportExportUtility;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.tree.TreeNode;
import com.metamatrix.common.tree.directory.DirectoryEntry;
import com.metamatrix.common.tree.directory.DirectoryEntryFilter;
import com.metamatrix.common.tree.directory.DirectoryEntryView;
import com.metamatrix.common.tree.directory.FileSystemFilter;
import com.metamatrix.common.tree.directory.FileSystemView;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.ConnectorManager;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.notification.RuntimeUpdateNotification;
import com.metamatrix.console.security.UserCapabilities;
import com.metamatrix.console.ui.ViewManager;
import com.metamatrix.console.ui.layout.BasePanel;
import com.metamatrix.console.ui.layout.ConsoleMainFrame;
import com.metamatrix.console.ui.layout.MenuEntry;
import com.metamatrix.console.ui.layout.WorkspacePanel;
import com.metamatrix.console.ui.util.AbstractPanelAction;
import com.metamatrix.console.ui.util.CenteredOptionPane;
import com.metamatrix.console.ui.views.connector.ConnectorBasicInfo;
import com.metamatrix.console.ui.views.connector.ConnectorTableModel;
import com.metamatrix.console.ui.views.connector.ImportWizardController;
import com.metamatrix.console.ui.views.deploy.util.DeployPkgUtils;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.Refreshable;
import com.metamatrix.console.util.StaticProperties;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.core.util.FileUtils;
import com.metamatrix.toolbox.preference.UserPreferences;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.DialogWindow;
import com.metamatrix.toolbox.ui.widget.DirectoryChooserPanel;
import com.metamatrix.toolbox.ui.widget.TableWidget;
import com.metamatrix.toolbox.ui.widget.TextFieldWidget;
import com.metamatrix.toolbox.ui.widget.TitledBorder;
import com.metamatrix.toolbox.ui.widget.table.DefaultTableComparator;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

public class ConnectorPanel
extends BasePanel
implements WorkspacePanel,
Refreshable {
    public static final int CONNECTOR_COL_NUM = 0;
    public static final int NUM_BINDINGS_COL_NUM = 1;
    private static final String PANEL_NAME = "Connector Types";
    private PanelAction actionImportConnector;
    private PanelAction actionExportConnector;
    private PanelAction actionDeleteConnector;
    private static final String IMPORT_CONNECTOR_TITLE = "Import...";
    private static final String EXPORT_CONNECTOR_TITLE = "Export...";
    private static final String DELETE_CONNECTOR_TITLE = "Delete";
    private static final String EXPORT_CAF_EXTENSION = DeployPkgUtils.getString("ecp.export.caf.extension");
    private ConnectionInfo connection;
    private ConnectorManager manager;
    private TableWidget table;
    private JPanel detailsPanel;
    private ConnectorTableModel tableModel;
    private TextFieldWidget createdField;
    private TextFieldWidget createdByField;
    private TextFieldWidget registeredField;
    private TextFieldWidget registeredByField;
    private ButtonWidget importButton;
    private ButtonWidget exportButton;
    private ButtonWidget deleteButton;
    private ConnectorBasicInfo[] infoInTable = null;
    private String selectedConnectorName = null;
    private int selectedTableRow = -1;
    private List currentActions = new ArrayList(5);
    private boolean canModify;

    public ConnectorPanel(ConnectionInfo conn) {
        this.connection = conn;
        this.manager = ModelManager.getConnectorManager(this.connection);
        try {
            this.canModify = UserCapabilities.getInstance().canModifyConnectors(this.connection);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.init();
    }

    private void init() {
        this.createActions();
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        this.tableModel = new ConnectorTableModel(new Vector<String>(Arrays.asList("Name", "# Bindings")));
        this.table = new TableWidget((TableModel)this.tableModel, true);
        this.table.setEditable(false);
        this.table.sizeColumnsToFitData(100);
        DefaultTableComparator dtcComparator = (DefaultTableComparator)this.table.getComparator();
        dtcComparator.setIgnoresCase(true);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent ev) {
                ConnectorPanel.this.tableSelectionChanged();
            }
        });
        this.table.getSelectionModel().setSelectionMode(0);
        this.table.getColumnModel().setColumnMargin(8);
        JScrollPane tableSP = new JScrollPane(this.table);
        tableSP.setBorder(new TitledBorder(""));
        this.detailsPanel = new JPanel();
        this.detailsPanel.setPreferredSize(new Dimension(500, 200));
        TitledBorder tBorder = new TitledBorder("Details");
        this.detailsPanel.setBorder(tBorder);
        tBorder.setTitleFont(tBorder.getTitleFont().deriveFont(1));
        GridBagLayout dl = new GridBagLayout();
        this.detailsPanel.setLayout(dl);
        JLabel createdLabel = new JLabel("Created:");
        this.detailsPanel.add(createdLabel);
        dl.setConstraints(createdLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.createdField = new TextFieldWidget();
        this.createdField.setEditable(false);
        this.detailsPanel.add(this.createdField);
        dl.setConstraints(this.createdField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        JLabel createdByLabel = new JLabel("By:");
        this.detailsPanel.add(createdByLabel);
        dl.setConstraints(createdByLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.createdByField = new TextFieldWidget();
        this.createdByField.setEditable(false);
        this.detailsPanel.add(this.createdByField);
        dl.setConstraints(this.createdByField, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        JLabel registeredLabel = new JLabel("Registered:");
        this.detailsPanel.add(registeredLabel);
        dl.setConstraints(registeredLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.registeredField = new TextFieldWidget();
        this.registeredField.setEditable(false);
        this.detailsPanel.add(this.registeredField);
        dl.setConstraints(this.registeredField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        JLabel registeredByLabel = new JLabel("By:");
        this.detailsPanel.add(registeredByLabel);
        dl.setConstraints(registeredByLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.registeredByField = new TextFieldWidget();
        this.registeredByField.setEditable(false);
        this.detailsPanel.add(this.registeredByField);
        dl.setConstraints(this.registeredByField, new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.importButton = new ButtonWidget(IMPORT_CONNECTOR_TITLE);
        this.setup("action", this.importButton, this.actionImportConnector);
        this.actionImportConnector.setEnabled(this.canModify);
        this.exportButton = new ButtonWidget(EXPORT_CONNECTOR_TITLE);
        this.setup("action", this.exportButton, this.actionExportConnector);
        this.actionExportConnector.setEnabled(true);
        this.deleteButton = new ButtonWidget(DELETE_CONNECTOR_TITLE);
        this.deleteButton.setEnabled(false);
        this.setup("action", this.deleteButton, this.actionDeleteConnector);
        this.actionDeleteConnector.setEnabled(false);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new GridLayout(1, 2, 5, 5));
        buttonsPanel.add(this.importButton);
        buttonsPanel.add(this.exportButton);
        buttonsPanel.add(this.deleteButton);
        this.add(tableSP);
        layout.setConstraints(tableSP, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.detailsPanel);
        layout.setConstraints(this.detailsPanel, new GridBagConstraints(0, 1, 1, 1, 0.5, 0.5, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(buttonsPanel);
        layout.setConstraints(buttonsPanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.populateTable();
        this.selectFirstConnector();
    }

    public void createActions() {
        this.actionImportConnector = new PanelAction(0);
        this.actionImportConnector.putValue("Name", IMPORT_CONNECTOR_TITLE);
        this.actionExportConnector = new PanelAction(2);
        this.actionExportConnector.putValue("Name", EXPORT_CONNECTOR_TITLE);
        this.actionDeleteConnector = new PanelAction(1);
        this.actionDeleteConnector.putValue("Name", DELETE_CONNECTOR_TITLE);
    }

    public void addActionToList(String sID, Action act) {
        this.currentActions.add(new MenuEntry(sID, act));
    }

    private void setup(String sID, AbstractButton theButton, AbstractPanelAction theAction) {
        theAction.addComponent(theButton);
        this.addActionToList(sID, theAction);
    }

    public void importPressed() {
        boolean bConnectorCreated = this.doImportWizard();
        if (bConnectorCreated) {
            // empty if block
        }
    }

    public void exportPressed() {
        this.exportConnectorType();
    }

    private void exportConnectorType() {
        if (this.selectedConnectorName == null) {
            String msg = "Must select a connector type before trying to export";
            String sTitle = "Unable to Export Connector Type";
            CenteredOptionPane.showConfirmDialog(ConsoleMainFrame.getInstance(), msg, sTitle, -1);
            return;
        }
        FileSystemView view = new FileSystemView();
        String dirTxt = (String)UserPreferences.getInstance().getValue("metamatrix.console.directory");
        if (dirTxt != null) {
            try {
                view.setHome((TreeNode)view.lookup(dirTxt));
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        String[] extensionsCAF = (String[])DeployPkgUtils.getObject("ecp.export.caf.extensions");
        FileSystemFilter filterCAF = new FileSystemFilter(view, extensionsCAF, DeployPkgUtils.getString("ecp.export.caf.description"));
        String[] extensionsCDK = (String[])DeployPkgUtils.getObject("ecp.export.cdk.extensions");
        FileSystemFilter filterCDK = new FileSystemFilter(view, extensionsCDK, DeployPkgUtils.getString("ecp.export.cdk.description"));
        FileSystemFilter[] filters = new FileSystemFilter[]{filterCAF, filterCDK};
        ConnectorExportChooserPanel pnlChooser = new ConnectorExportChooserPanel((DirectoryEntryView)view, 1, (DirectoryEntryFilter[])filters);
        pnlChooser.setAcceptButtonLabel(DeployPkgUtils.getString("ecp.export.open"));
        pnlChooser.setShowPassThruFilter(false);
        pnlChooser.setInitialFilename(this.selectedConnectorName + EXPORT_CAF_EXTENSION);
        DialogWindow.show(this, DeployPkgUtils.getString("ecp.export.title", new Object[]{this.selectedConnectorName}), pnlChooser);
        if (pnlChooser.getSelectedButton() == pnlChooser.getAcceptButton()) {
            DirectoryEntry result = (DirectoryEntry)pnlChooser.getSelectedTreeNode();
            String filename = result.getNamespace();
            int index = filename.lastIndexOf(File.separatorChar);
            String path = filename.substring(0, index);
            UserPreferences.getInstance().setValue("metamatrix.console.directory", path);
            UserPreferences.getInstance().saveChanges();
            try {
                FileSystemFilter selectedFilter = (FileSystemFilter)pnlChooser.getSelectedFilter();
                if (selectedFilter == filterCAF) {
                    this.exportCAFFile(filename);
                } else if (selectedFilter == filterCDK) {
                    this.exportCDKFile(filename);
                }
            }
            catch (Exception theException) {
                theException.printStackTrace();
                DeployPkgUtils.getString("ecp.msg.exporterrordetail", new Object[]{this.selectedConnectorName, filename});
                ExceptionUtility.showMessage("Unable to Export Connector Type", theException);
                LogManager.logError((String)"CONNECTORS", (Throwable)theException, (String)("Error exporting connector type " + this.selectedConnectorName));
            }
        }
    }

    private void exportCAFFile(String filename) throws Exception {
        ServerAdmin admin = this.getConnection().getServerAdmin();
        byte[] bytes = admin.exportConnectorArchive(this.selectedConnectorName);
        FileUtils.write((byte[])bytes, (String)filename);
    }

    private void exportCDKFile(String filename) throws Exception {
        FileOutputStream fileOutput = new FileOutputStream(filename);
        XMLConfigurationImportExportUtility xmlUtil = new XMLConfigurationImportExportUtility();
        String userName = UserCapabilities.getLoggedInUser(this.connection).getName();
        String version = StaticProperties.getVersion();
        Properties props = new Properties();
        props.put("ApplicationCreatedBy", DeployPkgUtils.getString("dmp.console.name"));
        props.put("ApplicationVersion", version);
        props.put("UserCreatedBy", userName);
        ComponentType ct = this.getSelectedConnector(this.selectedConnectorName);
        xmlUtil.exportConnector((OutputStream)fileOutput, ct, props);
    }

    private boolean doImportWizard() {
        ImportWizardController controller = new ImportWizardController(this.connection);
        boolean bConnectorWasCreated = controller.runWizard();
        if (bConnectorWasCreated) {
            String newConnectorName = (String)controller.getLoadedTypes().firstKey();
            this.populateTable();
            this.forceTableSelection(newConnectorName);
        }
        return bConnectorWasCreated;
    }

    @Override
    public void receiveUpdateNotification(RuntimeUpdateNotification notification) {
    }

    @Override
    public void refresh() {
        String saveSelectedConnectorName = this.selectedConnectorName;
        this.populateTable();
        this.selectedConnectorName = saveSelectedConnectorName;
        int modelRowForSelectedConnector = this.modelRowForConnector(this.selectedConnectorName);
        if (modelRowForSelectedConnector < 0) {
            this.selectedConnectorName = null;
        }
        this.forceTableSelection(this.selectedConnectorName);
        this.table.sizeColumnsToFitData(100);
    }

    private int modelRowForConnector(String name) {
        int matchRow = -1;
        int numRows = this.tableModel.getRowCount();
        for (int row = 0; row < numRows && matchRow < 0; ++row) {
            String curName = this.tableModel.getValueAt(row, 0).toString();
            if (!curName.equals(name)) continue;
            matchRow = row;
            break;
        }
        return matchRow;
    }

    public void deletePressed() {
        String msg = "Delete connector " + this.selectedConnectorName + "?";
        int response = CenteredOptionPane.showConfirmDialog(ConsoleMainFrame.getInstance(), msg, "Confirm Deletion", 0);
        if (response == 0) {
            int currentModelIndex = this.modelRowForConnector(this.selectedConnectorName);
            int currentViewIndex = this.table.convertRowIndexToView(currentModelIndex);
            boolean continuing = true;
            try {
                this.manager.deleteConnector(this.selectedConnectorName);
                this.tableModel.removeRow(currentModelIndex);
            }
            catch (Exception ex) {
                ExceptionUtility.showMessage("Delete a Connector", ex);
                LogManager.logError((String)"CONNECTORS", (Throwable)ex, (String)"Error in deleting connector.");
                continuing = false;
            }
            if (continuing) {
                int numRows = this.tableModel.getRowCount();
                if (numRows > 0) {
                    if (currentViewIndex > numRows - 1) {
                        currentViewIndex = numRows - 1;
                    }
                    int newModelIndex = this.table.convertRowIndexToModel(currentViewIndex);
                    this.selectedConnectorName = this.tableModel.getValueAt(newModelIndex, 0).toString();
                } else {
                    this.selectedConnectorName = null;
                }
                this.forceTableSelection(this.selectedConnectorName);
            }
        }
    }

    private void tableSelectionChanged() {
        StaticUtilities.startWait(ViewManager.getMainFrame());
        int viewRow = this.table.getSelectedRow();
        int selectedRow = -1;
        if (viewRow >= 0) {
            selectedRow = this.table.convertRowIndexToModel(viewRow);
        }
        if (selectedRow >= 0) {
            String oldSelectedConnectorName = this.selectedConnectorName;
            if (selectedRow != this.selectedTableRow) {
                try {
                    this.selectedConnectorName = this.tableModel.getValueAt(selectedRow, 0).toString();
                }
                catch (Exception ex) {
                    ExceptionUtility.showMessage("Retrieve Details for Connector", ex);
                    LogManager.logError((String)"CONNECTORS", (Throwable)ex, (String)"Exception in retrieving details for connector.");
                    selectedRow = -1;
                }
                this.selectedTableRow = selectedRow;
                if (!this.selectedConnectorName.equals(oldSelectedConnectorName)) {
                    this.populateDetails(this.selectedConnectorName);
                }
                int numBindings = (Integer)this.tableModel.getValueAt(selectedRow, 1);
                this.actionDeleteConnector.setEnabled(this.canModify && numBindings == 0);
            }
        } else {
            this.selectedTableRow = -1;
            this.selectedConnectorName = null;
            this.populateDetails(null);
            this.actionDeleteConnector.setEnabled(false);
        }
        StaticUtilities.endWait(ViewManager.getMainFrame());
    }

    private void populateDetails(String selConnectorName) {
        String borderString = "";
        SimpleDateFormat formatter = StaticUtilities.getDefaultDateFormat();
        if (selConnectorName == null) {
            this.createdField.setText("");
            this.createdByField.setText("");
            this.registeredField.setText("");
            this.registeredByField.setText("");
        } else {
            ComponentType ct = null;
            try {
                ct = this.getSelectedConnector(selConnectorName);
            }
            catch (Exception e) {
                LogManager.logError((String)"CONNECTORS", (Throwable)e, (String)("Error populating connector details: " + selConnectorName));
            }
            this.createdField.setText(formatter.format(ct.getCreatedDate()));
            this.createdByField.setText(ct.getCreatedBy());
            this.registeredField.setText(formatter.format(ct.getLastChangedDate()));
            this.registeredByField.setText(ct.getLastChangedBy());
            borderString = "Details for " + ct.getName();
        }
        TitledBorder tBorder = new TitledBorder(borderString);
        this.detailsPanel.setBorder(tBorder);
        tBorder.setTitleFont(tBorder.getTitleFont().deriveFont(1));
    }

    private void populateTable() {
        try {
            this.infoInTable = this.manager.getConnectorBasics(true);
            if (this.infoInTable == null) {
                return;
            }
        }
        catch (Exception ex) {
            ExceptionUtility.showMessage("Retrieve list of existing connectors", ex);
            LogManager.logError((String)"CONNECTORS", (Throwable)ex, (String)"Exception in retrieving list of existing connectors.");
            return;
        }
        this.tableModel.setNumRows(0);
        for (int i = 0; i < this.infoInTable.length; ++i) {
            if (this.infoInTable[i] == null) continue;
            Vector<Object> vec = new Vector<Object>(Arrays.asList(null, null, null));
            vec.setElementAt(this.infoInTable[i].getName(), 0);
            vec.setElementAt(new Integer(this.infoInTable[i].getNumBindings()), 1);
            this.tableModel.addRow(vec);
        }
    }

    public static void setLocationOn(Component comp) {
        Point p = StaticUtilities.centerFrame(comp.getSize());
        comp.setLocation(p.x, p.y);
    }

    @Override
    public List resume() {
        this.refresh();
        return this.currentActions;
    }

    private void selectFirstConnector() {
        String connectorName;
        int modelRow;
        if (this.table.getRowCount() > 0 && (modelRow = this.table.convertRowIndexToModel(0)) >= 0 && (connectorName = (String)this.tableModel.getValueAt(modelRow, 0)) != null) {
            this.selectedConnectorName = connectorName;
            this.forceTableSelection(this.selectedConnectorName);
        }
    }

    private void forceTableSelection(String selConnectorName) {
        int modelRowForSelected = this.modelRowForConnector(selConnectorName);
        if (modelRowForSelected >= 0) {
            int viewRowForSelected = this.table.convertRowIndexToView(modelRowForSelected);
            this.table.getSelectionModel().setSelectionInterval(viewRowForSelected, viewRowForSelected);
            this.table.scrollRectToVisible(this.table.getCellRect(viewRowForSelected, 0, true));
        } else {
            this.tableSelectionChanged();
        }
        this.populateDetails(selConnectorName);
    }

    @Override
    public String getTitle() {
        return PANEL_NAME;
    }

    @Override
    public ConnectionInfo getConnection() {
        return this.connection;
    }

    private ComponentType getSelectedConnector(String connectorName) throws Exception {
        return this.manager.lookupConnector(connectorName);
    }

    class ConnectorExportChooserPanel
    extends DirectoryChooserPanel {
        public ConnectorExportChooserPanel(DirectoryEntryView directoryEntryView, int type, DirectoryEntryFilter[] filters) {
            super(directoryEntryView, type, filters);
        }

        @Override
        protected void createComponent() {
            super.createComponent();
            this.filterComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DirectoryEntryFilter selectedFilter = (DirectoryEntryFilter)ConnectorExportChooserPanel.this.filterComboBox.getSelectedItem();
                    String extension = selectedFilter.getExtension(0);
                    ConnectorExportChooserPanel.this.setInitialFilename(ConnectorPanel.this.selectedConnectorName + "." + extension);
                }
            });
        }
    }

    class PanelAction
    extends AbstractPanelAction {
        public static final int IMPORT_CONNECTOR = 0;
        public static final int DELETE_CONNECTOR = 1;
        public static final int EXPORT_CONNECTOR = 2;

        public PanelAction(int theType) {
            super(theType);
        }

        @Override
        public void actionImpl(ActionEvent theEvent) {
            if (this.type == 0) {
                ConnectorPanel.this.importPressed();
            } else if (this.type == 2) {
                ConnectorPanel.this.exportPressed();
            } else if (this.type == 1) {
                ConnectorPanel.this.deletePressed();
            }
        }
    }
}

