/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.connector;

import com.metamatrix.common.config.api.ConnectorBindingType;
import com.metamatrix.common.config.api.ExtensionModule;
import com.metamatrix.common.tree.directory.DirectoryEntry;
import com.metamatrix.console.ui.util.BasicWizardSubpanelContainer;
import com.metamatrix.console.ui.util.WizardInterface;
import com.metamatrix.console.ui.util.property.GuiComponentFactory;
import com.metamatrix.console.ui.util.property.TypeConstants;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.TextFieldWidget;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.net.MalformedURLException;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractButton;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ImportWizardConnectorIDPanel
extends BasicWizardSubpanelContainer
implements ComponentListener,
TypeConstants {
    private int callType;
    private TextFieldWidget[] txfItemName;
    private boolean hasBeenPainted = false;
    private Map connectorTypesToImport;
    ExtensionModule[] extensionModulesToImport;
    JPanel pnlOuter = new JPanel();
    private DirectoryEntry prevDirEntry;

    public ImportWizardConnectorIDPanel(WizardInterface wizardInterface, int callType) {
        super(wizardInterface);
        this.callType = callType;
        this.init();
    }

    private void init() {
        String lblText = this.callType == 1 ? "Connector Name: " : "Connector Binding:";
        this.pnlOuter.setLayout(new GridBagLayout());
        int index = 0;
        if (this.connectorTypesToImport != null) {
            this.pnlOuter.removeAll();
            this.txfItemName = new TextFieldWidget[this.connectorTypesToImport.keySet().size()];
            Iterator i = this.connectorTypesToImport.keySet().iterator();
            while (i.hasNext()) {
                this.txfItemName[index] = GuiComponentFactory.createTextField("connectortypename");
                this.txfItemName[index].setPreferredSize(new Dimension(225, 21));
                this.txfItemName[index].setText((String)i.next());
                this.pnlOuter.add((Component)new LabelWidget(lblText), new GridBagConstraints(0, index, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 0), 5, 4));
                this.pnlOuter.add((Component)this.txfItemName[index], new GridBagConstraints(1, index, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 1), 5, 4));
                ++index;
            }
        }
        if (this.extensionModulesToImport != null && this.extensionModulesToImport.length > 0) {
            for (int i = 0; i < this.extensionModulesToImport.length; ++i) {
                TextFieldWidget txfItemName = new TextFieldWidget(this.extensionModulesToImport[i].getFullName());
                txfItemName.setEditable(false);
                this.pnlOuter.add((Component)new LabelWidget("Extension Module:"), new GridBagConstraints(0, index, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 0), 5, 4));
                this.pnlOuter.add((Component)txfItemName, new GridBagConstraints(1, index, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 1), 5, 4));
                ++index;
            }
        }
        this.pnlOuter.add((Component)new JPanel(), new GridBagConstraints(0, index, 0, 0, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.setMainContent(this.pnlOuter);
        String stepText = this.callType == 1 ? "Specify or Modify a Name for this Connector(s)." : "Specify a Name for this Connector Binding.";
        this.setStepText(2, stepText);
    }

    public void setupListening() {
        DocumentListener listener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent de) {
                ImportWizardConnectorIDPanel.this.resolveForwardButton();
            }

            @Override
            public void insertUpdate(DocumentEvent de) {
                ImportWizardConnectorIDPanel.this.resolveForwardButton();
            }

            @Override
            public void removeUpdate(DocumentEvent de) {
                ImportWizardConnectorIDPanel.this.resolveForwardButton();
            }
        };
        for (int i = 0; i < this.txfItemName.length; ++i) {
            this.txfItemName[i].getDocument().addDocumentListener(listener);
        }
        this.addComponentListener(this);
    }

    @Override
    public void resolveForwardButton() {
        AbstractButton forwardButton = this.getWizardInterface().getForwardButton();
        boolean enable = false;
        for (int i = 0; i < this.txfItemName.length; ++i) {
            if (this.txfItemName[i].getText().trim().equals("")) continue;
            enable = true;
        }
        forwardButton.setEnabled(enable);
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        this.setInitialPostRealizeState();
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.setInitialPostRealizeState();
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.setInitialPostRealizeState();
    }

    @Override
    public void componentHidden(ComponentEvent e) {
        this.setInitialPostRealizeState();
    }

    public void setInitialPostRealizeState() {
        this.removeComponentListener(this);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (!this.hasBeenPainted) {
            this.hasBeenPainted = true;
            this.txfItemName[0].requestFocus();
        }
    }

    public void setConnectorTypes(DirectoryEntry dirEntry, Map connectorTypes) {
        boolean build = true;
        if (this.connectorTypesToImport == null) {
            this.prevDirEntry = dirEntry;
        } else {
            try {
                build = !dirEntry.toURL().equals(this.prevDirEntry.toURL());
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        if (build) {
            this.prevDirEntry = dirEntry;
            this.connectorTypesToImport = connectorTypes;
            this.init();
            this.setupListening();
            this.resolveForwardButton();
        }
    }

    public void setExtensionModules(ExtensionModule[] modules) {
        this.extensionModulesToImport = modules;
    }

    public TreeMap getConnectorTypes() {
        TreeMap<String, ConnectorBindingType> map = new TreeMap<String, ConnectorBindingType>();
        int index = 0;
        Iterator i = this.connectorTypesToImport.keySet().iterator();
        while (i.hasNext()) {
            String newCTypeName = this.txfItemName[index].getText();
            if (newCTypeName != null) {
                newCTypeName = newCTypeName.trim();
            }
            ConnectorBindingType cType = (ConnectorBindingType)this.connectorTypesToImport.get(i.next());
            if (newCTypeName != null && newCTypeName.length() > 0) {
                map.put(newCTypeName, cType);
            }
            ++index;
        }
        return map;
    }
}

