/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.connector;

import com.metamatrix.console.ConsolePlugin;
import com.metamatrix.console.ui.util.BasicWizardSubpanelContainer;
import com.metamatrix.console.ui.util.WizardInterface;
import com.metamatrix.console.ui.views.connector.ImportWizardController;
import com.metamatrix.toolbox.ui.widget.CheckBox;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.TextFieldWidget;
import com.metamatrix.toolbox.ui.widget.text.DefaultTextFieldModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ImportWizardDuplicatesPanel
extends BasicWizardSubpanelContainer {
    private static final String OVERWRITE_CONN_TYPES = ConsolePlugin.Util.getString("ImportWizardDuplicatesPanel.OverwriteConnTypes");
    private static final String OVERWRITE_EXT_JARS = ConsolePlugin.Util.getString("ImportWizardDuplicatesPanel.OverwriteExtJars");
    private JPanel pnlOuter;
    private int stepNumber = 3;
    private String[] duplicateConnectorTypes;
    private String[] duplicateExtensionModules;
    private CheckBox overwriteConnTypes;
    private CheckBox overwriteExtJars;
    private String errorConnectorTypeInUseText;

    public ImportWizardDuplicatesPanel(ImportWizardController cntrlr, WizardInterface wizardInterface) {
        super(wizardInterface);
        this.init();
    }

    private void init() {
        this.pnlOuter = new JPanel();
        this.pnlOuter.setLayout(new GridBagLayout());
        this.setMainContent(this.pnlOuter);
        this.refresh();
    }

    private void refresh() {
        this.pnlOuter.removeAll();
        Font defaultFont = new LabelWidget().getFont();
        Font boldFont = new Font(defaultFont.getName(), 1, defaultFont.getSize());
        boolean hasDuplicateConnTypes = this.duplicateConnectorTypes != null && this.duplicateConnectorTypes.length > 0;
        boolean hasDuplicateExtJars = this.duplicateExtensionModules != null && this.duplicateExtensionModules.length > 0;
        int index = 0;
        if (!this.hasInUseError() && (hasDuplicateConnTypes || hasDuplicateExtJars)) {
            TextFieldWidget txfItemName;
            int i;
            LabelWidget label2;
            LabelWidget label1;
            if (hasDuplicateConnTypes) {
                LabelWidget connTypeLabel = new LabelWidget("Duplicate Connector Types:");
                connTypeLabel.setFont(boldFont);
                this.pnlOuter.add((Component)connTypeLabel, new GridBagConstraints(0, index, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 5, 0), 5, 4));
                label1 = new LabelWidget("Before proceeding, you must either choose to overwrite the existing server");
                label2 = new LabelWidget("connector types (see option checkbox) or press 'Back' and rename them.");
                this.pnlOuter.add((Component)label1, new GridBagConstraints(0, ++index, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 0, 0), 5, 4));
                this.pnlOuter.add((Component)label2, new GridBagConstraints(0, ++index, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 5, 0), 5, 4));
                ++index;
                for (i = 0; i < this.duplicateConnectorTypes.length; ++i) {
                    txfItemName = new TextFieldWidget(this.duplicateConnectorTypes[i]);
                    txfItemName.setEditable(false);
                    this.pnlOuter.add((Component)txfItemName, new GridBagConstraints(0, index, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 1), 5, 4));
                    ++index;
                }
            }
            if (hasDuplicateExtJars) {
                LabelWidget extJarLabel = new LabelWidget("Duplicate Extension Modules:");
                extJarLabel.setFont(boldFont);
                this.pnlOuter.add((Component)extJarLabel, new GridBagConstraints(0, index, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 5, 0), 5, 4));
                label1 = new LabelWidget("Choose to overwrite the existing server extension modules with the incoming");
                label2 = new LabelWidget("modules, or leave the existing server modules (see option checkbox)");
                this.pnlOuter.add((Component)label1, new GridBagConstraints(0, ++index, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 0, 0), 5, 4));
                this.pnlOuter.add((Component)label2, new GridBagConstraints(0, ++index, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 5, 0), 5, 4));
                ++index;
                for (i = 0; i < this.duplicateExtensionModules.length; ++i) {
                    txfItemName = new TextFieldWidget(this.duplicateExtensionModules[i]);
                    txfItemName.setEditable(false);
                    this.pnlOuter.add((Component)txfItemName, new GridBagConstraints(0, index, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 0), 5, 4));
                    ++index;
                }
            }
            LabelWidget optionLabel = new LabelWidget("Options:");
            optionLabel.setFont(boldFont);
            this.pnlOuter.add((Component)optionLabel, new GridBagConstraints(0, index, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 5, 0), 5, 4));
            ++index;
            if (hasDuplicateConnTypes) {
                this.overwriteConnTypes = new CheckBox(OVERWRITE_CONN_TYPES);
                this.pnlOuter.add((Component)this.overwriteConnTypes, new GridBagConstraints(0, index, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 5, 5, 0), 5, 4));
                ++index;
            }
            if (hasDuplicateExtJars) {
                this.overwriteExtJars = new CheckBox(OVERWRITE_EXT_JARS);
                this.pnlOuter.add((Component)this.overwriteExtJars, new GridBagConstraints(0, index, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 5, 5, 0), 5, 4));
                ++index;
            }
            this.pnlOuter.add((Component)new JPanel(), new GridBagConstraints(0, index, 0, 0, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.listenToCheckboxes();
        } else {
            String text = "No Duplicates or Conflicts in Connector Types/Extension Modules were found.";
            if (this.errorConnectorTypeInUseText != null) {
                LabelWidget errorLabel = new LabelWidget("Unable to Proceed:");
                errorLabel.setFont(boldFont);
                this.pnlOuter.add((Component)errorLabel, new GridBagConstraints(0, index, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 5, 0), 5, 4));
                ++index;
                text = "Unable to proceed, since the following connector types are in use by the bindings indicated. To resolve, you can \n(1) cancel the import and remove the binding associations, or \n(2) go to previous step and rename the incoming binding type\n" + this.errorConnectorTypeInUseText;
            }
            DefaultTextFieldModel model = new DefaultTextFieldModel();
            model.setMaximumLength(4096);
            JPanel panel = new JPanel();
            JScrollPane scroll = new JScrollPane();
            JTextArea pane = new JTextArea(model);
            pane.setText(text);
            pane.setColumns(40);
            pane.setRows(8);
            pane.setPreferredSize(new Dimension(40, 10));
            pane.setLineWrap(true);
            pane.setWrapStyleWord(true);
            pane.setEditable(false);
            scroll.setViewportView(pane);
            panel.add((Component)scroll, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 1, new Insets(2, 0, 2, 0), 0, 0));
            this.pnlOuter.add((Component)panel, new GridBagConstraints(0, index, 0, 0, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        }
        this.setStepText(this.stepNumber, "Resolve Duplicate Connector Types and Extension Modules.");
    }

    public void setStepNumber(int number) {
        this.stepNumber = number;
        this.refresh();
    }

    public void setDuplicateConnectorTypes(String[] list) {
        this.duplicateConnectorTypes = list;
    }

    public void setDuplicateExtensionModules(String[] list) {
        this.duplicateExtensionModules = list;
    }

    public List getDuplicateExtensionModules() {
        ArrayList<String> dupList = Collections.EMPTY_LIST;
        if (this.duplicateExtensionModules != null && this.duplicateExtensionModules.length > 0) {
            dupList = new ArrayList<String>(this.duplicateExtensionModules.length);
            for (int i = 0; i < this.duplicateExtensionModules.length; ++i) {
                dupList.add(this.duplicateExtensionModules[i]);
            }
        }
        return dupList;
    }

    public boolean isOverwriteConnTypesPressed() {
        if (this.overwriteConnTypes != null) {
            return this.overwriteConnTypes.isSelected();
        }
        return false;
    }

    public boolean isOverwriteExtJarsPressed() {
        if (this.overwriteExtJars != null) {
            return this.overwriteExtJars.isSelected();
        }
        return false;
    }

    public void setErrorText(String text) {
        this.errorConnectorTypeInUseText = text;
    }

    private boolean hasInUseError() {
        return this.errorConnectorTypeInUseText != null && this.errorConnectorTypeInUseText.length() > 0;
    }

    @Override
    public void resolveForwardButton() {
        AbstractButton forwardButton = this.getWizardInterface().getForwardButton();
        boolean hasConnTypeDuplicates = this.duplicateConnectorTypes != null && this.duplicateConnectorTypes.length > 0;
        boolean connTypesResolved = !hasConnTypeDuplicates || hasConnTypeDuplicates && this.isOverwriteConnTypesPressed();
        boolean enable = !this.hasInUseError() && connTypesResolved;
        forwardButton.setEnabled(enable);
    }

    private void listenToCheckboxes() {
        if (this.overwriteConnTypes != null) {
            this.overwriteConnTypes.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    ImportWizardDuplicatesPanel.this.resolveForwardButton();
                }
            });
        }
        if (this.overwriteExtJars != null) {
            this.overwriteExtJars.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    ImportWizardDuplicatesPanel.this.resolveForwardButton();
                }
            });
        }
    }
}

