/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.connector;

import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.tree.TreeNode;
import com.metamatrix.common.tree.directory.DirectoryEntry;
import com.metamatrix.common.tree.directory.DirectoryEntryFilter;
import com.metamatrix.common.tree.directory.DirectoryEntryView;
import com.metamatrix.common.tree.directory.FileSystemFilter;
import com.metamatrix.common.tree.directory.FileSystemView;
import com.metamatrix.console.ui.util.BasicWizardSubpanelContainer;
import com.metamatrix.console.ui.util.MDCPOpenStateListener;
import com.metamatrix.console.ui.util.ModifiedDirectoryChooserPanel;
import com.metamatrix.console.ui.util.WizardInterface;
import com.metamatrix.console.ui.views.connector.ImportWizardControllerInterface;
import com.metamatrix.toolbox.preference.UserPreferences;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.TextFieldWidget;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import javax.swing.JPanel;

public class ImportWizardFileSelectorPanel
extends BasicWizardSubpanelContainer
implements ComponentListener,
MDCPOpenStateListener {
    private static final String CAF_FILE_DESC = "Connector Archive (*.caf)";
    private static final String CDK_FILE_DESC = "Connector Types (*.cdk, *.xml)";
    private static final String CONNECTOR_BINDING_FILE_DESC = "Connector Bindings (*.cdk, *.xml, *.def)";
    private static final String[] CAF_EXTENSIONS = new String[]{"caf"};
    private static final String[] CDK_EXTENSIONS = new String[]{"cdk", "xml"};
    private static final String[] CONNECTOR_BINDING_EXTENSIONS = new String[]{"cdk", "xml", "def"};
    private int callType;
    private ImportWizardControllerInterface controller;
    private FileSystemView fsvFileSysView = new FileSystemView();
    private DirectoryEntry selection;
    private ModifiedDirectoryChooserPanel chooser;
    private JPanel pnlOuter = new JPanel();
    private LabelWidget lblName;
    private TextFieldWidget txfConnectorName = new TextFieldWidget();
    boolean fileSelectionValid = false;

    public ImportWizardFileSelectorPanel(ImportWizardControllerInterface cntrlr, WizardInterface wizardInterface, int callType) {
        super(wizardInterface);
        this.controller = cntrlr;
        this.callType = callType;
        this.init();
    }

    private void init() {
        String lblText = this.callType == 1 ? "Connector Name:" : "Connector Binding Name:";
        this.lblName = new LabelWidget(lblText);
        try {
            String sInitialDir = this.getDefaultDirectory();
            this.fsvFileSysView.setHome((TreeNode)this.fsvFileSysView.lookup(sInitialDir));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.chooser = new ModifiedDirectoryChooserPanel((DirectoryEntryView)this.fsvFileSysView, 0, (DirectoryEntryFilter[])this.getFileFilters(), this);
        this.chooser.setPreferredSize(new Dimension(475, 400));
        this.chooser.getAcceptButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ImportWizardFileSelectorPanel.this.acceptPressed();
            }
        });
        this.chooser.setShowAcceptButton(false);
        this.chooser.setAllowFolderCreation(false);
        this.chooser.getCancelButton().setVisible(false);
        this.pnlOuter.setLayout(new GridBagLayout());
        this.pnlOuter.add((Component)this.lblName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 5, 0), 5, 4));
        this.pnlOuter.add((Component)this.txfConnectorName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 1), 5, 0));
        this.pnlOuter.add((Component)this.chooser, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 17, 2, new Insets(25, 0, 0, 1), 5, 0));
        this.addComponentListener(this);
        this.setMainContent(this.chooser);
        this.setStepText(1, "Select the file containing the connector definition to be imported.");
    }

    @Override
    public void fileSelectionIsValid(boolean flag) {
        this.fileSelectionValid = flag;
        this.enableForwardButton(this.fileSelectionValid);
    }

    private String getDefaultDirectory() {
        String sDefaultDir = (String)UserPreferences.getInstance().getValue("metamatrix.console.directory");
        return sDefaultDir;
    }

    private void saveSelectedDirectoryAsDefault() {
        DirectoryEntry deResult = (DirectoryEntry)this.chooser.getSelectedTreeNode();
        String fileName = deResult.getNamespace();
        int index = fileName.lastIndexOf(File.separatorChar);
        String path = fileName.substring(0, index);
        try {
            UserPreferences.getInstance().setValue("metamatrix.console.directory", path);
            UserPreferences.getInstance().saveChanges();
        }
        catch (Exception ex) {
            LogManager.logError((String)"CONNECTORS", (Throwable)ex, (String)"Error attempting to save UserPreference for metamatrix.console.directory");
        }
    }

    private FileSystemFilter[] getFileFilters() {
        FileSystemFilter[] filters = null;
        if (this.callType == 1) {
            FileSystemFilter filterCAF = new FileSystemFilter(this.fsvFileSysView, CAF_EXTENSIONS, CAF_FILE_DESC);
            FileSystemFilter filterCDK = new FileSystemFilter(this.fsvFileSysView, CDK_EXTENSIONS, CDK_FILE_DESC);
            filters = new FileSystemFilter[]{filterCAF, filterCDK};
        } else {
            FileSystemFilter filter = new FileSystemFilter(this.fsvFileSysView, CONNECTOR_BINDING_EXTENSIONS, CONNECTOR_BINDING_FILE_DESC);
            filters = new FileSystemFilter[]{filter};
        }
        return filters;
    }

    public DirectoryEntry getSelection() {
        this.acceptPressed();
        return this.selection;
    }

    private void acceptPressed() {
        this.selection = (DirectoryEntry)this.chooser.getSelectedTreeNode();
        this.controller.importFileSelected();
        this.saveSelectedDirectoryAsDefault();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        this.setInitialPostRealizeState();
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.setInitialPostRealizeState();
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.setInitialPostRealizeState();
    }

    @Override
    public void componentHidden(ComponentEvent e) {
        this.setInitialPostRealizeState();
    }

    public void setInitialPostRealizeState() {
        this.enableForwardButton(false);
        this.removeComponentListener(this);
    }

    @Override
    public void resolveForwardButton() {
        this.enableForwardButton(this.fileSelectionValid);
    }
}

