/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.connectorbinding;

import com.metamatrix.common.actions.ModificationActionQueue;
import com.metamatrix.common.config.api.ComponentDefnID;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationObjectEditor;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.config.api.ServiceComponentDefn;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.object.PropertiedObject;
import com.metamatrix.common.object.PropertiedObjectEditor;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.ConnectorManager;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.ui.layout.ConsoleMainFrame;
import com.metamatrix.console.ui.util.POPWithButtons;
import com.metamatrix.console.ui.util.POPWithButtonsController;
import com.metamatrix.console.ui.util.PropertiedObjectPanelHolder;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.TextFieldWidget;
import com.metamatrix.toolbox.ui.widget.property.PropertiedObjectPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JPanel;

public class BindingPropertiesPanel
extends JPanel
implements POPWithButtonsController {
    private PropertiedObjectPanel pop;
    private PropertiedObjectPanelHolder popHolder;
    private POPWithButtons popWithButtons = null;
    private TextFieldWidget txfConnectorName = new TextFieldWidget();
    private LabelWidget lblConnectorName = new LabelWidget();
    private TextFieldWidget txfBindingName = new TextFieldWidget();
    private LabelWidget lblBindingName = new LabelWidget();
    private JPanel pnlOuter = new JPanel();
    private JPanel pnlPOPShell = new JPanel(new GridLayout(1, 1));
    private PropertiedObject poPropObject;
    private PropertiedObjectEditor poe;
    private ServiceComponentDefn connectorBindingDefn;
    private boolean canModify;
    private ConnectionInfo connection;
    private ModificationActionQueue maq = null;
    private ConfigurationObjectEditor coe = null;

    public BindingPropertiesPanel(boolean modifiable, ConnectionInfo connection) {
        this.canModify = modifiable;
        this.connection = connection;
        this.init();
        try {
            this.coe = this.getConnectorManager().getConnectorBindingEditor();
            this.maq = this.coe.getDestination();
            this.poe = this.getConnectorManager().getPropertiedObjectEditor(this.maq);
        }
        catch (Exception ex) {
            LogManager.logError((String)"CONNECTOR_BINDINGS", (Throwable)ex, (String)"Error creating Connector Binding Properties Panel.");
            ExceptionUtility.showMessage("Error creating Connector Binding Properties Panel", ex);
        }
    }

    private ConnectorManager getConnectorManager() {
        return ModelManager.getConnectorManager(this.connection);
    }

    private void init() {
        this.pnlPOPShell.setPreferredSize(new Dimension(200, 300));
        this.setLayout(new BorderLayout());
        this.pnlOuter.setLayout(new GridBagLayout());
        this.lblBindingName.setText("Binding Name:");
        this.lblConnectorName.setText("Connector Type:");
        this.txfBindingName.setEditable(false);
        this.txfConnectorName.setEditable(false);
        this.add((Component)this.pnlPOPShell, "Center");
    }

    private PropertiedObjectEditor getPropertiedObjectEditor() {
        if (this.poe == null) {
            try {
                this.poe = this.getConnectorManager().getPropertiedObjectEditor();
            }
            catch (Exception e) {
                ExceptionUtility.showMessage("Failed to get editor for Binding propd panel  ", e);
            }
        }
        return this.poe;
    }

    private PropertiedObjectPanel getPropertiedObjectPanel() {
        if (this.pop == null) {
            try {
                StaticUtilities.startWait(ConsoleMainFrame.getInstance());
                this.poe = this.getPropertiedObjectEditor();
                this.pop = new PropertiedObjectPanel(this.poe, this.getConnectorManager().getEncryptor());
            }
            catch (RuntimeException ex) {
                StaticUtilities.endWait(ConsoleMainFrame.getInstance());
                throw ex;
            }
            StaticUtilities.endWait(ConsoleMainFrame.getInstance());
        }
        return this.pop;
    }

    private void populateTable() {
        try {
            StaticUtilities.startWait(ConsoleMainFrame.getInstance());
            if (this.connectorBindingDefn == null) {
                this.pnlPOPShell.removeAll();
            } else {
                this.updatePropertiedObjectPanel();
            }
        }
        catch (RuntimeException ex) {
            StaticUtilities.endWait(ConsoleMainFrame.getInstance());
            ExceptionUtility.showMessage("Failed in populateTable", ex);
        }
        StaticUtilities.endWait(ConsoleMainFrame.getInstance());
    }

    public void setConnectorBinding(ServiceComponentDefn connectorBindingDefn) {
        this.connectorBindingDefn = connectorBindingDefn;
        this.populateTable();
    }

    public ServiceComponentDefn getConnectorBinding() {
        return this.connectorBindingDefn;
    }

    public void updatePropertiedObjectPanel() {
        ServiceComponentDefn connectorBindingDefn = this.getConnectorBinding();
        try {
            this.poPropObject = this.getConnectorManager().getPropertiedObject(connectorBindingDefn);
            this.getPropertiedObjectPanel().setNameColumnHeaderWidth(0);
            this.getPropertiedObjectPanel().setPropertiedObject(this.poPropObject, this.poe);
            this.poe.setReadOnly(this.poPropObject, false);
            this.getPropertiedObjectPanel().setShowRequiredProperties(true);
            this.getPropertiedObjectPanel().setShowInvalidProperties(true);
            this.getPropertiedObjectPanel().setShowHiddenProperties(false);
            this.getPropertiedObjectPanel().setShowExpertProperties(true);
            this.getPropertiedObjectPanel().setShowOptionalProperties(false);
            if (!this.canModify) {
                this.getPropertiedObjectPanel().setReadOnlyForced(true);
            }
            this.getPropertiedObjectPanel().createComponent();
            this.getPropertiedObjectPanel().refreshDisplay();
            boolean includeOptional = false;
            if (this.popHolder != null) {
                includeOptional = this.popHolder.isIncludingOptionalProperties();
            }
            this.pnlPOPShell.removeAll();
            ItemListener includeOptionalListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent ev) {
                    BindingPropertiesPanel.this.includeOptionalStateChanged();
                }
            };
            this.popHolder = new PropertiedObjectPanelHolder(this.pop, includeOptionalListener);
            this.popWithButtons = new POPWithButtons(this.popHolder, this.poe, (POPWithButtonsController)this);
            this.pnlPOPShell.add(this.popWithButtons);
            this.popHolder.setIsIncludingOptionalProperties(includeOptional);
        }
        catch (Exception e) {
            ExceptionUtility.showMessage("Failed while creating Connector Binding Panel", e);
        }
    }

    private void includeOptionalStateChanged() {
        this.getPropertiedObjectPanel().setShowOptionalProperties(this.popHolder.isIncludingOptionalProperties());
        this.getPropertiedObjectPanel().refreshDisplay();
    }

    public ServiceComponentDefn getNewConnectorBinding() {
        return this.connectorBindingDefn;
    }

    @Override
    public boolean doApplyChanges(PropertiedObjectPanel pop) {
        boolean proceeding = true;
        try {
            StaticUtilities.displayModalDialogWithOK("Modify Connector Binding", "Note: Change will not take effect until connector is restarted in the System State panel.");
            this.getConnectorManager().saveConnectorBinding(this.maq);
            ConnectorBinding cb = (ConnectorBinding)this.getConnectorManager().getConfigurationAdminAPI().getComponentDefn(Configuration.NEXT_STARTUP_ID, (ComponentDefnID)this.connectorBindingDefn.getID());
            this.setConnectorBinding((ServiceComponentDefn)cb);
        }
        catch (Exception ex) {
            LogManager.logError((String)"CONNECTOR_BINDINGS", (Throwable)ex, (String)"Error saving connector binding changes.");
            ExceptionUtility.showMessage("Error saving connector binding changes", ex);
        }
        return proceeding;
    }

    public void applyProperties() {
        if (this.popWithButtons != null) {
            this.popWithButtons.applyPressed();
        }
    }

    public void resetProperties() {
        if (this.popWithButtons != null) {
            this.popWithButtons.resetPressed();
        }
    }

    public boolean anyValueChanged() {
        if (this.popWithButtons == null) {
            return false;
        }
        return this.popWithButtons.anyValueChanged();
    }
}

