/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.connectorbinding;

import com.metamatrix.common.config.api.ServiceComponentDefn;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.models.VdbManager;
import com.metamatrix.console.ui.layout.BasePanel;
import com.metamatrix.console.ui.views.connectorbinding.BindingVDBInfo;
import com.metamatrix.console.ui.views.connectorbinding.BindingVDBsTableModel;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.metadata.runtime.api.Model;
import com.metamatrix.metadata.runtime.api.VirtualDatabase;
import com.metamatrix.metadata.runtime.api.VirtualDatabaseID;
import com.metamatrix.toolbox.ui.widget.TableWidget;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.table.TableModel;

public class BindingVDBsPanel
extends BasePanel {
    public static final int VDB_COL_NUM = 0;
    public static final int VDB_VERSION_COL_NUM = 1;
    public static final int MODEL_COL_NUM = 2;
    public static final int MODEL_VERSION_COL_NUM = 3;
    public static final int BOUND_COL_NUM = 4;
    public static final int BOUND_BY_COL_NUM = 5;
    private TableWidget table;
    private BindingVDBsTableModel tableModel;
    private ServiceComponentDefn connectorBindingDefn;
    private ConnectionInfo connection;

    public BindingVDBsPanel(ConnectionInfo connection) {
        this.connection = connection;
        this.init();
    }

    private VdbManager getVdbManager() {
        return ModelManager.getVdbManager(this.connection);
    }

    private void init() {
        this.tableModel = new BindingVDBsTableModel(new Vector<String>(Arrays.asList("VDB", "VDB Version", "Model")));
        this.table = new TableWidget((TableModel)this.tableModel, true);
        this.table.setEditable(false);
        this.table.setSortable(true);
        JScrollPane tableSP = new JScrollPane(this.table);
        this.add(tableSP);
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        layout.setConstraints(tableSP, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void populateTable() {
        boolean continuing = true;
        if (this.connectorBindingDefn == null) {
            this.tableModel.setNumRows(0);
        } else {
            BindingVDBInfo[] info = null;
            try {
                info = this.getBindingInfo(this.connectorBindingDefn);
            }
            catch (Exception ex) {
                ExceptionUtility.showMessage("Retrieve VDB info for Connector Binding", ex);
                LogManager.logError((String)"CONNECTOR_BINDINGS", (Throwable)ex, (String)"Error retrieving VDB info for connector binding.");
                continuing = false;
            }
            if (continuing) {
                this.tableModel.setNumRows(0);
                for (int i = 0; i < info.length; ++i) {
                    Vector<Object> vec = new Vector<Object>(Arrays.asList(null, null, null, null, null));
                    vec.setElementAt(info[i].getVDB(), 0);
                    vec.setElementAt(new Integer(info[i].getVDBVersion()), 1);
                    vec.setElementAt(info[i].getModel(), 2);
                    this.tableModel.addRow(vec);
                }
            }
        }
    }

    private BindingVDBInfo[] getBindingInfo(ServiceComponentDefn scdBinding) {
        Collection colVdbs = null;
        int iCount = 0;
        try {
            colVdbs = this.getVdbManager().getVDBsForConnectorBinding(scdBinding.getRoutingUUID());
        }
        catch (Exception e) {
            ExceptionUtility.showMessage("Failed loading VBDs panel", e);
        }
        Vector<BindingVDBInfo> vModels = new Vector<BindingVDBInfo>();
        for (VirtualDatabase vdbTemp : colVdbs) {
            Collection colModels = this.getModelsForVdb(vdbTemp);
            Iterator itModels = colModels.iterator();
            block3: while (itModels.hasNext()) {
                ++iCount;
                Model vdbmodelTemp = (Model)itModels.next();
                String sModelCBName2 = "";
                List names = vdbmodelTemp.getConnectorBindingNames();
                if (names == null || names.size() <= 0) continue;
                for (String sModelCBName2 : names) {
                    String ruuid;
                    if (sModelCBName2 == null || !sModelCBName2.equals(ruuid = scdBinding.getRoutingUUID())) continue;
                    BindingVDBInfo bindinfo = new BindingVDBInfo(vdbTemp.getName(), Integer.parseInt(this.getVdbVersion(vdbTemp)), vdbmodelTemp.getName(), new Integer(0), new Date(), "");
                    vModels.add(bindinfo);
                    continue block3;
                }
            }
        }
        BindingVDBInfo[] aryBindingInfo = new BindingVDBInfo[vModels.size()];
        vModels.toArray(aryBindingInfo);
        return aryBindingInfo;
    }

    private Collection getModelsForVdb(VirtualDatabase vdb) {
        Collection colModels = null;
        try {
            colModels = this.getVdbManager().getVdbModels((VirtualDatabaseID)vdb.getID());
        }
        catch (Exception e) {
            ExceptionUtility.showMessage("Failed retrieving models for a vdb", e);
        }
        return colModels;
    }

    private String getVdbVersion(VirtualDatabase vdb) {
        VirtualDatabaseID vdbid = (VirtualDatabaseID)vdb.getID();
        return vdbid.getVersion();
    }

    public void setConnectorBinding(ServiceComponentDefn connectorBindingDefn) {
        this.connectorBindingDefn = connectorBindingDefn;
        this.populateTable();
    }

    public ServiceComponentDefn getConnectorBinding() {
        return this.connectorBindingDefn;
    }
}

