/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.connectorbinding;

import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.config.api.ServiceComponentDefn;
import com.metamatrix.common.config.xml.XMLConfigurationImportExportUtility;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.tree.TreeNode;
import com.metamatrix.common.tree.directory.DirectoryEntry;
import com.metamatrix.common.tree.directory.DirectoryEntryFilter;
import com.metamatrix.common.tree.directory.DirectoryEntryView;
import com.metamatrix.common.tree.directory.FileSystemFilter;
import com.metamatrix.common.tree.directory.FileSystemView;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.ConfigurationManager;
import com.metamatrix.console.models.ConnectorManager;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.models.RuntimeMgmtManager;
import com.metamatrix.console.models.VdbManager;
import com.metamatrix.console.notification.AddedConnectorBindingNotification;
import com.metamatrix.console.notification.RuntimeUpdateNotification;
import com.metamatrix.console.security.UserCapabilities;
import com.metamatrix.console.ui.ViewManager;
import com.metamatrix.console.ui.layout.BasePanel;
import com.metamatrix.console.ui.layout.ConsoleMainFrame;
import com.metamatrix.console.ui.layout.MenuEntry;
import com.metamatrix.console.ui.layout.WorkspacePanel;
import com.metamatrix.console.ui.util.AbstractPanelAction;
import com.metamatrix.console.ui.util.CenteredOptionPane;
import com.metamatrix.console.ui.views.connectorbinding.BindingDetailsPanel;
import com.metamatrix.console.ui.views.connectorbinding.BindingPropertiesPanel;
import com.metamatrix.console.ui.views.connectorbinding.BindingVDBsPanel;
import com.metamatrix.console.ui.views.connectorbinding.ConnectorAndBinding;
import com.metamatrix.console.ui.views.connectorbinding.ConnectorBindingPanelAction;
import com.metamatrix.console.ui.views.connectorbinding.ConnectorBindingRenameDialog;
import com.metamatrix.console.ui.views.connectorbinding.ImportBindingWizardController;
import com.metamatrix.console.ui.views.connectorbinding.NewBindingWizardController;
import com.metamatrix.console.ui.views.deploy.event.ConfigurationChangeEvent;
import com.metamatrix.console.ui.views.deploy.event.ConfigurationChangeListener;
import com.metamatrix.console.ui.views.deploy.util.DeployPkgUtils;
import com.metamatrix.console.util.DialogUtility;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.Refreshable;
import com.metamatrix.console.util.StaticProperties;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.metadata.runtime.model.BasicVirtualDatabase;
import com.metamatrix.toolbox.preference.UserPreferences;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.DialogWindow;
import com.metamatrix.toolbox.ui.widget.DirectoryChooserPanel;
import com.metamatrix.toolbox.ui.widget.Splitter;
import com.metamatrix.toolbox.ui.widget.TableWidget;
import com.metamatrix.toolbox.ui.widget.TitledBorder;
import com.metamatrix.toolbox.ui.widget.table.DefaultTableComparator;
import com.metamatrix.toolbox.ui.widget.table.DefaultTableModel;
import com.metamatrix.toolbox.ui.widget.table.EnhancedTableColumn;
import com.metamatrix.toolbox.ui.widget.table.EnhancedTableColumnModel;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class ConnectorBindingPanel
extends BasePanel
implements ConfigurationChangeListener,
WorkspacePanel,
Refreshable {
    public static final int CONNECTOR_BINDING_COL_NUM = 0;
    public static final int CONNECTOR_COL_NUM = 1;
    public static final int DESCRIPTION_COL_NUM = 2;
    public static final int DETAILS_TAB_NUM = 0;
    public static final int PROPERTIES_TAB_NUM = 1;
    public static final int VDBS_TAB_NUM = 2;
    private ConnectorBindingPanelAction actionNewConnectorBinding;
    private ConnectorBindingPanelAction actionImportConnectorBinding;
    private ConnectorBindingPanelAction actionExportConnectorBinding;
    private ConnectorBindingPanelAction actionDeleteConnectorBinding;
    private ConnectorBindingPanelAction actionDupConnectorBinding;
    private static final String NEW_CONNECTOR_TITLE = "New...";
    private static final String IMPORT_CONNECTOR_TITLE = "Import...";
    private static final String EXPORT_CONNECTOR_TITLE = "Export...";
    private static final String DELETE_CONNECTOR_TITLE = "Delete";
    private static final String DUP_CONNECTOR_TITLE = "Clone";
    private static final String EXPORT_EXTENSION = DeployPkgUtils.getString("ecbp.export.extension");
    private ConnectionInfo connection;
    private TableWidget table;
    private DefaultTableModel tableModel;
    private ButtonWidget newButton;
    private ButtonWidget importButton;
    private ButtonWidget exportButton;
    private ButtonWidget deleteButton;
    private ButtonWidget dupButton;
    private BindingDetailsPanel detailsPanel;
    private BindingPropertiesPanel propertiesPanel;
    private BindingVDBsPanel vdbsPanel;
    private List selectedBindings = new ArrayList();
    private ListSelectionListener listSelectionListener;
    private JTabbedPane tabbedPane;
    private JSplitPane splitPane;
    private List currentActions = new ArrayList();
    private HashMap nameConnectorBindingMap = null;
    private boolean canModify;

    public ConnectorBindingPanel(ConnectionInfo conn) {
        this.connection = conn;
        this.init();
    }

    private ConnectorManager getConnectorManager() {
        return ModelManager.getConnectorManager(this.connection);
    }

    private ConfigurationManager getConfigurationManager() {
        return ModelManager.getConfigurationManager(this.connection);
    }

    private VdbManager getVdbManager() {
        return ModelManager.getVdbManager(this.connection);
    }

    private void init() {
        UserCapabilities cap = null;
        try {
            cap = UserCapabilities.getInstance();
            this.canModify = cap.canModifyConnectorBindings(this.connection);
            if (this.canModify) {
                this.getConfigurationManager().addConfigurationChangeListener(this);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.createActions();
        this.newButton = new ButtonWidget(NEW_CONNECTOR_TITLE);
        this.importButton = new ButtonWidget(IMPORT_CONNECTOR_TITLE);
        this.exportButton = new ButtonWidget(EXPORT_CONNECTOR_TITLE);
        this.deleteButton = new ButtonWidget(DELETE_CONNECTOR_TITLE);
        this.dupButton = new ButtonWidget(DUP_CONNECTOR_TITLE);
        this.actionExportConnectorBinding.setEnabled(true);
        if (this.canModify) {
            this.setup(this.newButton, this.actionNewConnectorBinding);
            this.actionNewConnectorBinding.setEnabled(true);
            this.setup(this.importButton, this.actionImportConnectorBinding);
            this.actionImportConnectorBinding.setEnabled(true);
            this.setup(this.exportButton, this.actionExportConnectorBinding);
            this.setup(this.deleteButton, this.actionDeleteConnectorBinding);
            this.actionDeleteConnectorBinding.setEnabled(false);
            this.setup(this.dupButton, this.actionDupConnectorBinding);
            this.actionDupConnectorBinding.setEnabled(false);
        } else {
            this.actionNewConnectorBinding.setEnabled(false);
            this.actionImportConnectorBinding.setEnabled(false);
            this.actionDeleteConnectorBinding.setEnabled(false);
            this.actionDupConnectorBinding.setEnabled(false);
        }
        this.tableModel = new DefaultTableModel((Vector)new Vector<String>(Arrays.asList("Connector Binding", "Connector Type")), 0);
        this.table = new TableWidget((TableModel)this.tableModel, true);
        this.table.setEditable(false);
        this.table.sizeColumnsToFitContainer(0);
        this.table.sizeColumnsToFitContainer(1);
        this.table.setSelectionMode(2);
        DefaultTableComparator dtcComparator = (DefaultTableComparator)this.table.getComparator();
        dtcComparator.setIgnoresCase(true);
        EnhancedTableColumnModel columnModel = (EnhancedTableColumnModel)this.table.getColumnModel();
        TableColumn firstColumn = columnModel.getColumn(0);
        columnModel.setColumnSortedAscending((EnhancedTableColumn)firstColumn, true);
        JScrollPane tableSP = new JScrollPane(this.table);
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new GridLayout(1, 4, 5, 5));
        buttonsPanel.add(this.newButton);
        buttonsPanel.add(this.dupButton);
        buttonsPanel.add(this.importButton);
        buttonsPanel.add(this.exportButton);
        buttonsPanel.add(this.deleteButton);
        this.tabbedPane = new JTabbedPane();
        this.detailsPanel = new BindingDetailsPanel(this.connection);
        this.propertiesPanel = new BindingPropertiesPanel(this.canModify, this.connection);
        this.vdbsPanel = new BindingVDBsPanel(this.connection);
        this.tabbedPane.addTab("Details", this.detailsPanel);
        this.tabbedPane.addTab("Properties", this.propertiesPanel);
        this.tabbedPane.addTab("VDBs", this.vdbsPanel);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ev) {
                ConnectorBindingPanel.this.selectedTabChanged();
            }
        });
        this.splitPane = new Splitter(0, true, tableSP, this.tabbedPane);
        this.add(this.splitPane);
        layout.setConstraints(this.splitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        if (this.canModify) {
            this.add(buttonsPanel);
            layout.setConstraints(buttonsPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        }
        this.listSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent ev) {
                ConnectorBindingPanel.this.tableSelectionChanged();
            }
        };
        this.table.getSelectionModel().addListSelectionListener(this.listSelectionListener);
        this.refresh();
    }

    public void createActions() {
        this.actionNewConnectorBinding = new ConnectorBindingPanelAction(0, this);
        this.actionNewConnectorBinding.putValue("Name", NEW_CONNECTOR_TITLE);
        this.addActionToList("action", this.actionNewConnectorBinding);
        this.actionDupConnectorBinding = new ConnectorBindingPanelAction(4, this);
        this.actionDupConnectorBinding.putValue("Name", DUP_CONNECTOR_TITLE);
        this.addActionToList("action", this.actionDupConnectorBinding);
        this.actionImportConnectorBinding = new ConnectorBindingPanelAction(1, this);
        this.actionImportConnectorBinding.putValue("Name", IMPORT_CONNECTOR_TITLE);
        this.addActionToList("action", this.actionImportConnectorBinding);
        this.actionExportConnectorBinding = new ConnectorBindingPanelAction(2, this);
        this.actionExportConnectorBinding.putValue("Name", EXPORT_CONNECTOR_TITLE);
        this.addActionToList("action", this.actionExportConnectorBinding);
        this.actionDeleteConnectorBinding = new ConnectorBindingPanelAction(3, this);
        this.actionDeleteConnectorBinding.putValue("Name", DELETE_CONNECTOR_TITLE);
        this.addActionToList("action", this.actionDeleteConnectorBinding);
    }

    public void addActionToList(String sID, Action act) {
        this.currentActions.add(new MenuEntry(sID, act));
    }

    private void setup(AbstractButton theButton, AbstractPanelAction theAction) {
        theAction.addComponent(theButton);
    }

    private void populateTable() {
        this.tableModel.setNumRows(0);
        try {
            Collection bindings = this.getConnectorManager().getAllConnectorBindings();
            for (ConnectorBinding cb : bindings) {
                Vector<Object> vec = new Vector<Object>(Arrays.asList(null, null, null));
                vec.setElementAt(cb.getName(), 0);
                vec.setElementAt(cb.getComponentTypeID().getName(), 1);
                this.tableModel.addRow(vec);
            }
        }
        catch (Exception ex) {
            ExceptionUtility.showMessage("Retrieve basic connector binding info", ex);
            LogManager.logError((String)"CONNECTOR_BINDINGS", (Throwable)ex, (String)"Error retrieving basic connector binding info.");
        }
        this.forceTableSelection(this.getSelectedConnectorBindings());
    }

    private void forceTableSelection(List bindings) {
        this.table.getSelectionModel().clearSelection();
        for (ConnectorBinding binding : bindings) {
            int rowForSelected = this.rowForBinding(binding.toString());
            if (rowForSelected < 0) continue;
            this.table.getSelectionModel().addSelectionInterval(rowForSelected, rowForSelected);
            this.table.scrollRectToVisible(this.table.getCellRect(rowForSelected, 0, true));
        }
    }

    @Override
    public void postRealize() {
        this.splitPane.setDividerLocation(0.4);
        if (this.table.getRowCount() > 0) {
            this.table.setRowSelectionInterval(0, 0);
        }
    }

    public void newPressed() {
        this.newBindingWanted();
    }

    private void newBindingWanted() {
        ConnectorBinding newConnectorBindingDefn = this.doNewBindingWizard();
        if (newConnectorBindingDefn != null) {
            this.setSelectedConnectorBinding(newConnectorBindingDefn);
            this.refresh();
        }
    }

    private ConnectorBinding doNewBindingWizard() {
        NewBindingWizardController controller = new NewBindingWizardController(this.connection);
        ConnectorBinding binding = (ConnectorBinding)controller.runWizard();
        return binding;
    }

    public void deletePressed() {
        this.checkToDelete(this.selectedBindings);
    }

    private void checkToDelete(List selectedBindings) {
        int totalVDBs = 0;
        Iterator iter = selectedBindings.iterator();
        RuntimeMgmtManager rmm = null;
        boolean connectedToDeletedVDB = false;
        while (iter.hasNext()) {
            ConnectorBinding definition = (ConnectorBinding)iter.next();
            Collection vdbCollection = null;
            try {
                vdbCollection = this.getVdbManager().getVDBsForConnectorBinding(definition.getRoutingUUID());
                if (vdbCollection == null || vdbCollection.isEmpty()) {
                    if (rmm == null) {
                        rmm = ModelManager.getRuntimeMgmtManager(this.connection);
                    }
                    if (rmm.isServiceInSystemState(definition.getName())) {
                        this.showDeleteRefuseServiceIsDeployedDialog();
                        return;
                    }
                }
                for (Object obj : vdbCollection) {
                    BasicVirtualDatabase vdb;
                    if (!(obj instanceof BasicVirtualDatabase) || (vdb = (BasicVirtualDatabase)obj).getStatus() != 4) continue;
                    connectedToDeletedVDB = true;
                    break;
                }
            }
            catch (Exception e) {
                ExceptionUtility.showMessage("Failed testing conn bind where-used", e);
            }
            totalVDBs += vdbCollection.size();
        }
        if (totalVDBs > 0) {
            this.showDeleteRefuseDialog(connectedToDeletedVDB);
        } else {
            this.showDeleteConfirmDialog();
        }
    }

    public void dupPressed() {
        String newName = null;
        ConnectorBindingRenameDialog rename = null;
        ConnectorBinding binding = null;
        try {
            List bindings = this.getSelectedConnectorBindings();
            if (bindings == null || bindings.isEmpty()) {
                StaticUtilities.displayModalDialogWithOK("Unable to Clone a Connector Binding", "Please select a connector binding before trying to clone");
                return;
            }
            Iterator iter = this.getSelectedConnectorBindings().iterator();
            binding = (ConnectorBinding)iter.next();
            rename = new ConnectorBindingRenameDialog(this.connection, binding.getFullName(), "Clone Connector Binding");
            rename.pack();
            rename.show();
        }
        catch (Exception ex) {
            ExceptionUtility.showMessage("Error trying to rename Duplicate Connector Binding", ex);
            return;
        }
        newName = rename.getNewName();
        if (newName == null) {
            return;
        }
        try {
            ConnectorBinding cb = this.getConnectorManager().createConnectorBinding(binding, newName, this.getConfigurationManager().getEditor());
            this.refresh();
            ArrayList<ConnectorBinding> l = new ArrayList<ConnectorBinding>(1);
            l.add(cb);
            this.forceTableSelection(l);
        }
        catch (Exception e) {
            ExceptionUtility.showMessage("Unable to Duplicate Connector Binding", e);
        }
    }

    public void importPressed() {
        Collection bindings = this.doImportBindingWizard();
        if (bindings != null && bindings.size() > 0) {
            this.setSelectedConnectorBinding((ConnectorBinding)bindings.iterator().next());
            this.refresh();
        }
    }

    private Collection doImportBindingWizard() {
        ImportBindingWizardController controller = new ImportBindingWizardController(this.connection);
        Collection bindings = null;
        boolean bBindingWasCreated = controller.runWizard();
        if (bBindingWasCreated) {
            bindings = controller.getConnectorBindings();
            this.populateTable();
        }
        return bindings;
    }

    public void exportPressed() {
        this.doExportBinding();
    }

    private void doExportBinding() {
        if (this.selectedBindings.size() == 0) {
            StaticUtilities.displayModalDialogWithOK("Unable to Export Connector Binding", "Please select a connector binding before trying to export");
            return;
        }
        String[] extensions = (String[])DeployPkgUtils.getObject("ecbp.importexport.extensions");
        FileSystemView view = new FileSystemView();
        String dirTxt = (String)UserPreferences.getInstance().getValue("metamatrix.console.directory");
        if (dirTxt != null) {
            try {
                view.setHome((TreeNode)view.lookup(dirTxt));
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        FileSystemFilter[] filters = null;
        if (extensions != null) {
            FileSystemFilter filter = new FileSystemFilter(view, extensions, DeployPkgUtils.getString("ecbp.importexport.description"));
            filters = new FileSystemFilter[]{filter};
        }
        DirectoryChooserPanel pnlChooser = filters == null ? new DirectoryChooserPanel((DirectoryEntryView)view, 1) : new DirectoryChooserPanel((DirectoryEntryView)view, 1, (DirectoryEntryFilter[])filters);
        pnlChooser.setAcceptButtonLabel(DeployPkgUtils.getString("ecbp.export.open"));
        pnlChooser.setShowPassThruFilter(false);
        String bindingName = null;
        String exportDialogTitle = DeployPkgUtils.getString("ecbp.export.multiple.title");
        if (this.selectedBindings.size() == 1) {
            ConnectorBinding connectorBindingDefn = (ConnectorBinding)this.selectedBindings.get(0);
            bindingName = connectorBindingDefn.getName();
            exportDialogTitle = DeployPkgUtils.getString("ecbp.export.title", new Object[]{bindingName});
            pnlChooser.setInitialFilename(bindingName + EXPORT_EXTENSION);
        } else {
            exportDialogTitle = DeployPkgUtils.getString("ecbp.export.title", new Object[]{"Selected Multiple Bindings"});
            pnlChooser.setInitialFilename("exportedbindings" + EXPORT_EXTENSION);
        }
        DialogWindow.show(this, exportDialogTitle, pnlChooser);
        if (pnlChooser.getSelectedButton() == pnlChooser.getAcceptButton()) {
            DirectoryEntry result = (DirectoryEntry)pnlChooser.getSelectedTreeNode();
            String filename = result.getNamespace();
            int index = filename.lastIndexOf(File.separatorChar);
            String path = filename.substring(0, index);
            UserPreferences.getInstance().setValue("metamatrix.console.directory", path);
            UserPreferences.getInstance().saveChanges();
            try {
                FileOutputStream fileOutput = new FileOutputStream(filename);
                XMLConfigurationImportExportUtility xmlUtil = new XMLConfigurationImportExportUtility();
                String userName = UserCapabilities.getLoggedInUser(this.connection).getName();
                String version = StaticProperties.getVersion();
                Properties props = new Properties();
                props.put("ApplicationCreatedBy", DeployPkgUtils.getString("dmp.console.name"));
                props.put("ApplicationVersion", version);
                props.put("UserCreatedBy", userName);
                int numSelected = this.selectedBindings.size();
                ConnectorBinding[] bindingArray = new ConnectorBinding[numSelected];
                bindingArray = this.selectedBindings.toArray(bindingArray);
                ComponentType[] typeArray = new ComponentType[numSelected];
                for (int i = 0; i < numSelected; ++i) {
                    typeArray[i] = this.getConnectorManager().getConnectorForConnectorBinding((ServiceComponentDefn)bindingArray[i]);
                }
                xmlUtil.exportConnectorBindings((OutputStream)fileOutput, bindingArray, typeArray, props);
            }
            catch (Exception theException) {
                theException.printStackTrace();
                ExceptionUtility.showMessage("Unable to Export Connector Binding", theException);
                LogManager.logError((String)"CONNECTOR_BINDINGS", (Throwable)theException, (String)"Error exporting connector bindings");
            }
        }
    }

    public void showDeleteConfirmDialog() {
        String msg = "Delete selected connector bindings?";
        int response = CenteredOptionPane.showConfirmDialog(ConsoleMainFrame.getInstance(), msg, "Confirm Deletion", 0);
        if (response == 0) {
            try {
                for (ConnectorBinding binding : this.selectedBindings) {
                    this.getConnectorManager().deleteBinding((ServiceComponentDefn)binding);
                }
            }
            catch (Exception ex) {
                ExceptionUtility.showMessage("Delete a Connector Binding", ex);
                LogManager.logError((String)"CONNECTOR_BINDINGS", (Throwable)ex, (String)"Error in deleting connector binding.");
            }
            this.deleteButton.setEnabled(false);
            this.exportButton.setEnabled(false);
            this.refresh();
        }
    }

    public void showDeleteRefuseDialog(boolean connectedToDeletedVDB) {
        StringBuffer sb = new StringBuffer();
        sb.append("Delete not allowed, Connector Binding is currently assigned to 1 or more VDBs.");
        if (connectedToDeletedVDB) {
            sb.append("\n\n The binding may be assigned to a VDB which has been marked for deletion.\n");
            sb.append("All connections to this VDB must be closed before the binding can be deleted.");
        }
        String sTitle = "Delete Not Allowed";
        CenteredOptionPane.showConfirmDialog(ConsoleMainFrame.getInstance(), sb.toString(), sTitle, -1);
    }

    public void showDeleteRefuseServiceIsDeployedDialog() {
        String msg = "Delete not allowed, Connector Binding(s) is running.";
        String sTitle = "Confirm Deletion";
        CenteredOptionPane.showConfirmDialog(ConsoleMainFrame.getInstance(), msg, sTitle, -1);
    }

    private int rowForBinding(String binding) {
        int matchRow = -1;
        int numRows = this.table.getRowCount();
        int row = 0;
        while (row < numRows && matchRow < 0) {
            String curRowBinding = this.table.getValueAt(row, 0).toString();
            if (curRowBinding.equals(binding)) {
                matchRow = row;
                continue;
            }
            ++row;
        }
        return matchRow;
    }

    private void setSelectedConnectorBinding(ConnectorBinding binding) {
        this.selectedBindings.clear();
        this.selectedBindings.add(binding);
    }

    private void setSelectedConnectorBindings(List bindings) {
        this.selectedBindings.clear();
        this.selectedBindings.addAll(bindings);
    }

    private void clearSelectedConnectorBindings() {
        this.selectedBindings.clear();
    }

    private List getSelectedConnectorBindings() {
        return this.selectedBindings;
    }

    @Override
    public void receiveUpdateNotification(RuntimeUpdateNotification notification) {
        if (notification instanceof AddedConnectorBindingNotification) {
            this.refresh();
        }
    }

    @Override
    public void refresh() {
        ArrayList oldSelectedConnectedBindings = new ArrayList(this.getSelectedConnectorBindings());
        try {
            this.getConnectorManager().getConnectorBindings(true);
            this.constructConnectorBindingXref();
            this.populateTable();
        }
        catch (Exception ex) {
            ExceptionUtility.showMessage("Failed while refreshing the Connector Binding list", ex);
            LogManager.logError((String)"CONNECTOR_BINDINGS", (Throwable)ex, (String)"Failed while refreshing the Connector Binding list");
        }
        this.setSelectedConnectorBindings(oldSelectedConnectedBindings);
        this.forceTableSelection(oldSelectedConnectedBindings);
    }

    private void tableSelectionChanged() {
        boolean cancelled = false;
        List bindings = this.getSelectedConnectorBindings();
        if (bindings.size() == 1 && this.anyValueChanged()) {
            ConnectorBinding binding = (ConnectorBinding)bindings.get(0);
            String message = "Save changes to connector binding " + binding + " ?";
            int response = DialogUtility.showPendingChangesDialog(message, this.getConnection().getURL(), this.getConnection().getUser());
            switch (response) {
                case 0: {
                    this.applyProperties();
                    break;
                }
                case 1: {
                    this.resetProperties();
                    break;
                }
                case 2: {
                    cancelled = true;
                    this.table.getSelectionModel().removeListSelectionListener(this.listSelectionListener);
                    ArrayList<ConnectorBinding> newList = new ArrayList<ConnectorBinding>();
                    newList.add(binding);
                    this.forceTableSelection(newList);
                    this.table.getSelectionModel().addListSelectionListener(this.listSelectionListener);
                }
            }
        }
        if (!cancelled) {
            StaticUtilities.startWait(ViewManager.getMainFrame());
            int[] selectedRows = this.table.getSelectedRows();
            int numSelected = selectedRows.length;
            if (numSelected == 0) {
                this.tableSelectionChangedNoneSelected();
            } else if (numSelected == 1) {
                this.tableSelectionChangedOneSelected(selectedRows[0]);
            } else {
                this.tableSelectionChangedMultipleSelected(selectedRows);
            }
            this.forceRepaint();
            StaticUtilities.endWait(ViewManager.getMainFrame());
        }
    }

    private void tableSelectionChangedNoneSelected() {
        this.clearSelectedConnectorBindings();
        this.actionDeleteConnectorBinding.setEnabled(false);
        this.actionExportConnectorBinding.setEnabled(false);
        this.actionDupConnectorBinding.setEnabled(false);
        Border border = this.createTabBorder(null);
        int curTab = this.tabbedPane.getSelectedIndex();
        switch (curTab) {
            case 0: {
                if (this.detailsPanel.getConnectorBinding() == null) break;
                this.detailsPanel.setConnectorBinding(null);
                this.detailsPanel.setBorder(border);
                break;
            }
            case 1: {
                if (this.propertiesPanel.getConnectorBinding() == null) break;
                this.propertiesPanel.setConnectorBinding(null);
                this.propertiesPanel.setBorder(border);
                break;
            }
            case 2: {
                if (this.vdbsPanel.getConnectorBinding() == null) break;
                this.vdbsPanel.setConnectorBinding(null);
                this.vdbsPanel.setBorder(border);
            }
        }
    }

    private void tableSelectionChangedOneSelected(int selectedRow) {
        int convertedRow = this.table.convertRowIndexToModel(selectedRow);
        String selectedName = (String)this.table.getModel().getValueAt(convertedRow, 0);
        ConnectorBinding binding = (ConnectorBinding)this.getConnectorBindingXref().get(selectedName);
        this.setSelectedConnectorBinding(binding);
        this.actionDeleteConnectorBinding.setEnabled(this.canModify);
        this.actionExportConnectorBinding.setEnabled(true);
        this.actionImportConnectorBinding.setEnabled(this.canModify);
        this.actionDupConnectorBinding.setEnabled(this.canModify);
        Border border = this.createTabBorder(binding);
        int curTab = this.tabbedPane.getSelectedIndex();
        switch (curTab) {
            case 0: {
                this.detailsPanel.setConnectorBinding((ServiceComponentDefn)binding);
                this.detailsPanel.setBorder(border);
                break;
            }
            case 1: {
                this.propertiesPanel.setConnectorBinding((ServiceComponentDefn)binding);
                this.propertiesPanel.setBorder(border);
                break;
            }
            case 2: {
                this.vdbsPanel.setConnectorBinding((ServiceComponentDefn)binding);
                this.vdbsPanel.setBorder(border);
            }
        }
    }

    private void tableSelectionChangedMultipleSelected(int[] selectedRows) {
        ArrayList<ConnectorBinding> bindings = new ArrayList<ConnectorBinding>();
        for (int selectedRow : selectedRows) {
            int convertedRow = this.table.convertRowIndexToModel(selectedRow);
            String selectedName = (String)this.table.getModel().getValueAt(convertedRow, 0);
            ConnectorBinding binding = (ConnectorBinding)this.getConnectorBindingXref().get(selectedName);
            bindings.add(binding);
        }
        this.setSelectedConnectorBindings(bindings);
        this.actionDeleteConnectorBinding.setEnabled(this.canModify);
        this.actionExportConnectorBinding.setEnabled(true);
        this.actionImportConnectorBinding.setEnabled(false);
        this.actionDupConnectorBinding.setEnabled(false);
        Border border = this.createTabBorder(null);
        int curTab = this.tabbedPane.getSelectedIndex();
        switch (curTab) {
            case 0: {
                if (this.detailsPanel.getConnectorBinding() == null) break;
                this.detailsPanel.setConnectorBinding(null);
                this.detailsPanel.setBorder(border);
                break;
            }
            case 1: {
                if (this.propertiesPanel.getConnectorBinding() == null) break;
                this.propertiesPanel.setConnectorBinding(null);
                this.propertiesPanel.setBorder(border);
                break;
            }
            case 2: {
                if (this.vdbsPanel.getConnectorBinding() == null) break;
                this.vdbsPanel.setConnectorBinding(null);
                this.vdbsPanel.setBorder(border);
            }
        }
    }

    private void selectedTabChanged() {
        int curTab = this.tabbedPane.getSelectedIndex();
        int numSelected = this.selectedBindings.size();
        ConnectorBinding selectedBinding = null;
        if (numSelected == 1) {
            selectedBinding = (ConnectorBinding)this.selectedBindings.get(0);
        }
        switch (curTab) {
            case 0: {
                boolean needsRefresh;
                if (selectedBinding == null) {
                    needsRefresh = this.detailsPanel.getConnectorBinding() != null;
                } else {
                    boolean bl = needsRefresh = !selectedBinding.equals(this.detailsPanel.getConnectorBinding());
                }
                if (!needsRefresh) break;
                this.detailsPanel.setConnectorBinding((ServiceComponentDefn)selectedBinding);
                this.detailsPanel.setBorder(this.createTabBorder(selectedBinding));
                break;
            }
            case 1: {
                boolean needsRefresh;
                if (selectedBinding == null) {
                    needsRefresh = this.propertiesPanel.getConnectorBinding() != null;
                } else {
                    boolean bl = needsRefresh = !selectedBinding.equals(this.propertiesPanel.getConnectorBinding());
                }
                if (!needsRefresh) break;
                this.propertiesPanel.setConnectorBinding((ServiceComponentDefn)selectedBinding);
                this.propertiesPanel.setBorder(this.createTabBorder(selectedBinding));
                break;
            }
            case 2: {
                boolean needsRefresh;
                if (selectedBinding == null) {
                    needsRefresh = this.vdbsPanel.getConnectorBinding() != null;
                } else {
                    boolean bl = needsRefresh = !selectedBinding.equals(this.vdbsPanel.getConnectorBinding());
                }
                if (!needsRefresh) break;
                this.vdbsPanel.setConnectorBinding((ServiceComponentDefn)selectedBinding);
                this.vdbsPanel.setBorder(this.createTabBorder(selectedBinding));
            }
        }
        this.forceRepaint();
    }

    private Border createTabBorder(ConnectorBinding defn) {
        String title = defn == null ? "" : "Connector Binding:  " + defn.toString();
        TitledBorder border = new TitledBorder(title);
        return border;
    }

    @Override
    public List resume() {
        return this.currentActions;
    }

    @Override
    public String getTitle() {
        return "Connector Bindings";
    }

    @Override
    public ConnectionInfo getConnection() {
        return this.connection;
    }

    private HashMap getConnectorBindingXref() {
        if (this.nameConnectorBindingMap == null) {
            this.constructConnectorBindingXref();
        }
        return this.nameConnectorBindingMap;
    }

    private void constructConnectorBindingXref() {
        this.nameConnectorBindingMap = new HashMap();
        ArrayList connectorsList = null;
        try {
            connectorsList = this.getConnectorManager().getConnectorBindings(false);
        }
        catch (Exception e) {
            ExceptionUtility.showMessage("Failed while loading data into Connector Binding Panel", e);
        }
        Iterator it = connectorsList.iterator();
        ConnectorBinding tempDefn = null;
        while (it.hasNext()) {
            ConnectorAndBinding cab = (ConnectorAndBinding)it.next();
            tempDefn = (ConnectorBinding)cab.getBinding();
            this.nameConnectorBindingMap.put(tempDefn.toString(), tempDefn);
        }
    }

    private void forceRepaint() {
        StaticUtilities.jiggleSplitter(this.splitPane);
    }

    @Override
    public void configurationChanged(ConfigurationChangeEvent theEvent) {
        if (theEvent.getType() == 16) {
            this.refresh();
        }
    }

    private void applyProperties() {
        if (this.propertiesPanel != null) {
            this.propertiesPanel.applyProperties();
        }
    }

    private void resetProperties() {
        if (this.propertiesPanel != null) {
            this.propertiesPanel.resetProperties();
        }
    }

    private boolean anyValueChanged() {
        if (this.propertiesPanel == null) {
            return false;
        }
        return this.propertiesPanel.anyValueChanged();
    }
}

