/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.connectorbinding;

import com.metamatrix.common.log.LogManager;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.ConnectorManager;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.ui.layout.ConsoleMainFrame;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.TextFieldWidget;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ConnectorBindingRenameDialog
extends JDialog {
    private ConnectionInfo connection;
    private boolean cancelled = false;
    private TextFieldWidget nameField;
    private JButton okButton;
    private String title;

    public ConnectorBindingRenameDialog(ConnectionInfo connection, String curName, String title) {
        super(ConsoleMainFrame.getInstance(), title, true);
        this.connection = connection;
        this.title = title;
        this.init(curName);
    }

    private ConnectorManager getConnectorManager() {
        return ModelManager.getConnectorManager(this.connection);
    }

    private void init(String curName) {
        GridBagLayout layout = new GridBagLayout();
        this.getContentPane().setLayout(layout);
        GridBagLayout cl = new GridBagLayout();
        JPanel clonePanel = new JPanel();
        clonePanel.setLayout(cl);
        LabelWidget topRowText = new LabelWidget(this.title + ":");
        TextFieldWidget cloneField = new TextFieldWidget(50);
        cloneField.setEditable(false);
        cloneField.setText(curName);
        clonePanel.add(topRowText);
        clonePanel.add(cloneField);
        cl.setConstraints(topRowText, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 4), 0, 0));
        cl.setConstraints(cloneField, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 4, 0, 0), 0, 0));
        GridBagLayout tl = new GridBagLayout();
        this.nameField = new TextFieldWidget(50);
        JPanel namePanel = new JPanel();
        namePanel.setLayout(tl);
        LabelWidget nameLabel = new LabelWidget("New Connector Binding Name:");
        namePanel.add(nameLabel);
        namePanel.add(this.nameField);
        tl.setConstraints(nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 4), 0, 0));
        tl.setConstraints(this.nameField, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 4, 0, 0), 0, 0));
        JPanel buttonsPanel = new JPanel(new GridLayout(1, 2, 10, 0));
        this.okButton = new ButtonWidget("OK");
        buttonsPanel.add(this.okButton);
        ButtonWidget cancelButton = new ButtonWidget("Cancel");
        buttonsPanel.add(cancelButton);
        this.getContentPane().add(clonePanel);
        this.getContentPane().add(namePanel);
        this.getContentPane().add(buttonsPanel);
        layout.setConstraints(clonePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
        layout.setConstraints(namePanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
        layout.setConstraints(buttonsPanel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 4, 10), 0, 0));
        this.pack();
        Dimension size = this.getSize();
        Point centeringLoc = StaticUtilities.centerFrame(size);
        this.setLocation(centeringLoc);
        this.okButton.setEnabled(false);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ConnectorBindingRenameDialog.this.okPressed();
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ConnectorBindingRenameDialog.this.cancelPressed();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent ev) {
                ConnectorBindingRenameDialog.this.cancelPressed();
            }
        });
        this.nameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent ev) {
                ConnectorBindingRenameDialog.this.nameTextChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent ev) {
                ConnectorBindingRenameDialog.this.nameTextChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent ev) {
                ConnectorBindingRenameDialog.this.nameTextChanged();
            }
        });
        this.nameField.requestFocus();
    }

    private void okPressed() {
        String newName = this.nameField.getText().trim();
        boolean alreadyExists = false;
        boolean continuing = true;
        try {
            alreadyExists = this.getConnectorManager().connectorBindingNameAlreadyExists(newName);
        }
        catch (Exception ex) {
            LogManager.logError((String)"CONNECTOR_BINDINGS", (Throwable)ex, (String)"Error checking for connector binding name uniqueness");
            ExceptionUtility.showMessage("Error checking for connector binding name uniqueness.  Unable to make connector binding name change.", ex);
            this.cancelPressed();
            continuing = false;
        }
        if (continuing) {
            if (alreadyExists) {
                StaticUtilities.displayModalDialogWithOK("Connector Binding Already Exists", "Connector Binding " + newName + " already exists.  " + "Must enter a unique name.");
            } else {
                this.dispose();
            }
        }
    }

    private void cancelPressed() {
        this.cancelled = true;
        this.dispose();
    }

    private void nameTextChanged() {
        int textLen = this.nameField.getText().trim().length();
        this.okButton.setEnabled(textLen > 0);
    }

    public String getNewName() {
        String newName = null;
        if (!this.cancelled) {
            newName = this.nameField.getText().trim();
        }
        return newName;
    }
}

