/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.connectorbinding;

import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationObjectEditor;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.config.api.ProductServiceConfig;
import com.metamatrix.common.config.util.ConfigurationImportExportUtility;
import com.metamatrix.common.config.util.InvalidConfigurationElementException;
import com.metamatrix.common.config.xml.XMLConfigurationImportExportUtility;
import com.metamatrix.common.tree.directory.DirectoryEntry;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.ConfigurationManager;
import com.metamatrix.console.models.ConnectorManager;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.ui.layout.ConsoleMainFrame;
import com.metamatrix.console.ui.util.WizardInterfaceImpl;
import com.metamatrix.console.ui.views.connector.ImportWizardControllerInterface;
import com.metamatrix.console.ui.views.connector.ImportWizardFileSelectorPanel;
import com.metamatrix.console.ui.views.connectorbinding.ImportBindingWizardPSCEnablePanel;
import com.metamatrix.console.ui.views.connectorbinding.ImportBindingWizardRenamePanel;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.platform.admin.api.ConfigurationAdminAPI;
import com.metamatrix.platform.admin.api.ExtensionSourceAdminAPI;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;

public class ImportBindingWizardController
extends WizardInterfaceImpl
implements ImportWizardControllerInterface {
    private static final String CONNECTOR_CLASSPATH = "ConnectorClassPath";
    protected static final int FILE_SELECTOR_PAGE = 0;
    protected static final int CONNECTOR_ID_PAGE = 1;
    protected static final int PSC_ASSIGNMENT_PAGE = 2;
    protected static final int CONFIRMATION_PAGE = 3;
    protected static final int CALLED_FOR_CONNECTOR_TYPE = 1;
    protected static final int CALLED_FOR_CONNECTOR_BINDING = 2;
    protected ImportWizardFileSelectorPanel fileSelectorPanel;
    protected ImportBindingWizardPSCEnablePanel pscEnablePanel;
    private ImportBindingWizardRenamePanel itemRenamePanel;
    private ButtonWidget nextButton;
    private ButtonWidget cancelButton;
    private ButtonWidget finishButton;
    protected JDialog dialog;
    protected int currentPage = -1;
    private String sXMLFileName;
    private Map loadedConnBindings;
    private Map componentTypes;
    private Collection connTypesToCreate;
    private Map renameMapping;
    protected DirectoryEntry deFile = null;
    protected boolean bFinishPressed = false;
    protected String dialogTitle;
    private ConfigurationAdminAPI api;
    protected ConfigurationManager manager;
    protected ConnectorManager connectorManager;
    protected ExtensionSourceAdminAPI extensionAPI;
    private ConfigurationObjectEditor newComponentEditor;
    private ConfigurationImportExportUtility cieuImportUtil;

    public ImportBindingWizardController(ConnectionInfo conn) {
        this.api = ModelManager.getConfigurationAPI(conn);
        this.manager = ModelManager.getConfigurationManager(conn);
        this.connectorManager = ModelManager.getConnectorManager(conn);
        this.extensionAPI = ModelManager.getExtensionSourceAPI(conn);
    }

    public boolean runWizard() {
        this.loadWizard();
        this.dialog = new JDialog((Frame)ConsoleMainFrame.getInstance(), this.dialogTitle);
        this.dialog.setModal(true);
        this.cancelButton = this.getCancelButton();
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ImportBindingWizardController.this.cancelPressed();
            }
        });
        this.nextButton = this.getNextButton();
        this.getBackButton();
        this.finishButton = this.getFinishButton();
        this.finishButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ImportBindingWizardController.this.finishPressed();
            }
        });
        this.dialog.getContentPane().add(this);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent ev) {
                ImportBindingWizardController.this.cancelPressed();
            }
        });
        this.dialog.pack();
        ImportBindingWizardController.setLocationOn(this.dialog);
        this.dialog.show();
        return this.bFinishPressed;
    }

    public static void setLocationOn(Component comp) {
        Point p = StaticUtilities.centerFrame(comp.getSize());
        comp.setLocation(p.x, p.y);
    }

    private void cancelPressed() {
        this.dialog.dispose();
    }

    public Collection getConnectorBindings() {
        return new ArrayList(this.loadedConnBindings.values());
    }

    @Override
    public void importFileSelected() {
        this.nextButton.setEnabled(true);
    }

    public JDialog getDialog() {
        return this.dialog;
    }

    protected void loadWizard() {
        this.fileSelectorPanel = new ImportWizardFileSelectorPanel(this, this, 2);
        this.itemRenamePanel = new ImportBindingWizardRenamePanel(this, this.connectorManager);
        this.pscEnablePanel = new ImportBindingWizardPSCEnablePanel(this, this.connectorManager);
        this.addPage(this.fileSelectorPanel);
        this.addPage(this.itemRenamePanel);
        this.addPage(this.pscEnablePanel);
        this.dialogTitle = "Import Connector Binding(s) Wizard";
        this.currentPage = 0;
    }

    @Override
    public void showPreviousPage() {
        this.goingToPreviousPage();
        super.showPreviousPage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void showNextPage() {
        boolean bContinue = false;
        try {
            StaticUtilities.startWait(this.getDialog().getContentPane());
            bContinue = this.goingToNextPage();
        }
        catch (Exception e) {
            String msgText = "Failed testing new connector binding name for uniqueness";
            ExceptionUtility.showMessage(msgText, e);
        }
        finally {
            StaticUtilities.endWait(this.getDialog().getContentPane());
        }
        if (bContinue) {
            super.showNextPage();
        }
    }

    public void goingToPreviousPage() {
        --this.currentPage;
    }

    public boolean goingToNextPage() {
        boolean bContinue = true;
        switch (this.currentPage) {
            case 0: {
                this.deFile = this.fileSelectorPanel.getSelection();
                this.sXMLFileName = this.deFile.getName();
                if (this.deFile != null) {
                    this.loadConnectorBindings(this.deFile);
                    bContinue = this.doConnectorTypesExists() & this.doConnectorBindingsExist();
                    if (!bContinue) break;
                    this.itemRenamePanel.setConnectorBindings(this.sXMLFileName, this.getConnectorBindingNames(this.loadedConnBindings));
                    break;
                }
                bContinue = false;
                break;
            }
            case 1: {
                this.renameMapping = this.itemRenamePanel.getConnectorBindingMapping();
                if (this.renameMapping == null || this.renameMapping.isEmpty()) {
                    bContinue = false;
                    break;
                }
                this.pscEnablePanel.setNewConnectorBindingInfo(this.renameMapping.values());
                break;
            }
        }
        if (bContinue) {
            ++this.currentPage;
        }
        return bContinue;
    }

    protected void finishPressed() {
        ProductServiceConfig[] enabledConfigs;
        this.bFinishPressed = true;
        Collection newBindings = this.createNewBindings();
        if (this.saveNewItemToServer(newBindings, enabledConfigs = this.pscEnablePanel.getEnabledConfigs())) {
            this.validateExtensions(newBindings);
            this.dialog.dispose();
        }
    }

    private void validateExtensions(Collection bindings) {
        List extensions = null;
        try {
            extensions = this.extensionAPI.getSourceNames();
        }
        catch (Exception err) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        Iterator iter = bindings.iterator();
        while (iter.hasNext()) {
            boolean err = false;
            ConnectorBinding cb = (ConnectorBinding)iter.next();
            List extensionList = this.getExtensionListForBinding(cb);
            for (String extName : extensionList) {
                if (extensions.contains(extName)) continue;
                if (!err) {
                    sb.append("\nThe following extensions are missing for the " + cb.getName() + " connector.");
                    err = true;
                }
                sb.append("\n    " + extName);
            }
        }
        if (sb.length() > 0) {
            String hdr = "Warning: Missing extension modules";
            String msg = "Some required extension modules are missing, connectors may not start properly.\n";
            StaticUtilities.displayModalDialogWithOK(hdr, msg + sb.toString());
        }
    }

    private List getExtensionListForBinding(ConnectorBinding cb) {
        String cp = cb.getProperty(CONNECTOR_CLASSPATH);
        List l = StringUtil.getTokens((String)cp, (String)";");
        ArrayList<String> nl = new ArrayList<String>();
        for (int i = 0; i < l.size(); ++i) {
            String extension = (String)l.get(i);
            int index = extension.indexOf(":");
            nl.add(extension.substring(index + 1));
        }
        return nl;
    }

    private void loadConnectorBindings(DirectoryEntry deFile) {
        ConfigurationObjectEditor coe = this.getNewItemEditor();
        try {
            this.loadConnectorTypes(deFile, false);
            Collection bindings = this.getImportExportUtility().importConnectorBindings(deFile.getInputStream(), coe);
            coe.getDestination().popActions();
            this.loadedConnBindings = new HashMap(bindings.size());
            for (ConnectorBinding t : bindings) {
                this.loadedConnBindings.put(t.getFullName(), t);
            }
        }
        catch (IOException ioe) {
            String msg = "Failed while importing a connector binding(s)";
            String comment = "Error importing connector binding(s), verify the xml file is well formatted.";
            ExceptionUtility.showMessage(msg, comment, ioe);
        }
        catch (Exception e) {
            String msg = "Failed while importing a connector binding.";
            ExceptionUtility.showMessage(msg, e.getMessage(), e);
        }
    }

    private Collection getConnectorBindingNames(Map connbindings) {
        ArrayList<String> names = null;
        names = new ArrayList<String>(connbindings.size());
        for (String t : connbindings.keySet()) {
            names.add(t);
        }
        return names;
    }

    protected Collection loadConnectorTypes(DirectoryEntry deFile, boolean errorIfNoneFound) {
        ConfigurationObjectEditor coe = this.getNewItemEditor();
        Collection cTypes = null;
        try {
            cTypes = this.getImportExportUtility().importComponentTypes(deFile.getInputStream(), coe);
            coe.getDestination().popActions();
            this.componentTypes = new HashMap(cTypes.size());
            for (ComponentType t : cTypes) {
                this.componentTypes.put(t.getFullName(), t);
            }
        }
        catch (IOException ioe) {
            String msg = "Failed while importing a connector type(s)";
            String comment = "Error importing connector type(s), verify the xml file is well formatted.";
            ExceptionUtility.showMessage(msg, comment, ioe);
        }
        catch (InvalidConfigurationElementException ice) {
            if (errorIfNoneFound) {
                String msg = "Failed while importing a connector type(s)";
                String comment = "No connector type(s) found in the file, verify the xml file is well formatted.";
                ExceptionUtility.showMessage(msg, comment, ice);
            } else {
                this.componentTypes = null;
            }
        }
        catch (Exception e) {
            String msg = "Failed while importing a connector type.";
            ExceptionUtility.showMessage(msg, e.getMessage(), e);
        }
        return cTypes;
    }

    protected Collection getConnectorTypeNames() {
        ArrayList<String> names = null;
        names = new ArrayList<String>(this.componentTypes.size());
        for (String t : this.componentTypes.keySet()) {
            names.add(t);
        }
        return names;
    }

    private boolean doConnectorBindingsExist() {
        if (this.loadedConnBindings.isEmpty()) {
            String hdr = "File contains no bindings";
            String msg = "The selected file contains no connector binding definitions, either select a different file to import or go to the connector types panel to import connector types.";
            StaticUtilities.displayModalDialogWithOK(hdr, msg);
            return false;
        }
        return true;
    }

    private boolean doConnectorTypesExists() {
        this.connTypesToCreate = new ArrayList(this.loadedConnBindings.size());
        try {
            for (String name : this.loadedConnBindings.keySet()) {
                ConnectorBinding importedBinding = (ConnectorBinding)this.loadedConnBindings.get(name);
                ComponentType importedtype = this.getConnectorType(importedBinding.getComponentTypeID().getFullName());
                boolean typeExists = this.connectorManager.connectorTypeNameAlreadyExists(importedBinding.getComponentTypeID().getFullName());
                if (typeExists) continue;
                if (importedtype == null) {
                    String hdr = "Connector Not Found";
                    String msg = "The connector  " + importedBinding.getComponentTypeID().getFullName() + " does not exist and is not in the imported file " + this.sXMLFileName + ".  Please import the connector before importing the binding.";
                    StaticUtilities.displayModalDialogWithOK(hdr, msg);
                    return false;
                }
                this.connTypesToCreate.add(importedtype);
            }
        }
        catch (Exception e) {
            String msg = "Failed while verifying connector types for each importer connector binding.";
            ExceptionUtility.showMessage(msg, e);
            return false;
        }
        return true;
    }

    protected ComponentType getConnectorType(String typeName) {
        return (ComponentType)this.componentTypes.get(typeName);
    }

    private Collection createNewBindings() {
        ConfigurationObjectEditor newComponentEditor = this.getNewItemEditor();
        Configuration config = this.manager.getConfig(Configuration.NEXT_STARTUP_ID);
        ArrayList<ConnectorBinding> newBindings = new ArrayList<ConnectorBinding>(this.renameMapping.size());
        if (config == null) {
            Exception e = new Exception("Configuation was not found in order to add the connector binding.");
            String msg = "Failed while creating new connector binding on import.";
            ExceptionUtility.showMessage(msg, e);
            return newBindings;
        }
        try {
            for (ComponentType t : this.connTypesToCreate) {
                this.createNewItem(t);
            }
            for (String name : this.renameMapping.keySet()) {
                String newName = (String)this.renameMapping.get(name);
                ConnectorBinding importedBinding = (ConnectorBinding)this.loadedConnBindings.get(name);
                ConnectorBinding newBinding = newComponentEditor.createConnectorComponent(Configuration.NEXT_STARTUP_ID, importedBinding, newName, null);
                newBindings.add(newBinding);
            }
            this.manager.checkDecryptable(newBindings);
        }
        catch (Exception e) {
            String msg = "Failed while creating new connector binding on import.";
            ExceptionUtility.showMessage(msg, e);
        }
        return newBindings;
    }

    protected boolean createNewItem(ComponentType compType) {
        try {
            this.newComponentEditor = this.getNewItemEditor();
            this.newComponentEditor.createComponentType(compType, null);
        }
        catch (Exception e) {
            String msg = "Failed while creating new connector type on import.";
            ExceptionUtility.showMessage(msg, e);
        }
        return true;
    }

    protected ConfigurationObjectEditor getNewItemEditor() {
        if (this.newComponentEditor == null) {
            try {
                this.newComponentEditor = this.api.createEditor();
            }
            catch (Exception e) {
                String msg = "Import Error: Failed to create editor";
                ExceptionUtility.showMessage(msg, e);
            }
        }
        return this.newComponentEditor;
    }

    protected ConfigurationImportExportUtility getImportExportUtility() {
        if (this.cieuImportUtil == null) {
            try {
                this.cieuImportUtil = new XMLConfigurationImportExportUtility();
            }
            catch (Exception e) {
                ExceptionUtility.showMessage("Failed to get import utility", e);
            }
        }
        return this.cieuImportUtil;
    }

    protected boolean saveNewItemToServer(Collection bindings, ProductServiceConfig[] pscs) {
        try {
            ConfigurationObjectEditor newComponentEditor = this.getNewItemEditor();
            this.connectorManager.createConnectorBinding(bindings, newComponentEditor, pscs);
        }
        catch (Exception e) {
            String msg = "Failed attempting to save changes on server.";
            ExceptionUtility.showMessage(msg, e);
            return false;
        }
        this.manager.setRefreshNeeded();
        return true;
    }
}

