/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.connectorbinding;

import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.console.models.ConnectorManager;
import com.metamatrix.console.ui.util.BasicWizardSubpanelContainer;
import com.metamatrix.console.ui.util.WizardInterface;
import com.metamatrix.console.ui.views.connector.ImportWizardController;
import com.metamatrix.console.ui.views.deploy.util.DeployPkgUtils;
import com.metamatrix.console.ui.views.deploy.util.DeployTableSorter;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.toolbox.ui.widget.CheckBox;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.TableWidget;
import com.metamatrix.toolbox.ui.widget.TextFieldWidget;
import com.metamatrix.toolbox.ui.widget.table.DefaultTableModel;
import com.metamatrix.toolbox.ui.widget.table.EnhancedTableColumn;
import com.metamatrix.toolbox.ui.widget.table.EnhancedTableColumnModel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;

public class ImportBindingWizardRenamePanel
extends BasicWizardSubpanelContainer
implements ActionListener,
TableModelListener {
    private static String[] SERVICE_HDRS = new String[4];
    private static final int CURRENT_NAME_COL = 0;
    private static final int ALREADY_EXIST_COL = 1;
    private static final int NEW_NAME_COL = 2;
    private static final int DO_NOT_IMPORT = 3;
    private static final int COL_COUNT = 4;
    private static final int OK_TO_IMPORT = 1;
    private static final int DO_NO_IMPORT = 0;
    private static final int INVALID_ROW = -1;
    private static final String PANEL_TITLE = "Specify a new name for existing or other binding(s) or select not to import the binding(s).";
    public static SimpleDateFormat DATE_FORMATTER;
    private TableWidget tblBindings;
    private DefaultTableModel tmdlBindings;
    private HashMap mapDoesBindingExist = new HashMap();
    private CheckBox donotimportchk;
    private LabelWidget lblConnectorFileName = new LabelWidget("File Name:");
    private TextFieldWidget txfConnectorFileName = new TextFieldWidget();
    private JPanel pnlOuter = new JPanel();
    private JPanel pnlTable = new JPanel();
    private ConnectorManager connectorManager;
    private Configuration config;
    private int numOfBindingsToImport = 0;
    private int[] bindingState;
    private boolean isDisplayingWarning = false;

    public ImportBindingWizardRenamePanel(WizardInterface wizardInterface, ConnectorManager connecMgr) {
        super(wizardInterface);
        this.connectorManager = connecMgr;
        this.init();
    }

    private void init() {
        this.createTablePanel();
        this.txfConnectorFileName.setEditable(false);
        Insets insDefault = new Insets(3, 3, 3, 3);
        this.pnlOuter.setLayout(new GridBagLayout());
        this.pnlOuter.add((Component)this.lblConnectorFileName, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, insDefault, 0, 0));
        this.pnlOuter.add((Component)this.txfConnectorFileName, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, insDefault, 0, 0));
        this.pnlOuter.add((Component)this.pnlTable, new GridBagConstraints(0, 2, 0, 0, 1.0, 1.0, 10, 1, new Insets(12, 3, 3, 3), 0, 0));
        this.setMainContent(this.pnlOuter);
        this.setStepText(2, PANEL_TITLE);
    }

    private JPanel createTablePanel() {
        this.pnlTable = new JPanel();
        this.pnlTable.setLayout(new GridLayout(1, 1));
        this.tblBindings = new TableWidget();
        this.tblBindings.setComparator(new DeployTableSorter());
        JScrollPane spnServices = new JScrollPane(this.tblBindings);
        this.pnlTable.add(spnServices);
        return this.pnlTable;
    }

    public void setConnectorBindings(String fileName, Collection bindingNames) {
        if (this.bindingState != null) {
            this.tmdlBindings.removeTableModelListener(this);
        }
        this.numOfBindingsToImport = 0;
        this.mapDoesBindingExist.clear();
        this.bindingState = null;
        this.txfConnectorFileName.setText(ImportWizardController.stripFileExtensionFromName(fileName));
        this.tmdlBindings = DeployPkgUtils.setup(this.tblBindings, SERVICE_HDRS, bindingNames.size(), new int[]{2, 3});
        this.populateTable(bindingNames);
        this.tmdlBindings.addTableModelListener(this);
        this.doTableSetup();
        this.resolveForwardButton();
    }

    private boolean okToMoveForward() {
        this.numOfBindingsToImport = 0;
        int numRows = this.tblBindings.getRowCount();
        boolean anyToImport = false;
        block4: for (int i = 0; i < numRows; ++i) {
            switch (this.bindingState[i]) {
                case 1: {
                    anyToImport = true;
                    ++this.numOfBindingsToImport;
                    continue block4;
                }
                case 0: {
                    continue block4;
                }
                default: {
                    return false;
                }
            }
        }
        return anyToImport;
    }

    private int isValidRow(int row) {
        if (row < 0) {
            return -1;
        }
        Boolean doNotImportBool = (Boolean)this.tblBindings.getModel().getValueAt(row, 3);
        if (doNotImportBool == null || doNotImportBool.booleanValue()) {
            return 0;
        }
        Boolean existBool = (Boolean)this.tblBindings.getModel().getValueAt(row, 1);
        String newName = (String)this.tblBindings.getModel().getValueAt(row, 2);
        if (newName != null) {
            newName = newName.trim();
        }
        String binding = (String)this.tblBindings.getModel().getValueAt(row, 0);
        if (existBool.booleanValue() && newName != null && newName.length() == 0) {
            String hdr = "Existing Connector Binding Error";
            String msg = "The connector binding " + binding + " already exists.  " + "Please enter a unique name.";
            this.displayWarning(hdr, msg);
            return -1;
        }
        if (newName != null && newName.length() > 0) {
            try {
                if (this.doesBindingExist(newName)) {
                    String hdr = "Existing Connector Binding Error";
                    String msg = "The new name " + newName + " entered for connector binding " + binding + " already exists.  " + "Please enter another name.";
                    this.displayWarning(hdr, msg);
                    return -1;
                }
            }
            catch (Exception err) {
                ExceptionUtility.showMessage("Error verifying if binding exists", err);
                LogManager.logError((String)"CONNECTOR_BINDINGS", (Throwable)err, (String)(this.getClass() + ":setDomainObject"));
                return -1;
            }
        }
        return 1;
    }

    private void displayWarning(String header, String message) {
        if (!this.isDisplayingWarning) {
            this.isDisplayingWarning = true;
            StaticUtilities.displayModalDialogWithOK(header, message);
            this.isDisplayingWarning = false;
        }
    }

    public Map getConnectorBindingMapping() {
        int numRows = this.tblBindings.getRowCount();
        HashMap<String, String> bindings = new HashMap<String, String>(numRows);
        for (int i = 0; i < numRows; ++i) {
            Boolean doNotImportBool = (Boolean)this.tblBindings.getModel().getValueAt(i, 3);
            if (doNotImportBool != null && doNotImportBool.booleanValue()) continue;
            String newName = (String)this.tblBindings.getModel().getValueAt(i, 2);
            String binding = (String)this.tblBindings.getModel().getValueAt(i, 0);
            if (newName == null || newName.trim().length() == 0) {
                newName = binding;
            }
            bindings.put(binding, newName);
        }
        return bindings;
    }

    private void populateTable(Collection bindings) {
        this.mapBindingExists(bindings);
        this.bindingState = new int[bindings.size()];
        this.tmdlBindings.setRowCount(0);
        try {
            int i = 0;
            if (this.mapDoesBindingExist != null) {
                for (String binding : this.mapDoesBindingExist.keySet()) {
                    Vector<Object> row = new Vector<Object>(SERVICE_HDRS.length);
                    row.setSize(SERVICE_HDRS.length);
                    row.setElementAt(binding, 0);
                    String newName = (String)this.mapDoesBindingExist.get(binding);
                    Boolean bindingexist = newName == null ? Boolean.FALSE : Boolean.TRUE;
                    row.setElementAt(bindingexist, 1);
                    row.setElementAt(newName, 2);
                    row.setElementAt(Boolean.FALSE, 3);
                    this.tmdlBindings.addRow(row);
                    this.bindingState[i] = 1;
                    TableCellEditor editor = this.tblBindings.getCellEditor(i, 3);
                    this.donotimportchk = (CheckBox)editor.getTableCellEditorComponent(this.tblBindings, Boolean.FALSE, false, i, 3);
                    this.donotimportchk.addActionListener(this);
                    ++i;
                }
            }
        }
        catch (Exception theException) {
            ExceptionUtility.showMessage("  ", theException);
            LogManager.logError((String)"CONNECTOR_BINDINGS", (Throwable)theException, (String)(this.getClass() + ":setDomainObject"));
        }
    }

    private void doTableSetup() {
        this.tblBindings.sizeColumnsToFitData();
        EnhancedTableColumnModel etcm = this.tblBindings.getEnhancedColumnModel();
        TableColumn column = etcm.getColumn(1);
        this.tblBindings.sizeColumnToFitData((EnhancedTableColumn)column);
        column = etcm.getColumn(3);
        this.tblBindings.sizeColumnToFitData((EnhancedTableColumn)column);
        column = etcm.getColumn(0);
        this.tblBindings.sizeColumnToFitData((EnhancedTableColumn)column);
        column = etcm.getColumn(2);
        this.tblBindings.sizeColumnToFitData((EnhancedTableColumn)column);
        this.sortTable();
    }

    private void sortTable() {
        EnhancedTableColumnModel etcmBindings = this.tblBindings.getEnhancedColumnModel();
        TableColumn clmCurrentColumn = etcmBindings.getColumn(0);
        etcmBindings.setColumnSortedAscending((EnhancedTableColumn)clmCurrentColumn, false);
    }

    private void mapBindingExists(Collection bindings) {
        this.mapDoesBindingExist.clear();
        try {
            this.config = this.getNextStartupConfig();
            Collection colPsc = this.connectorManager.getAllConnectorsPSCsByConfig(this.config);
            if (colPsc != null) {
                for (String binding : bindings) {
                    String name = null;
                    if (this.config.getConnectorBinding(binding) != null) {
                        name = this.nextBindingName(binding);
                    }
                    this.mapDoesBindingExist.put(binding, name);
                }
            }
        }
        catch (Exception theException) {
            ExceptionUtility.showMessage("  ", theException);
            LogManager.logError((String)"CONNECTOR_BINDINGS", (Throwable)theException, (String)(this.getClass() + ":setDomainObject"));
        }
    }

    private String nextBindingName(String bindingName) throws Exception {
        int next = 1;
        boolean foundName = false;
        while (!foundName) {
            String newName = bindingName + "_" + next;
            if (!this.doesBindingExist(newName)) {
                return newName;
            }
            ++next;
        }
        return "ChangeTheBindingName";
    }

    private boolean doesBindingExist(String sName) throws Exception {
        return this.connectorManager.connectorBindingNameAlreadyExists(sName);
    }

    @Override
    public void tableChanged(TableModelEvent theEvent) {
        int isvalid;
        int iSelectedRow = theEvent.getFirstRow();
        if (iSelectedRow == -1) {
            return;
        }
        AbstractButton forwardButton = this.getWizardInterface().getForwardButton();
        this.bindingState[iSelectedRow] = isvalid = this.isValidRow(iSelectedRow);
        forwardButton.setEnabled(this.okToMoveForward());
    }

    @Override
    public void actionPerformed(ActionEvent theEvent) {
        Object source = theEvent.getSource();
        if (source instanceof CheckBox) {
            int row = this.tblBindings.getSelectedRow();
            int column = this.tblBindings.getSelectedColumn();
            if (row != -1 || column != -1) {
                this.tblBindings.getCellEditor(row, column).stopCellEditing();
            }
            AbstractButton forwardButton = this.getWizardInterface().getForwardButton();
            forwardButton.setEnabled(this.okToMoveForward());
        }
    }

    @Override
    public void resolveForwardButton() {
        AbstractButton forwardButton = this.getWizardInterface().getForwardButton();
        forwardButton.setEnabled(this.okToMoveForward());
    }

    private Configuration getNextStartupConfig() {
        Configuration cfg = null;
        try {
            cfg = this.connectorManager.getNextStartupConfig();
        }
        catch (Exception e) {
            ExceptionUtility.showMessage("Failed retrieving the Next Startup Config", e);
        }
        return cfg;
    }

    static {
        ImportBindingWizardRenamePanel.SERVICE_HDRS[0] = "Current Name";
        ImportBindingWizardRenamePanel.SERVICE_HDRS[1] = "Exist";
        ImportBindingWizardRenamePanel.SERVICE_HDRS[2] = "New Name";
        ImportBindingWizardRenamePanel.SERVICE_HDRS[3] = "Do Not Import";
        String pattern = DeployPkgUtils.getString("pfp.datepattern", true);
        if (pattern == null) {
            pattern = "MMM dd, yyyy hh:mm:ss";
        }
        DATE_FORMATTER = new SimpleDateFormat(pattern);
    }
}

