/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.connectorbinding;

import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.ConnectorManager;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.ui.util.BasicWizardSubpanelContainer;
import com.metamatrix.console.ui.util.WizardInterface;
import com.metamatrix.console.ui.util.property.GuiComponentFactory;
import com.metamatrix.console.ui.util.property.TypeConstants;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.TextFieldWidget;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class NewBindingWizardConnectorSelectPanel
extends BasicWizardSubpanelContainer
implements TypeConstants {
    private LabelWidget lblConnectorName = new LabelWidget("*Connector Type:");
    private TextFieldWidget txfBindingName = GuiComponentFactory.createTextField("connectorbindingname");
    private LabelWidget lblBindingName = new LabelWidget("*Binding Name:");
    private JPanel pnlOuter = new JPanel();
    private HashMap hmNameConnectorXref = null;
    private ArrayList arylConnectors = null;
    private JComboBox cbxConnectorSelection;
    private DefaultComboBoxModel cbxmdlConnectorSelectionModel;
    private boolean hasBeenPainted = false;
    private ConnectionInfo connection = null;

    public NewBindingWizardConnectorSelectPanel(WizardInterface wizardInterface, ConnectionInfo connection) {
        super(wizardInterface);
        this.connection = connection;
        this.init();
    }

    private ConnectorManager getConnectorManager() {
        return ModelManager.getConnectorManager(this.connection);
    }

    private void init() {
        this.setBoldFont(this.lblBindingName);
        this.setBoldFont(this.lblConnectorName);
        LabelWidget requiredFieldLabel = new LabelWidget("*Required field");
        this.setBoldFont(requiredFieldLabel);
        GridBagLayout layout = new GridBagLayout();
        this.pnlOuter.setLayout(layout);
        this.pnlOuter.add(this.lblBindingName);
        this.pnlOuter.add(this.txfBindingName);
        this.pnlOuter.add(this.lblConnectorName);
        JComboBox connectorComboBox = this.getComboBox();
        this.pnlOuter.add(connectorComboBox);
        this.pnlOuter.add(requiredFieldLabel);
        layout.setConstraints(this.lblBindingName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        layout.setConstraints(this.txfBindingName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        layout.setConstraints(this.lblConnectorName, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        layout.setConstraints(connectorComboBox, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        layout.setConstraints(requiredFieldLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 12, 0, new Insets(15, 5, 5, 5), 0, 0));
        this.setMainContent(this.pnlOuter);
        this.setStepText(1, "Specify a Name and Select a Connector Type for this Connector Binding.");
        this.txfBindingName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent ev) {
            }

            @Override
            public void insertUpdate(DocumentEvent ev) {
                try {
                    String text = ev.getDocument().getText(0, ev.getDocument().getLength());
                    text = text.trim();
                    AbstractButton forwardButton = NewBindingWizardConnectorSelectPanel.this.getWizardInterface().getForwardButton();
                    forwardButton.setEnabled(text.length() > 0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public void removeUpdate(DocumentEvent ev) {
                try {
                    String text = ev.getDocument().getText(0, ev.getDocument().getLength());
                    text = text.trim();
                    AbstractButton forwardButton = NewBindingWizardConnectorSelectPanel.this.getWizardInterface().getForwardButton();
                    forwardButton.setEnabled(text.length() > 0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    private JComboBox getComboBox() {
        if (this.cbxConnectorSelection == null) {
            this.cbxConnectorSelection = new JComboBox();
            this.cbxmdlConnectorSelectionModel = new DefaultComboBoxModel();
            this.cbxConnectorSelection.setModel(this.cbxmdlConnectorSelectionModel);
            this.hmNameConnectorXref = null;
            this.arylConnectors = this.getConnectorManager().getConnectors();
            for (ComponentType ctConnector : this.arylConnectors) {
                if (!ctConnector.isDeployable()) continue;
                this.getConnectorXref().put(ctConnector.getName(), ctConnector);
                this.cbxmdlConnectorSelectionModel.addElement(ctConnector.getName());
            }
        }
        return this.cbxConnectorSelection;
    }

    public String getNewBindingName() {
        return this.txfBindingName.getText();
    }

    public ComponentType getSelectedConnector() {
        DefaultComboBoxModel mdl = (DefaultComboBoxModel)this.cbxConnectorSelection.getModel();
        String sSelectedConnector = (String)mdl.getSelectedItem();
        ComponentType ctConnector = (ComponentType)this.getConnectorXref().get(sSelectedConnector);
        return ctConnector;
    }

    private HashMap getConnectorXref() {
        if (this.hmNameConnectorXref == null) {
            this.hmNameConnectorXref = new HashMap();
        }
        return this.hmNameConnectorXref;
    }

    private void setBoldFont(LabelWidget label) {
        Font tempFont = label.getFont();
        Font newFont = new Font(tempFont.getName(), 1, tempFont.getSize());
        label.setFont(newFont);
    }

    @Override
    public void paint(Graphics g) {
        if (!this.hasBeenPainted) {
            AbstractButton forwardButton = this.getWizardInterface().getForwardButton();
            forwardButton.setEnabled(false);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NewBindingWizardConnectorSelectPanel.this.txfBindingName.requestFocus();
                }
            });
            this.hasBeenPainted = true;
        }
        super.paint(g);
    }
}

