/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.connectorbinding;

import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.ConfigurationObjectEditor;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.config.api.ProductServiceConfig;
import com.metamatrix.common.config.api.ServiceComponentDefn;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.ConnectorManager;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.ui.layout.ConsoleMainFrame;
import com.metamatrix.console.ui.util.WizardInterfaceImpl;
import com.metamatrix.console.ui.views.connectorbinding.NewBindingWizardConnectorSelectPanel;
import com.metamatrix.console.ui.views.connectorbinding.NewBindingWizardPSCEnablePanel;
import com.metamatrix.console.ui.views.connectorbinding.NewBindingWizardSpecificationPanel;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;

public class NewBindingWizardController
extends WizardInterfaceImpl {
    private static final int CONNECTOR_SELECT_PAGE_NUM = 0;
    private static final int SPECIFICATION_PAGE_NUM = 1;
    private static final int PSC_ENABLE_PAGE_NUM = 2;
    private NewBindingWizardConnectorSelectPanel connectorSelectPanel;
    private ComponentType currentlySelectedConnector = null;
    private String sNewCBName = null;
    private NewBindingWizardSpecificationPanel specsPanel;
    private NewBindingWizardPSCEnablePanel pscEnablePanel;
    private JDialog dialog;
    private int currentPage = -1;
    private ButtonWidget nextButton;
    private ButtonWidget cancelButton;
    private ButtonWidget finishButton;
    private ServiceComponentDefn scdNewConnectorBinding = null;
    private ConnectionInfo connection;

    public NewBindingWizardController(ConnectionInfo connection) {
        this.connection = connection;
    }

    private ConnectorManager getConnectorManager() {
        return ModelManager.getConnectorManager(this.connection);
    }

    public ServiceComponentDefn runWizard() {
        this.connectorSelectPanel = new NewBindingWizardConnectorSelectPanel(this, this.connection);
        this.specsPanel = new NewBindingWizardSpecificationPanel(this, this.connection);
        this.pscEnablePanel = new NewBindingWizardPSCEnablePanel(this, this.connection);
        if (this.connectorSelectPanel != null && this.specsPanel != null && this.pscEnablePanel != null) {
            this.addPage(this.connectorSelectPanel);
            this.addPage(this.specsPanel);
            this.addPage(this.pscEnablePanel);
            this.dialog = new JDialog((Frame)ConsoleMainFrame.getInstance(), "Create New Connector Binding Wizard");
            this.dialog.setModal(true);
            this.cancelButton = this.getCancelButton();
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    NewBindingWizardController.this.cancelPressed();
                }
            });
            this.getBackButton();
            this.finishButton = this.getFinishButton();
            this.finishButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    NewBindingWizardController.this.finishPressed();
                }
            });
            this.nextButton = this.getNextButton();
            this.dialog.getContentPane().add(this);
            this.dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent ev) {
                    NewBindingWizardController.this.cancelPressed();
                }
            });
            this.dialog.pack();
            this.currentPage = 0;
            NewBindingWizardController.setLocationOn(this.dialog);
            this.dialog.show();
        }
        return this.scdNewConnectorBinding;
    }

    private void cancelPressed() {
        this.dialog.dispose();
    }

    public void importFileSelected() {
        this.nextButton.setEnabled(true);
    }

    private void finishPressed() {
        this.createBinding();
        this.dialog.dispose();
    }

    public JDialog getDialog() {
        return this.dialog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void showNextPage() {
        boolean bContinue = false;
        try {
            StaticUtilities.startWait(this.getDialog().getContentPane());
            bContinue = this.goingToNextPage();
        }
        catch (Exception e) {
            ExceptionUtility.showMessage("Failed testing new connector binding name for uniqueness", e);
        }
        finally {
            StaticUtilities.endWait(this.getDialog().getContentPane());
        }
        if (bContinue) {
            ++this.currentPage;
            super.showNextPage();
        }
    }

    @Override
    public void showPreviousPage() {
        this.goingToPreviousPage();
        --this.currentPage;
        super.showPreviousPage();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension unadjusted = super.getPreferredSize();
        return new Dimension(Math.max(unadjusted.width, (int)((double)screenSize.width * 0.7)), unadjusted.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean goingToNextPage() {
        bContinue = true;
        switch (this.currentPage) {
            case 0: {
                bNameIsUnique = false;
                bNameIsUnique = this.nameIsUnique();
                if (!bNameIsUnique) ** GOTO lbl20
                connector = this.connectorSelectPanel.getSelectedConnector();
                typeChanged = connector.equals(this.currentlySelectedConnector) == false;
                v0 = nameChanged = this.sNewCBName == null || this.sNewCBName.equals(this.connectorSelectPanel.getNewBindingName()) == false;
                if (!typeChanged && !nameChanged) ** GOTO lbl20
                try {
                    StaticUtilities.startWait(this.dialog.getContentPane());
                    this.specsPanel.updatePropertiedObjectPanel(this.connectorSelectPanel.getSelectedConnector(), this.connectorSelectPanel.getNewBindingName(), typeChanged);
                }
                finally {
                    StaticUtilities.endWait(this.dialog.getContentPane());
                }
                this.currentlySelectedConnector = connector;
                this.sNewCBName = this.connectorSelectPanel.getNewBindingName();
lbl20:
                // 3 sources

                if (!(bContinue = bNameIsUnique)) break;
                this.enableNextButton(true);
                this.specsPanel.setButtons();
                break;
            }
            case 1: {
                this.pscEnablePanel.setNewConnectorBindingInfo(this.getNewBindingName(), this.getSelectedConnectorName());
                break;
            }
        }
        return bContinue;
    }

    public void goingToPreviousPage() {
        this.enableNextButton(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean nameIsUnique() {
        String sName = this.connectorSelectPanel.getNewBindingName();
        boolean bNameNotUnique = false;
        boolean isConnectionPoolName = false;
        try {
            StaticUtilities.startWait(this.dialog.getContentPane());
            bNameNotUnique = this.getConnectorManager().connectorBindingNameAlreadyExists(sName);
        }
        catch (Exception e) {
            ExceptionUtility.showMessage("Failed testing new connector binding name for uniqueness", e);
        }
        finally {
            StaticUtilities.endWait(this.dialog.getContentPane());
        }
        if (bNameNotUnique) {
            StaticUtilities.displayModalDialogWithOK("Binding Already Exists", "A Connector Binding already exists with the name \"" + sName + "\".  Please enter a unique name.");
        } else if (isConnectionPoolName) {
            StaticUtilities.displayModalDialogWithOK("Name is In Use", "A Connection Pool already exists with the name \"" + sName + "\".  A Connector Binding cannot have the same name as a " + "Connection Pool.  Please enter a unique name.");
        }
        return !bNameNotUnique && !isConnectionPoolName;
    }

    private ComponentType getSelectedConnector() {
        return this.connectorSelectPanel.getSelectedConnector();
    }

    private String getSelectedConnectorName() {
        String sName = "";
        if (this.getSelectedConnector() != null) {
            sName = this.getSelectedConnector().getName();
        }
        return sName;
    }

    private String getNewBindingName() {
        return this.connectorSelectPanel.getNewBindingName();
    }

    public static void setLocationOn(Component comp) {
        Point p = StaticUtilities.centerFrame(comp.getSize());
        comp.setLocation(p.x, p.y);
    }

    public void enableNextButton(boolean b) {
        ButtonWidget btnNext = null;
        btnNext = this.getNextButton();
        if (btnNext != null) {
            btnNext.setEnabled(b);
        } else {
            btnNext = this.getFinishButton();
            if (btnNext != null) {
                btnNext.setEnabled(b);
            }
        }
    }

    private void createBinding() {
        ConnectorBinding binding = this.specsPanel.getNewConnectorBinding();
        ConfigurationObjectEditor coe = this.specsPanel.getConfigurationObjectEditor();
        ProductServiceConfig[] enabledConfigs = this.pscEnablePanel.getEnabledConfigs();
        try {
            this.getConnectorManager().createConnectorBinding((ServiceComponentDefn)binding, coe, enabledConfigs);
            this.scdNewConnectorBinding = binding;
        }
        catch (Exception ex) {
            String msg = "Error creating connector binding.";
            LogManager.logError((String)"CONNECTOR_BINDINGS", (Throwable)ex, (String)msg);
            ExceptionUtility.showMessage(msg, ex);
        }
    }
}

